/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor;

import cn.easii.tutelary.deps.com.squareup.javapoet.ClassName;
import cn.easii.tutelary.deps.com.squareup.javapoet.CodeBlock;
import cn.easii.tutelary.deps.com.squareup.javapoet.JavaFile;
import cn.easii.tutelary.deps.com.squareup.javapoet.MethodSpec;
import cn.easii.tutelary.deps.com.squareup.javapoet.ParameterSpec;
import cn.easii.tutelary.deps.com.squareup.javapoet.ParameterizedTypeName;
import cn.easii.tutelary.deps.com.squareup.javapoet.TypeName;
import cn.easii.tutelary.deps.com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.AutoMapperProperties;
import io.github.linpeilie.processor.metadata.AbstractAdapterMethodMetadata;
import io.github.linpeilie.processor.metadata.AdapterMapMethodMetadata;
import io.github.linpeilie.processor.metadata.AdapterMethodMetadata;
import io.github.linpeilie.utils.ClassUtil;
import io.github.linpeilie.utils.CollectionUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

public abstract class AbstractAdapterMapperGenerator {
    protected static final String PARAM__PARAMETER_NAME = "param";
    protected static final String CONTEXT__PARAMETER_NAME = "context";

    public void write(ProcessingEnvironment processingEnv, Collection<AbstractAdapterMethodMetadata> adapterMethods, String adapterClassName, boolean cycleAvoiding) {
        this.write(processingEnv, this.createAdapterTypeSpec(adapterClassName, adapterMethods, cycleAvoiding));
    }

    private void write(ProcessingEnvironment processingEnv, TypeSpec typeSpec) {
        if (typeSpec == null) {
            return;
        }
        try (Writer writer = processingEnv.getFiler().createSourceFile(this.adapterPackage() + "." + typeSpec.name, new Element[0]).openWriter();){
            JavaFile.builder((String)this.adapterPackage(), (TypeSpec)typeSpec).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + typeSpec.name + " output file: " + e.getMessage());
        }
    }

    protected TypeSpec createAdapterTypeSpec(String adapterClassName, Collection<AbstractAdapterMethodMetadata> adapterMethods, boolean cycleAvoiding) {
        List<MethodSpec> methods = adapterMethods.stream().filter(method -> !cycleAvoiding || method.needCycleAvoiding()).map(method -> this.buildProxyMethod((AbstractAdapterMethodMetadata)method, cycleAvoiding)).flatMap(Collection::stream).collect(Collectors.toList());
        return this.createTypeSpec(methods, adapterClassName, cycleAvoiding ? ClassName.get((String)this.adapterPackage(), (String)AutoMapperProperties.getAdapterClassName(), (String[])new String[0]) : null);
    }

    protected TypeSpec createTypeSpec(List<MethodSpec> methods, String adapterClassName, ClassName superClass) {
        TypeSpec.Builder adapterBuilder = TypeSpec.classBuilder((ClassName)ClassName.get((String)this.adapterPackage(), (String)adapterClassName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC});
        if (superClass != null) {
            adapterBuilder.superclass((TypeName)superClass);
        }
        if (CollectionUtils.isNotEmpty(methods)) {
            adapterBuilder.addMethods(methods);
        }
        return adapterBuilder.build();
    }

    protected String adapterPackage() {
        return AutoMapperProperties.getAdapterPackage();
    }

    private TypeName wrapperTypeName(TypeName source) {
        if (source.isPrimitive() || source.isBoxedPrimitive()) {
            return source;
        }
        if ("java.util.Map".contentEquals(source.toString())) {
            return ParameterizedTypeName.get((ClassName)((ClassName)source), (TypeName[])new TypeName[]{ClassName.get((String)"java.lang", (String)"String", (String[])new String[0]), ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0])});
        }
        return source;
    }

    private List<MethodSpec> buildProxyMethod(AbstractAdapterMethodMetadata adapterMethod, boolean cycleAvoiding) {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        if (cycleAvoiding) {
            methodSpecs.addAll(this.buildCycleAvoidingProxyMethod(adapterMethod));
        } else {
            methodSpecs.addAll(this.buildDefaultProxyMethod(adapterMethod, null));
        }
        return methodSpecs;
    }

    protected List<MethodSpec> buildDefaultProxyMethod(AbstractAdapterMethodMetadata adapterMethodMetadata, ClassName annotation) {
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>();
        ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)this.wrapperTypeName(adapterMethodMetadata.getSource()), (String)PARAM__PARAMETER_NAME, (Modifier[])new Modifier[0]).build();
        MethodSpec methodSpecForSingle = this.buildDefaultProxyMethod(adapterMethodMetadata, parameterSpec, adapterMethodMetadata.getReturn(), annotation);
        methodSpecs.add(methodSpecForSingle);
        if (adapterMethodMetadata instanceof AdapterMethodMetadata) {
            ParameterSpec listParameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{adapterMethodMetadata.getSource()}), (String)PARAM__PARAMETER_NAME, (Modifier[])new Modifier[0]).build();
            MethodSpec methodSpecForList = this.buildDefaultProxyMethod(adapterMethodMetadata, listParameter, (TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{adapterMethodMetadata.getReturn()}), annotation);
            methodSpecs.add(methodSpecForList);
        } else if (adapterMethodMetadata instanceof AdapterMapMethodMetadata) {
            methodSpecs.add(this.buildObjConversionProxyMethod(adapterMethodMetadata, annotation));
        }
        return methodSpecs;
    }

    private MethodSpec buildObjConversionProxyMethod(AbstractAdapterMethodMetadata adapterMethod, ClassName annotation) {
        CodeBlock code = CodeBlock.builder().add("if($N == null) {\n", new Object[]{PARAM__PARAMETER_NAME}).add("    return null;\n", new Object[0]).add("}\n", new Object[0]).add("if($N instanceof $T) {\n", new Object[]{PARAM__PARAMETER_NAME, ClassName.get((String)"java.util", (String)"Map", (String[])new String[0])}).add("    return $N((Map<$T, $T>) $N);\n", new Object[]{adapterMethod.getMethodName(), ClassName.get((String)"java.lang", (String)"String", (String[])new String[0]), ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0]), PARAM__PARAMETER_NAME}).add("}\n", new Object[0]).add("return null;\n", new Object[0]).build();
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)("objTo" + ClassUtil.simplifyQualifiedName((String)adapterMethod.getReturn().toString()))).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(ParameterSpec.builder((TypeName)ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0]), (String)PARAM__PARAMETER_NAME, (Modifier[])new Modifier[0]).build()).returns(adapterMethod.getReturn()).addCode(code);
        if (annotation != null) {
            methodSpecBuilder.addAnnotation(annotation);
        }
        return methodSpecBuilder.build();
    }

    private MethodSpec buildDefaultProxyMethod(AbstractAdapterMethodMetadata adapterMethodMetadata, ParameterSpec parameterSpec, TypeName returns, ClassName annotation) {
        CodeBlock targetCode = adapterMethodMetadata.isStatic() ? CodeBlock.of((String)"return $T.$N($N);", (Object[])new Object[]{adapterMethodMetadata.getMapper(), adapterMethodMetadata.getMapperMethodName(), PARAM__PARAMETER_NAME}) : this.proxyMethodTarget(adapterMethodMetadata);
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)adapterMethodMetadata.getMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameterSpec).returns(returns).addCode(targetCode);
        if (annotation != null) {
            methodSpecBuilder.addAnnotation(annotation);
        }
        return methodSpecBuilder.build();
    }

    protected List<MethodSpec> buildCycleAvoidingProxyMethod(AbstractAdapterMethodMetadata adapterMethodMetadata) {
        List<MethodSpec> defaultMethods = this.buildDefaultProxyMethod(adapterMethodMetadata, ClassName.get((String)"io.github.linpeilie.annotations", (String)"DoIgnore", (String[])new String[0]));
        ArrayList<MethodSpec> methodSpecs = new ArrayList<MethodSpec>(defaultMethods);
        ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)this.wrapperTypeName(adapterMethodMetadata.getSource()), (String)PARAM__PARAMETER_NAME, (Modifier[])new Modifier[0]).build();
        methodSpecs.add(this.buildCycleAvoidingProxyMethod(adapterMethodMetadata, parameterSpec, adapterMethodMetadata.getReturn()));
        if (adapterMethodMetadata instanceof AdapterMethodMetadata) {
            ParameterSpec listParameter = ParameterSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]), (TypeName[])new TypeName[]{adapterMethodMetadata.getSource()}), (String)PARAM__PARAMETER_NAME, (Modifier[])new Modifier[0]).build();
            MethodSpec methodSpecForList = this.buildCycleAvoidingProxyMethod(adapterMethodMetadata, listParameter, (TypeName)ClassName.get((String)"java.util", (String)"List", (String[])new String[0]));
            methodSpecs.add(methodSpecForList);
        }
        return methodSpecs;
    }

    private MethodSpec buildCycleAvoidingProxyMethod(AbstractAdapterMethodMetadata adapterMethodMetadata, ParameterSpec parameterSpec, TypeName returns) {
        CodeBlock targetCode = adapterMethodMetadata.isStatic() ? CodeBlock.of((String)"return $T.$N($N, $N);", (Object[])new Object[]{adapterMethodMetadata.getMapper(), adapterMethodMetadata.getMapperMethodName(), PARAM__PARAMETER_NAME, CONTEXT__PARAMETER_NAME}) : this.cycleAvoidingMethodTarget(adapterMethodMetadata);
        ParameterSpec contextParameterSpec = ParameterSpec.builder((TypeName)ClassName.get((String)"io.github.linpeilie", (String)"CycleAvoidingMappingContext", (String[])new String[0]), (String)CONTEXT__PARAMETER_NAME, (Modifier[])new Modifier[0]).addAnnotation(ClassName.get((String)"org.mapstruct", (String)"Context", (String[])new String[0])).build();
        return MethodSpec.methodBuilder((String)adapterMethodMetadata.getMethodName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameterSpec).addParameter(contextParameterSpec).returns(returns).addCode(targetCode).build();
    }

    protected abstract CodeBlock proxyMethodTarget(AbstractAdapterMethodMetadata var1);

    protected abstract CodeBlock cycleAvoidingMethodTarget(AbstractAdapterMethodMetadata var1);
}

