/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.exec;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.smallrye.common.os.OS;
import io.smallrye.common.process.ProcessUtil;
import java.io.File;
import java.nio.file.Path;

public class Executable {
    public static File findExecutableFile(String base) {
        String path = null;
        Object executable = base;
        if (OS.current() == OS.WINDOWS) {
            executable = base + ".cmd";
            path = Executable.findExecutable((String)executable);
            if (path == null) {
                executable = base + ".bat";
                path = Executable.findExecutable((String)executable);
            }
        } else {
            executable = base;
            path = Executable.findExecutable((String)executable);
        }
        if (path == null) {
            return null;
        }
        return new File(path, (String)executable);
    }

    public static String findExecutable(String exec) {
        return ProcessUtil.pathOfCommand((Path)Path.of(exec, new String[0])).map(Object::toString).orElse(null);
    }

    public static File findExecutable(String name, String errorMessage, MessageWriter output) {
        File command = Executable.findExecutableFile(name);
        if (command == null) {
            output.error(errorMessage);
            throw new RuntimeException("Unable to find " + name + " command");
        }
        return command;
    }

    public static File findWrapper(Path projectRoot, String[] windows, String other) {
        Path normalizedPath;
        if (projectRoot == null) {
            return null;
        }
        if (OS.current() == OS.WINDOWS) {
            for (String name : windows) {
                File wrapper = new File(String.valueOf(projectRoot) + File.separator + name);
                if (!wrapper.isFile()) continue;
                return wrapper;
            }
        } else {
            File wrapper = new File(String.valueOf(projectRoot) + File.separator + other);
            if (wrapper.isFile()) {
                return wrapper;
            }
        }
        if (!(normalizedPath = projectRoot.normalize()).equals(projectRoot.getRoot())) {
            return Executable.findWrapper(normalizedPath.getParent(), windows, other);
        }
        return null;
    }
}

