/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.config;

import io.restassured.config.Config;
import io.restassured.config.LogConfig;
import io.restassured.filter.log.LogDetail;
import io.restassured.internal.common.assertion.AssertParameter;
import java.net.URI;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class CsrfConfig
implements Config {
    public static final String DEFAULT_CSRF_HEADER_NAME = "X-CSRF-TOKEN";
    public static final String DEFAULT_CSRF_INPUT_FIELD_NAME = "_csrf";
    public static final String DEFAULT_CSRF_META_TAG_NAME = "_csrf_header";
    private final boolean automaticallyApplyCookies;
    private final boolean isUserConfigured;
    private final String csrfTokenPath;
    private final String csrfInputFieldName;
    private final String csrfMetaTagName;
    private final String csrfHeaderName;
    private final CsrfPrioritization csrfPrioritization;
    private final LogConfig logConfig;
    private final LogDetail logDetail;

    public CsrfConfig() {
        this(null, DEFAULT_CSRF_INPUT_FIELD_NAME, DEFAULT_CSRF_META_TAG_NAME, DEFAULT_CSRF_HEADER_NAME, CsrfPrioritization.HEADER, null, null, true, false);
    }

    public CsrfConfig(String csrfTokenPath) {
        this((String)AssertParameter.notNull((Object)StringUtils.trimToNull((String)csrfTokenPath), (String)"csrfTokenPath"), DEFAULT_CSRF_INPUT_FIELD_NAME, DEFAULT_CSRF_META_TAG_NAME, DEFAULT_CSRF_HEADER_NAME, CsrfPrioritization.HEADER, null, null, true, true);
    }

    public CsrfConfig(URI csrfTokenPath) {
        this(((URI)AssertParameter.notNull((Object)csrfTokenPath, (String)"csrfTokenPath")).toString());
    }

    public CsrfConfig(URL csrfTokenPath) {
        this(((URL)AssertParameter.notNull((Object)csrfTokenPath, (String)"csrfTokenPath")).toString());
    }

    private CsrfConfig(String csrfTokenPath, String csrfInputFieldName, String csrfMetaTagName, String csrfHeaderName, CsrfPrioritization csrfPrioritization, LogConfig logConfig, LogDetail logDetail, boolean automaticallyApplyCookies, boolean isUserConfigured) {
        AssertParameter.notNull((Object)((Object)csrfPrioritization), CsrfPrioritization.class);
        AssertParameter.notNull((Object)StringUtils.trimToNull((String)csrfInputFieldName), (String)"csrfInputFieldName");
        AssertParameter.notNull((Object)StringUtils.trimToNull((String)csrfMetaTagName), (String)"csrfMetaTagName");
        AssertParameter.notNull((Object)StringUtils.trimToNull((String)csrfHeaderName), (String)"csrfHeaderName");
        this.csrfTokenPath = StringUtils.trimToNull((String)csrfTokenPath);
        this.csrfInputFieldName = StringUtils.trimToNull((String)csrfInputFieldName);
        this.csrfMetaTagName = StringUtils.trimToNull((String)csrfMetaTagName);
        this.csrfHeaderName = StringUtils.trimToNull((String)csrfHeaderName);
        this.csrfPrioritization = csrfPrioritization;
        this.logConfig = logConfig;
        this.logDetail = logDetail;
        this.isUserConfigured = isUserConfigured;
        this.automaticallyApplyCookies = automaticallyApplyCookies;
    }

    @Override
    public boolean isUserConfigured() {
        return this.isUserConfigured;
    }

    public boolean isCsrfEnabled() {
        return this.csrfTokenPath != null;
    }

    public static CsrfConfig csrfConfig() {
        return new CsrfConfig();
    }

    public CsrfConfig csrfMetaTagName(String csrfMetaTagName) {
        AssertParameter.notNull((Object)StringUtils.trimToNull((String)csrfMetaTagName), (String)"CSRF meta tag name");
        return new CsrfConfig(this.csrfTokenPath, csrfMetaTagName, csrfMetaTagName, this.csrfHeaderName, this.csrfPrioritization, this.logConfig, this.logDetail, this.automaticallyApplyCookies, true);
    }

    public CsrfConfig csrfInputFieldName(String inputFieldName) {
        AssertParameter.notNull((Object)StringUtils.trimToNull((String)inputFieldName), (String)"CSRF input field name");
        return new CsrfConfig(this.csrfTokenPath, inputFieldName, this.csrfMetaTagName, this.csrfHeaderName, this.csrfPrioritization, this.logConfig, this.logDetail, this.automaticallyApplyCookies, true);
    }

    public CsrfConfig loggingEnabled() {
        return this.loggingEnabled(LogDetail.ALL);
    }

    public CsrfConfig loggingEnabled(LogDetail logDetail) {
        return this.loggingEnabled(logDetail, new LogConfig());
    }

    public CsrfConfig loggingEnabled(LogConfig logConfig) {
        return this.loggingEnabled(LogDetail.ALL, logConfig);
    }

    public CsrfConfig loggingEnabled(LogDetail logDetail, LogConfig logConfig) {
        AssertParameter.notNull((Object)((Object)logDetail), LogDetail.class);
        AssertParameter.notNull((Object)logConfig, LogConfig.class);
        return new CsrfConfig(this.csrfTokenPath, this.csrfInputFieldName, this.csrfMetaTagName, this.csrfHeaderName, this.csrfPrioritization, logConfig, logDetail, this.automaticallyApplyCookies, true);
    }

    public CsrfConfig csrfHeaderName(String csrfHeaderName) {
        AssertParameter.notNull((Object)StringUtils.trimToNull((String)csrfHeaderName), (String)"CSRF header name");
        return new CsrfConfig(this.csrfTokenPath, this.csrfInputFieldName, this.csrfMetaTagName, csrfHeaderName, this.csrfPrioritization, this.logConfig, this.logDetail, this.automaticallyApplyCookies, true);
    }

    public CsrfConfig with() {
        return this;
    }

    public CsrfConfig and() {
        return this;
    }

    public CsrfPrioritization getCsrfPrioritization() {
        return this.csrfPrioritization;
    }

    public boolean isCsrfPrioritization(CsrfPrioritization csrfPrioritization) {
        return this.csrfPrioritization == csrfPrioritization;
    }

    public boolean isAutomaticallyApplyCookies() {
        return this.automaticallyApplyCookies;
    }

    public CsrfConfig automaticallyApplyCookies(boolean automaticallyApplyCookies) {
        return new CsrfConfig(this.csrfTokenPath, this.csrfInputFieldName, this.csrfMetaTagName, this.csrfHeaderName, this.csrfPrioritization, this.logConfig, this.logDetail, automaticallyApplyCookies, true);
    }

    public CsrfConfig csrfPrioritization(CsrfPrioritization csrfPrioritization) {
        return new CsrfConfig(this.csrfTokenPath, this.csrfInputFieldName, this.csrfMetaTagName, this.csrfHeaderName, csrfPrioritization, this.logConfig, this.logDetail, this.automaticallyApplyCookies, true);
    }

    public CsrfConfig csrfTokenPath(String csrfTokenPath) {
        return new CsrfConfig((String)AssertParameter.notNull((Object)StringUtils.trimToNull((String)csrfTokenPath), (String)"csrfTokenPath"), this.csrfInputFieldName, this.csrfMetaTagName, this.csrfHeaderName, this.csrfPrioritization, this.logConfig, this.logDetail, this.automaticallyApplyCookies, true);
    }

    public CsrfConfig csrfTokenPath(URI csrfTokenPath) {
        return this.csrfTokenPath(((URI)AssertParameter.notNull((Object)csrfTokenPath, (String)"csrfTokenPath")).toString());
    }

    public CsrfConfig csrfTokenPath(URL csrfTokenPath) {
        return this.csrfTokenPath(((URL)AssertParameter.notNull((Object)csrfTokenPath, (String)"csrfTokenPath")).toString());
    }

    public String getCsrfTokenPath() {
        return this.csrfTokenPath;
    }

    public String getCsrfMetaTagName() {
        return this.csrfMetaTagName;
    }

    public String getCsrfHeaderName() {
        return this.csrfHeaderName;
    }

    public String getCsrfInputFieldName() {
        return this.csrfInputFieldName;
    }

    public LogConfig getLogConfig() {
        return this.logConfig;
    }

    public boolean isLoggingEnabled() {
        return this.logConfig != null && this.logDetail != null;
    }

    public LogDetail getLogDetail() {
        return this.logDetail;
    }

    public static enum CsrfPrioritization {
        FORM,
        HEADER;

    }
}

