/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.ColumnFamily;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.TableAffiliation;
import org.anyline.metadata.Type;
import org.anyline.metadata.refer.MetadataReferHolder;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.metadata.type.JavaType;
import org.anyline.metadata.type.TypeMetadata;
import org.anyline.metadata.type.TypeMetadataHolder;
import org.anyline.util.BasicUtil;

public class Column
extends TableAffiliation<Column>
implements Serializable {
    public static LinkedHashMap<TypeMetadata.CATEGORY, TypeMetadata.Refer> typeCategoryConfigs = new LinkedHashMap();
    protected String keyword = "COLUMN";
    protected String originName;
    protected String typeName;
    protected String qualifier;
    protected String originType;
    protected TypeMetadata typeMetadata;
    protected String fullType;
    protected String finalType;
    protected int ignoreLength = -1;
    protected int ignorePrecision = -1;
    protected int ignoreScale = -1;
    protected int maxLength = -1;
    protected int maxPrecision = -1;
    protected int maxScale = -1;
    protected Integer precisionLength;
    protected Integer length;
    protected String lengthUnit = "";
    protected Integer octetLength;
    protected Integer precision;
    protected Integer scale;
    protected Integer dimension;
    protected String className;
    protected Integer displaySize;
    protected Integer type;
    protected String childTypeName;
    protected TypeMetadata childTypeMetadata;
    protected JavaType javaType;
    protected String jdbcType;
    protected String dateScale;
    protected Boolean nullable = null;
    protected Boolean caseSensitive = null;
    protected Boolean currency = null;
    protected Boolean signed = null;
    protected Boolean autoIncrement = null;
    protected Integer incrementSeed = null;
    protected Integer incrementStep = null;
    protected Boolean primary = null;
    protected String primaryType;
    protected Boolean unique = null;
    protected Boolean generated = null;
    protected Object defaultValue;
    protected String defaultConstraint;
    protected String charset;
    protected String collate;
    protected Aggregation aggregation;
    protected Boolean withTimeZone = null;
    protected Boolean withLocalTimeZone = null;
    protected Column reference;
    protected Integer srid;
    protected boolean array;
    protected boolean isKey;
    protected Integer position;
    protected String order;
    protected String after;
    protected String before;
    protected String onUpdate = null;
    protected Object value;
    protected boolean defaultCurrentDateTime = false;
    protected Boolean index;
    protected Boolean store;
    protected String analyzer;
    protected String searchAnalyzer;
    protected Integer ignoreAbove;
    protected String coerce;
    protected String copyTo;
    protected String docValues;
    protected String dynamic;
    protected String eagerGlobalOrdinals;
    protected String enabled;
    protected String format;
    protected String ignoreMalformed;
    protected String indexOptions;
    protected String indexPhrases;
    protected String indexPrefixes;
    protected String meta;
    protected String fields;
    protected String normalizer;
    protected String norms;
    protected String nullValue;
    protected String positionIncrementGap;
    protected LinkedHashMap<String, Property> properties = new LinkedHashMap();
    protected String similarity;
    protected String subObjects;
    protected String termVector;
    protected int parseLvl = 0;
    protected ColumnFamily family;
    public static final String FIELD_TYPE_CATEGORY_CONFIG = "TYPE_CATEGORY_CONFIG";
    public static final String FIELD_KEYWORD = "KEYWORD";
    public static final String FIELD_ORIGIN_NAME = "ORIGIN_NAME";
    public static final String FIELD_ORIGIN_TYPE = "ORIGIN_TYPE";
    public static final String FIELD_TYPE_METADATA = "TYPE_METADATA";
    public static final String FIELD_FULL_TYPE = "FULL_TYPE";
    public static final String FIELD_FINAL_TYPE = "FINAL_TYPE";
    public static final String FIELD_IGNORE_LENGTH = "IGNORE_LENGTH";
    public static final String FIELD_IGNORE_PRECISION = "IGNORE_PRECISION";
    public static final String FIELD_IGNORE_SCALE = "IGNORE_SCALE";
    public static final String FIELD_PRECISION_LENGTH = "PRECISION_LENGTH";
    public static final String FIELD_LENGTH = "LENGTH";
    public static final String FIELD_OCTET_LENGTH = "OCTET_LENGTH";
    public static final String FIELD_PRECISION = "PRECISION";
    public static final String FIELD_SCALE = "SCALE";
    public static final String FIELD_DIMS = "DIMS";
    public static final String FIELD_CLASS_NAME = "CLASS_NAME";
    public static final String FIELD_DISPLAY_SIZE = "DISPLAY_SIZE";
    public static final String FIELD_TYPE = "TYPE";
    public static final String FIELD_CHILD_TYPE_NAME = "CHILD_TYPE_NAME";
    public static final String FIELD_CHILD_TYPE_METADATA = "CHILD_TYPE_METADATA";
    public static final String FIELD_JAVA_TYPE = "JAVA_TYPE";
    public static final String FIELD_JDBC_TYPE = "JDBC_TYPE";
    public static final String FIELD_DATE_SCALE = "DATE_SCALE";
    public static final String FIELD_NULLABLE = "NULLABLE";
    public static final String FIELD_CASE_SENSITIVE = "CASE_SENSITIVE";
    public static final String FIELD_CURRENCY = "CURRENCY";
    public static final String FIELD_SIGNED = "SIGNED";
    public static final String FIELD_AUTO_INCREMENT = "AUTO_INCREMENT";
    public static final String FIELD_AUTO_INCREMENT_CHECK = "AUTO_INCREMENT_CHECK";
    public static final String FIELD_AUTO_INCREMENT_CHECK_VALUE = "AUTO_INCREMENT_CHECK_VALUE";
    public static final String FIELD_INCREMENT_SEED = "INCREMENT_SEED";
    public static final String FIELD_INCREMENT_STEP = "INCREMENT_STEP";
    public static final String FIELD_PRIMARY = "PRIMARY";
    public static final String FIELD_PRIMARY_CHECK = "PRIMARY_CHECK";
    public static final String FIELD_PRIMARY_CHECK_VALUE = "PRIMARY_CHECK_VALUE";
    public static final String FIELD_PRIMARY_TYPE = "PRIMARY_TYPE";
    public static final String FIELD_UNIQUE = "UNIQUE";
    public static final String FIELD_GENERATED = "GENERATED";
    public static final String FIELD_DEFAULT_VALUE = "DEFAULT_VALUE";
    public static final String FIELD_DEFAULT_CONSTRAINT = "DEFAULT_CONSTRAINT";
    public static final String FIELD_CHARSET = "CHARSET";
    public static final String FIELD_COLLATE = "COLLATE";
    public static final String FIELD_AGGREGATION = "AGGREGATION";
    public static final String FIELD_WITH_TIME_ZONE = "WITH_TIME_ZONE";
    public static final String FIELD_WITH_LOCAL_TIME_ZONE = "WITH_LOCAL_TIME_ZONE";
    public static final String FIELD_SRID = "SRID";
    public static final String FIELD_ARRAY = "ARRAY";
    public static final String FIELD_ARRAY_CHECK = "ARRAY_CHECK";
    public static final String FIELD_ARRAY_CHECK_VALUE = "ARRAY_CHECK_VALUE";
    public static final String FIELD_IS_KEY = "IS_KEY";
    public static final String FIELD_IS_KEY_CHECK = "IS_KEY_CHECK";
    public static final String FIELD_IS_KEY_CHECK_VALUE = "IS_KEY_CHECK_VALUE";
    public static final String FIELD_POSITION = "POSITION";
    public static final String FIELD_ORDER = "ORDER";
    public static final String FIELD_AFTER = "AFTER";
    public static final String FIELD_BEFORE = "BEFORE";
    public static final String FIELD_ON_UPDATE = "ON_UPDATE";
    public static final String FIELD_ON_UPDATE_CHECK = "ON_UPDATE_CHECK";
    public static final String FIELD_ON_UPDATE_CHECK_VALUE = "ON_UPDATE_CHECK_VALUE";
    public static final String FIELD_VALUE = "VALUE";
    public static final String FIELD_DEFAULT_CURRENT_DATE_TIME = "DEFAULT_CURRENT_DATE_TIME";
    public static final String FIELD_DEFAULT_CURRENT_DATE_TIME_CHECK = "DEFAULT_CURRENT_DATE_TIME_CHECK";
    public static final String FIELD_DEFAULT_CURRENT_DATE_TIME_CHECK_VALUE = "DEFAULT_CURRENT_DATE_TIME_CHECK_VALUE";
    public static final String FIELD_INDEX = "INDEX";
    public static final String FIELD_INDEX_CHECK = "INDEX_CHECK";
    public static final String FIELD_INDEX_CHECK_VALUE = "INDEX_CHECK_VALUE";
    public static final String FIELD_STORE = "STORE";
    public static final String FIELD_STORE_CHECK = "STORE_CHECK";
    public static final String FIELD_STORE_CHECK_VALUE = "STORE_CHECK_VALUE";
    public static final String FIELD_ANALYZER = "ANALYZER";
    public static final String FIELD_SEARCH_ANALYZER = "SEARCH_ANALYZER";
    public static final String FIELD_IGNORE_ABOVE = "IGNORE_ABOVE";
    public static final String FIELD_COERCE = "COERCE";
    public static final String FIELD_COPY_TO = "COPY_TO";
    public static final String FIELD_DOC_VALUES = "DOC_VALUES";
    public static final String FIELD_DYNAMIC = "DYNAMIC";
    public static final String FIELD_EAGER_GLOBAL_ORDINALS = "EAGER_GLOBAL_ORDINALS";
    public static final String FIELD_ENABLED = "ENABLED";
    public static final String FIELD_FORMAT = "FORMAT";
    public static final String FIELD_IGNORE_MALFORMED = "IGNORE_MALFORMED";
    public static final String FIELD_INDEX_OPTIONS = "INDEX_OPTIONS";
    public static final String FIELD_INDEX_PHRASES = "INDEX_PHRASES";
    public static final String FIELD_INDEX_PREFIXES = "INDEX_PREFIXES";
    public static final String FIELD_META = "META";
    public static final String FIELD_FIELDS = "FIELDS";
    public static final String FIELD_NORMALIZER = "NORMALIZER";
    public static final String FIELD_NORMS = "NORMS";
    public static final String FIELD_NULL_VALUE = "NULL_VALUE";
    public static final String FIELD_POSITION_INCREMENT_GAP = "POSITION_INCREMENT_GAP";
    public static final String FIELD_PROPERTY = "PROPERTY";
    public static final String FIELD_SIMILARITY = "SIMILARITY";
    public static final String FIELD_SUB_OBJECTS = "SUB_OBJECTS";
    public static final String FIELD_TERM_VECTOR = "TERM_VECTOR";
    public static final String FIELD_PARSE_LVL = "PARSE_LVL";
    public static final String FIELD_FIELD_FAMILY = "FAMILY ";

    public static <T extends Column> void sort(Map<String, T> columns) {
        Column.sort(columns, false);
    }

    public static <T extends Column> void sort(Map<String, T> columns, boolean nullFirst) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(columns.values());
        Column.sort(list, nullFirst);
        columns.clear();
        for (Column column : list) {
            columns.put(column.getName().toUpperCase(), column);
        }
    }

    public static <T extends Column> void sort(List<T> columns) {
        Column.sort(columns, false);
    }

    public static <T extends Column> void sort(List<T> columns, final boolean nullFirst) {
        Collections.sort(columns, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Integer p2;
                Integer p1 = ((Column)o1).getPosition();
                if (p1 == (p2 = ((Column)o2).getPosition())) {
                    return 0;
                }
                if (nullFirst) {
                    if (null == p1) {
                        return -1;
                    }
                    if (null == p2) {
                        return 1;
                    }
                } else {
                    if (null == p1) {
                        return 1;
                    }
                    if (null == p2) {
                        return -1;
                    }
                }
                return p1 > p2 ? 1 : -1;
            }
        });
    }

    public Column() {
    }

    public Column(Table table, String name, String type) {
        this.setTable(table);
        this.setName(name);
        this.setType(type);
    }

    public Column(String name) {
        this.setName(name);
    }

    public Column(Schema schema, String table, String name) {
        this(null, schema, table, name);
    }

    public Column(Catalog catalog, Schema schema, String table, String name) {
        this.setCatalog(catalog);
        this.setSchema(schema);
        this.setName(name);
        this.setTable(table);
    }

    public Column(String name, String type, int precision, int scale) {
        this.name = name;
        this.setType(type);
        this.precision = precision;
        this.scale = scale;
    }

    public Column(String name, String type, int precision) {
        this.name = name;
        this.setType(type);
        this.precision = precision;
    }

    public Column(Table table, String name, String type, int precision, int scale) {
        this.setTable(table);
        this.name = name;
        this.setType(type);
        this.precision = precision;
        this.scale = scale;
    }

    public Column(Table table, String name, String type, int precision) {
        this.setTable(table);
        this.name = name;
        this.setType(type);
        this.precision = precision;
    }

    public Column(String name, String type) {
        this.name = name;
        this.setType(type);
    }

    public Boolean getIndex() {
        return this.index;
    }

    public boolean isIndex() {
        return null != this.index && this.index != false;
    }

    public Column setIndex(Boolean index) {
        this.index = index;
        return this;
    }

    public Boolean getStore() {
        return this.store;
    }

    public boolean isStore() {
        return null != this.store && this.store != false;
    }

    public Column setStore(Boolean store) {
        this.store = store;
        return this;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public Column setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public Column setQualifier(String qualifier) {
        this.qualifier = qualifier;
        return this;
    }

    public String getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Column setSearchAnalyzer(String searchAnalyzer) {
        this.searchAnalyzer = searchAnalyzer;
        return this;
    }

    public Integer getIgnoreAbove() {
        return this.ignoreAbove;
    }

    public Column setIgnoreAbove(Integer ignoreAbove) {
        this.ignoreAbove = ignoreAbove;
        return this;
    }

    public String getCoerce() {
        return this.coerce;
    }

    public Column setCoerce(String coerce) {
        this.coerce = coerce;
        return this;
    }

    public String getCopyTo() {
        return this.copyTo;
    }

    public Column setCopyTo(String copyTo) {
        this.copyTo = copyTo;
        return this;
    }

    public String getDocValues() {
        return this.docValues;
    }

    public Column setDocValues(String docValues) {
        this.docValues = docValues;
        return this;
    }

    public String getDynamic() {
        return this.dynamic;
    }

    public Column setDynamic(String dynamic) {
        this.dynamic = dynamic;
        return this;
    }

    public String getEagerGlobalOrdinals() {
        return this.eagerGlobalOrdinals;
    }

    public Column setEagerGlobalOrdinals(String eagerGlobalOrdinals) {
        this.eagerGlobalOrdinals = eagerGlobalOrdinals;
        return this;
    }

    public String getEnabled() {
        return this.enabled;
    }

    public Column setEnabled(String enabled) {
        this.enabled = enabled;
        return this;
    }

    public Integer getDimension() {
        return this.dimension;
    }

    public Column setDimension(Integer dimension) {
        this.dimension = dimension;
        return this;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public String getIgnoreMalformed() {
        return this.ignoreMalformed;
    }

    public Column setIgnoreMalformed(String ignoreMalformed) {
        this.ignoreMalformed = ignoreMalformed;
        return this;
    }

    public String getIndexOptions() {
        return this.indexOptions;
    }

    public Column setIndexOptions(String indexOptions) {
        this.indexOptions = indexOptions;
        return this;
    }

    public String getIndexPhrases() {
        return this.indexPhrases;
    }

    public Column setIndexPhrases(String indexPhrases) {
        this.indexPhrases = indexPhrases;
        return this;
    }

    public String getIndexPrefixes() {
        return this.indexPrefixes;
    }

    public Column setIndexPrefixes(String indexPrefixes) {
        this.indexPrefixes = indexPrefixes;
        return this;
    }

    public String getMeta() {
        return this.meta;
    }

    public Column setMeta(String meta) {
        this.meta = meta;
        return this;
    }

    public String getFields() {
        return this.fields;
    }

    public Column setFields(String fields) {
        this.fields = fields;
        return this;
    }

    public String getNormalizer() {
        return this.normalizer;
    }

    public Column setNormalizer(String normalizer) {
        this.normalizer = normalizer;
        return this;
    }

    public String getNorms() {
        return this.norms;
    }

    public Column setNorms(String norms) {
        this.norms = norms;
        return this;
    }

    public String getNullValue() {
        return this.nullValue;
    }

    public Column setNullValue(String nullValue) {
        this.nullValue = nullValue;
        return this;
    }

    public String getPositionIncrementGap() {
        return this.positionIncrementGap;
    }

    public Column setPositionIncrementGap(String positionIncrementGap) {
        this.positionIncrementGap = positionIncrementGap;
        return this;
    }

    public String getSimilarity() {
        return this.similarity;
    }

    public Column setSimilarity(String similarity) {
        this.similarity = similarity;
        return this;
    }

    public String getSubObjects() {
        return this.subObjects;
    }

    public Column setSubObjects(String subObjects) {
        this.subObjects = subObjects;
        return this;
    }

    public String getTermVector() {
        return this.termVector;
    }

    public Column setTermVector(String termVector) {
        this.termVector = termVector;
        return this;
    }

    public Column addProperty(String name, String type) {
        this.properties.put(name, new Property(type));
        return this;
    }

    public LinkedHashMap<String, Property> getProperties() {
        return this.properties;
    }

    public void setProperties(LinkedHashMap<String, Property> properties) {
        this.properties = properties;
    }

    @Override
    public Column drop() {
        this.action = ACTION.DDL.COLUMN_DROP;
        return (Column)super.drop();
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public boolean isArray() {
        return this.array;
    }

    public Column setArray(boolean array) {
        this.array = array;
        return this;
    }

    public String getDateScale() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getDateScale();
        }
        return this.dateScale;
    }

    public Boolean getWithTimeZone() {
        return this.withTimeZone;
    }

    public boolean isWithTimeZone() {
        return null != this.withLocalTimeZone && this.withLocalTimeZone != false;
    }

    public void setWithTimeZone(int withTimeZone) {
        if (withTimeZone == 0) {
            this.withTimeZone = false;
        } else if (withTimeZone == 1) {
            this.withTimeZone = true;
        }
    }

    public void setWithTimeZone(Boolean withTimeZone) {
        this.withTimeZone = withTimeZone;
    }

    public Boolean getWithLocalTimeZone() {
        return this.withLocalTimeZone;
    }

    public boolean setWithLocalTimeZone() {
        return null != this.withLocalTimeZone && this.withLocalTimeZone != false;
    }

    public void setWithLocalTimeZone(int withLocalTimeZone) {
        if (withLocalTimeZone == 0) {
            this.withLocalTimeZone = false;
        } else if (withLocalTimeZone == 1) {
            this.withLocalTimeZone = true;
        }
    }

    public Column setDateScale(String dateScale) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDateScale(dateScale);
            return this;
        }
        this.dateScale = dateScale;
        return this;
    }

    public boolean isKey() {
        return this.isKey;
    }

    public void setKey(boolean key) {
        this.isKey = key;
    }

    public String getClassName() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getClassName();
        }
        return this.className;
    }

    public Column setClassName(String className) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setClassName(className);
            return this;
        }
        this.className = className;
        return this;
    }

    public String getChildTypeName() {
        if (this.getmap && null != this.childTypeName) {
            return ((Column)this.update).getChildTypeName();
        }
        return this.childTypeName;
    }

    public Column setChildTypeName(String childTypeName) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setChildTypeName(childTypeName);
            return this;
        }
        this.childTypeName = childTypeName;
        return this;
    }

    public TypeMetadata getChildTypeMetadata() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).childTypeMetadata;
        }
        if (this.array && null != this.childTypeMetadata) {
            this.childTypeMetadata.setArray(this.array);
        }
        return this.childTypeMetadata;
    }

    public Column setChildTypeMetadata(TypeMetadata childTypeMetadata) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setChildTypeMetadata(childTypeMetadata);
            return this;
        }
        this.childTypeMetadata = childTypeMetadata;
        return this;
    }

    public Integer getDisplaySize() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getDisplaySize();
        }
        return this.displaySize;
    }

    public Column setDisplaySize(Integer displaySize) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDisplaySize(displaySize);
            return this;
        }
        this.displaySize = displaySize;
        return this;
    }

    public String getOriginType() {
        if (null == this.originType) {
            return this.typeName;
        }
        return this.originType;
    }

    public void setOriginType(String originType) {
        this.originType = originType;
    }

    public Integer getType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getType();
        }
        return this.type;
    }

    public Column setType(Integer type) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setType(type);
            return this;
        }
        if (this.type != type) {
            this.className = null;
        }
        this.type = type;
        return this;
    }

    public Column setType(String type) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setType(type);
            return this;
        }
        return this.setTypeName(type);
    }

    public String getTypeName() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getTypeName();
        }
        if (null == this.typeName && null != this.typeMetadata && this.typeMetadata != TypeMetadata.ILLEGAL && this.typeMetadata != TypeMetadata.NONE) {
            this.typeName = this.typeMetadata.getName();
        }
        return this.typeName;
    }

    public String getJdbcType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).jdbcType;
        }
        return this.jdbcType;
    }

    public Column setJdbcType(String jdbcType) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setJdbcType(jdbcType);
            return this;
        }
        this.jdbcType = jdbcType;
        return this;
    }

    public Column setTypeName(String typeName) {
        return this.setTypeName(typeName, true);
    }

    public Column setTypeName(String typeName, boolean parse) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setTypeName(typeName, parse);
            return this;
        }
        if (null == this.typeName || !this.typeName.equalsIgnoreCase(typeName)) {
            this.parseLvl = 0;
        }
        this.typeName = typeName;
        if (parse) {
            this.setOriginType(typeName);
            this.parseType(1, this.databaseType);
        }
        return this;
    }

    public Column parseType(int lvl, DatabaseType database) {
        if (lvl <= this.parseLvl) {
            return this;
        }
        TypeMetadata.parse(database, this, TypeMetadataHolder.gets(database), null);
        return this;
    }

    public int getParseLvl() {
        return this.parseLvl;
    }

    public void setParseLvl(int parseLvl) {
        this.parseLvl = parseLvl;
    }

    public Column setFullType(String fullType) {
        this.fullType = fullType;
        return this;
    }

    public String getFullType() {
        return this.getFullType(this.databaseType);
    }

    public String getFullType(DatabaseType database) {
        return this.getFullType(database, null);
    }

    public String getFullType(DatabaseType database, TypeMetadata.Refer refer) {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getFullType(database);
        }
        if (null != this.fullType && this.databaseType == database) {
            return this.fullType;
        }
        int ignoreLength = -1;
        int ignorePrecision = -1;
        int ignoreScale = -1;
        int maxLength = -1;
        int maxPrecision = -1;
        int maxScale = -1;
        String result = null;
        String type = null;
        String formula = null;
        if (null != refer) {
            ignoreLength = refer.ignoreLength();
            ignorePrecision = refer.ignorePrecision();
            ignoreScale = refer.ignoreScale();
            maxLength = refer.maxLength();
            maxPrecision = refer.maxPrecision();
            maxScale = refer.maxScale();
            formula = refer.getFormula();
        } else {
            ignoreLength = this.ignoreLength(database);
            ignorePrecision = this.ignorePrecision(database);
            ignoreScale = this.ignoreScale(database);
            maxLength = this.maxLength(database);
            maxPrecision = this.maxPrecision(database);
            maxScale = this.maxScale(database);
            formula = this.formula(database);
        }
        type = null != this.typeMetadata && this.typeMetadata != TypeMetadata.NONE && this.typeMetadata != TypeMetadata.ILLEGAL && database == this.databaseType ? this.typeMetadata.getName() : this.getTypeName();
        boolean appendLength = false;
        boolean appendPrecision = false;
        boolean appendScale = false;
        if (ignoreLength != 1) {
            if (null == this.length && null != this.precision && this.precision != -1) {
                this.length = this.precision;
            }
            if (null != this.length && (this.length > 0 || this.length == -2)) {
                appendLength = true;
            }
        }
        if (ignorePrecision != 1) {
            if (null == this.precision && null != this.length && this.length != -1) {
                this.precision = this.length;
            }
            if (null != this.precision && this.precision > 0) {
                appendPrecision = ignorePrecision == 3 ? null != this.scale && this.scale > 0 : true;
            }
        }
        if (ignoreScale != 1 && null != this.scale && this.scale > 0) {
            appendScale = ignoreScale == 3 ? null != this.precision && this.precision > 0 : true;
        }
        if (maxLength != -1 && null != this.length && this.length > maxLength) {
            this.length = maxLength;
        }
        if (maxPrecision != -1 && null != this.precision && this.precision > maxPrecision) {
            this.precision = maxPrecision;
        }
        if (maxScale != -1 && null != this.scale && this.scale > maxScale) {
            this.scale = maxScale;
        }
        if (BasicUtil.isNotEmpty(formula)) {
            result = formula;
            result = result.replace("{L}", this.length + "");
            result = result.replace("{P}", this.precision + "");
            result = result.replace("{S}", this.scale + "");
            result = result.replace("{U}", this.lengthUnit);
            result = result.replace("(0)", "");
            result = result.replace("(null)", "");
        } else if (null != type) {
            StringBuilder builder = new StringBuilder();
            if (type.contains("{")) {
                result = type;
                result = result.replace("{L}", this.length + "");
                result = result.replace("{P}", this.precision + "");
                result = result.replace("{S}", this.scale + "");
                result = result.replace("{U}", this.lengthUnit);
                result = result.replace("(0)", "");
                result = result.replace("(null)", "");
            } else {
                builder.append(type);
                if (appendLength || appendPrecision || appendScale) {
                    builder.append("(");
                }
                if (appendLength) {
                    if (this.length == -2) {
                        builder.append("max");
                    } else {
                        builder.append(this.length);
                        if (BasicUtil.isNotEmpty(this.lengthUnit)) {
                            builder.append(" ").append(this.lengthUnit);
                        }
                    }
                } else {
                    if (appendPrecision) {
                        builder.append(this.precision);
                    }
                    if (appendScale) {
                        if (appendPrecision) {
                            builder.append(", ");
                        }
                        builder.append(this.scale);
                    }
                }
                if (appendLength || appendPrecision || appendScale) {
                    builder.append(")");
                }
                String child = this.getChildTypeName();
                Integer srid = this.getSrid();
                if (null != child) {
                    builder.append("(");
                    builder.append(child);
                    if (null != srid) {
                        builder.append(", ").append(srid);
                    }
                    builder.append(")");
                }
                if (this.isArray()) {
                    builder.append("[]");
                }
                result = builder.toString();
            }
        }
        return result;
    }

    public Integer getPrecisionLength() {
        if (null != this.precisionLength && this.precisionLength != -1) {
            return this.precisionLength;
        }
        this.precisionLength = null != this.precision && this.precision != -1 ? this.precision : this.length;
        return this.precisionLength;
    }

    public Integer getLength() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getLength();
        }
        if (null != this.length && this.length != -1) {
            return this.length;
        }
        return this.precision;
    }

    public Column resetLength(Integer length) {
        if (null != this.originType) {
            this.originType = this.originType.replace("(" + this.length, "(" + length);
        }
        this.setLength(length);
        this.setParseLvl(0);
        return this;
    }

    public Column setLength(Integer length) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setLength(length);
            return this;
        }
        if (this.ignoreLength == 1) {
            this.precision = length;
        } else {
            this.length = length;
        }
        return this;
    }

    public Integer getOctetLength() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getOctetLength();
        }
        return this.octetLength;
    }

    public Column setOctetLength(Integer length) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setOctetLength(length);
            return this;
        }
        this.octetLength = length;
        return this;
    }

    public Integer getPrecision() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getPrecision();
        }
        if (null != this.precision && this.precision != -1) {
            return this.precision;
        }
        return this.length;
    }

    public Column setPrecision(Integer precision) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPrecision(precision);
            return this;
        }
        if (this.ignorePrecision == 1) {
            this.length = precision;
        } else {
            this.precision = precision;
        }
        return this;
    }

    public Column setPrecision(Integer precision, Integer scale) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPrecision(precision, scale);
            return this;
        }
        this.precision = precision;
        this.scale = scale;
        return this;
    }

    public Object getValue() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).value;
        }
        return this.value;
    }

    public Column setValue(Object value) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setValue(value);
            return this;
        }
        this.value = value;
        return this;
    }

    public Boolean getCaseSensitive() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getCaseSensitive();
        }
        return this.caseSensitive;
    }

    public boolean isCaseSensitive() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).isCaseSensitive();
        }
        return null != this.caseSensitive && this.caseSensitive != false;
    }

    public Column setCaseSensitive(int caseSensitive) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCaseSensitive(caseSensitive);
            return this;
        }
        if (caseSensitive == 1) {
            this.caseSensitive = true;
        } else if (caseSensitive == 0) {
            this.caseSensitive = false;
        }
        return this;
    }

    public Column caseSensitive(int caseSensitive) {
        return this.setCaseSensitive(caseSensitive);
    }

    public Column caseSensitive(Boolean caseSensitive) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).caseSensitive(caseSensitive);
            return this;
        }
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Boolean getCurrency() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).currency;
        }
        return this.currency;
    }

    public boolean isCurrency() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).isCurrency();
        }
        return null != this.currency && this.currency != false;
    }

    public Column setCurrency(int currency) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCurrency(currency);
            return this;
        }
        if (currency == 1) {
            this.currency = true;
        } else if (currency == 0) {
            this.currency = false;
        }
        return this;
    }

    public Column currency(int currency) {
        return this.setCurrency(currency);
    }

    public Column setCurrency(Boolean currency) {
        return this.currency(currency);
    }

    public Column currency(Boolean currency) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).currency(currency);
            return this;
        }
        this.currency = currency;
        return this;
    }

    public Boolean getSigned() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).signed;
        }
        return this.signed;
    }

    public boolean isSigned() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).isSigned();
        }
        return null != this.signed && this.signed != false;
    }

    public Column setSigned(int signed) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setSigned(signed);
            return this;
        }
        if (signed == 1) {
            this.signed = true;
        } else if (signed == 0) {
            this.signed = false;
        }
        return this;
    }

    public Column signed(int signed) {
        return this.setSigned(signed);
    }

    public Column setSigned(Boolean signed) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setSigned(signed);
            return this;
        }
        this.signed = signed;
        return this;
    }

    public Aggregation getAggregation() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).aggregation;
        }
        return this.aggregation;
    }

    public Column setAggregation(Aggregation aggregation) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAggregation(aggregation);
            return this;
        }
        this.aggregation = aggregation;
        return this;
    }

    public Integer getScale() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getScale();
        }
        return this.scale;
    }

    public Column setScale(Integer scale) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setScale(scale);
            return this;
        }
        this.scale = scale;
        return this;
    }

    public Boolean getNullable() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).nullable;
        }
        return this.nullable;
    }

    public boolean isNullable() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).isNullable();
        }
        return null != this.nullable && this.nullable != false;
    }

    public Column setNullable(int nullable) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setNullable(nullable);
            return this;
        }
        if (nullable == 1) {
            this.nullable = true;
        } else if (nullable == 0) {
            this.nullable = false;
        }
        return this;
    }

    public Column nullable(int nullable) {
        return this.setNullable(nullable);
    }

    public Column setNullable(Boolean nullable) {
        return this.nullable(nullable);
    }

    public Column nullable(Boolean nullable) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).nullable(nullable);
            return this;
        }
        this.nullable = nullable;
        return this;
    }

    public Boolean getAutoIncrement() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).autoIncrement;
        }
        return this.autoIncrement;
    }

    public Boolean isAutoIncrement() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).isAutoIncrement();
        }
        return null != this.autoIncrement && this.autoIncrement != false;
    }

    public Column setAutoIncrement(int autoIncrement) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAutoIncrement(autoIncrement);
            return this;
        }
        if (autoIncrement == 1) {
            this.nullable(false);
            this.autoIncrement = true;
        } else if (autoIncrement == 0) {
            this.autoIncrement = false;
        }
        return this;
    }

    public Column autoIncrement(int autoIncrement) {
        return this.setAutoIncrement(autoIncrement);
    }

    public Column setAutoIncrement(Boolean autoIncrement) {
        return this.autoIncrement(autoIncrement);
    }

    public Column autoIncrement(Boolean autoIncrement) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).autoIncrement(autoIncrement);
            return this;
        }
        if (null != autoIncrement && autoIncrement.booleanValue()) {
            this.nullable(false);
        }
        this.autoIncrement = autoIncrement;
        return this;
    }

    public Column setAutoIncrement(int seed, int step) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAutoIncrement(seed, step);
            return this;
        }
        this.setAutoIncrement(1);
        this.incrementSeed = seed;
        this.incrementStep = step;
        return this;
    }

    public Boolean getUnique() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).unique;
        }
        return this.unique;
    }

    public boolean isUnique() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).isUnique();
        }
        return null != this.unique && this.unique != false;
    }

    public Column setUnique(int unique) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setUnique(unique);
            return this;
        }
        if (unique == 1) {
            this.unique = true;
        } else if (unique == 0) {
            this.unique = false;
        }
        return this;
    }

    public Column unique(int unique) {
        return this.setUnique(unique);
    }

    public Column setUnique(Boolean unique) {
        return this.unique(unique);
    }

    public Column unique(Boolean unique) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).unique(unique);
            return this;
        }
        this.unique = unique;
        return this;
    }

    public Boolean getPrimaryKey() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).primary;
        }
        return this.primary;
    }

    public boolean isPrimaryKey() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).primary;
        }
        return null != this.primary && this.primary != false;
    }

    public Column setPrimary(int primary) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPrimary(primary);
            return this;
        }
        if (primary == 1) {
            this.primary = true;
        } else if (primary == 0) {
            this.primary = false;
        }
        return this;
    }

    public Column primary(int primary) {
        return this.setPrimary(primary);
    }

    public Column setPrimary(Boolean primary) {
        return this.primary(primary);
    }

    public Column setPrimaryKey(Boolean primary) {
        return this.primary(primary);
    }

    public Column primary(Boolean primary) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).primary(primary);
            return this;
        }
        this.primary = primary;
        return this;
    }

    public String getPrimaryType() {
        return this.primaryType;
    }

    public void setPrimaryType(String primaryType) {
        this.primaryType = primaryType;
    }

    public Column setPrimary(int primary, String type) {
        this.setPrimary(primary);
        this.primaryType = type;
        return this;
    }

    public Column primary(int primary, String type) {
        this.primary(primary);
        this.primaryType = type;
        return this;
    }

    public Column setPrimary(Boolean primary, String type) {
        this.setPrimary(primary);
        this.primaryType = type;
        return this;
    }

    public Column setPrimaryKey(Boolean primary, String type) {
        this.setPrimaryKey(primary);
        this.primaryType = type;
        return this;
    }

    public Column primary(Boolean primary, String type) {
        this.primary(primary);
        this.primaryType = type;
        return this;
    }

    public Boolean getGenerated() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).generated;
        }
        return this.generated;
    }

    public boolean isGenerated() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).isGenerated();
        }
        return null != this.generated && this.generated != false;
    }

    public Column setGenerated(int generated) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setGenerated(generated);
            return this;
        }
        if (generated == 1) {
            this.generated = true;
        } else if (generated == 0) {
            this.generated = false;
        }
        return this;
    }

    public Column generated(int generated) {
        return this.setGenerated(generated);
    }

    public Column setGenerated(Boolean generated) {
        return this.generated(generated);
    }

    public Column generated(Boolean generated) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).generated(generated);
            return this;
        }
        this.generated = generated;
        return this;
    }

    public Object getDefaultValue() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).defaultValue;
        }
        return this.defaultValue;
    }

    public Column setDefaultValue(Object defaultValue) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDefaultValue(defaultValue);
            return this;
        }
        this.defaultValue = defaultValue;
        return this;
    }

    public Column setDefaultCurrentDateTime(boolean currentDateTime) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDefaultCurrentDateTime(currentDateTime);
            return this;
        }
        this.defaultCurrentDateTime = currentDateTime;
        return this;
    }

    public Column setDefaultCurrentDateTime() {
        return this.setDefaultCurrentDateTime(true);
    }

    public boolean isDefaultCurrentDateTime() {
        return this.defaultCurrentDateTime;
    }

    public String getDefaultConstraint() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).defaultConstraint;
        }
        return this.defaultConstraint;
    }

    public Column setDefaultConstraint(String defaultConstraint) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDefaultConstraint(defaultConstraint);
            return this;
        }
        this.defaultConstraint = defaultConstraint;
        return this;
    }

    public Integer getPosition() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).position;
        }
        return this.position;
    }

    public String getOrder() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).order;
        }
        return this.order;
    }

    public Column setOrder(String order) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setOrder(order);
            return this;
        }
        this.order = order;
        return this;
    }

    public Column setPosition(Integer position) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPosition(position);
            return this;
        }
        this.position = position;
        return this;
    }

    public String getAfter() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).after;
        }
        return this.after;
    }

    public Integer getIncrementSeed() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).incrementSeed;
        }
        return this.incrementSeed;
    }

    public Column setIncrementSeed(Integer incrementSeed) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setIncrementSeed(incrementSeed);
            return this;
        }
        this.incrementSeed = incrementSeed;
        return this;
    }

    public Integer getIncrementStep() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).incrementStep;
        }
        return this.incrementStep;
    }

    public Column setIncrementStep(Integer incrementStep) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setIncrementStep(incrementStep);
            return this;
        }
        this.incrementStep = incrementStep;
        return this;
    }

    public String getOnUpdate() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).onUpdate;
        }
        return this.onUpdate;
    }

    public Column setOnUpdate(String onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }

    public Column onUpdate(String onUpdate) {
        return this.setOnUpdate(onUpdate);
    }

    public Column setAfter(String after) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAfter(after);
            return this;
        }
        this.after = after;
        return this;
    }

    public String getOriginName() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).originName;
        }
        return this.originName;
    }

    public Column setOriginName(String originName) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setOriginName(originName);
            return this;
        }
        this.originName = originName;
        return this;
    }

    public String getBefore() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).before;
        }
        return this.before;
    }

    public String getCharset() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).charset;
        }
        return this.charset;
    }

    public Column setCharset(String charset) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCharset(charset);
            return this;
        }
        this.charset = charset;
        return this;
    }

    public String getLengthUnit() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).lengthUnit;
        }
        return this.lengthUnit;
    }

    public Column setLengthUnit(String lengthUnit) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setLengthUnit(lengthUnit);
            return this;
        }
        this.lengthUnit = lengthUnit;
        return this;
    }

    public String getCollate() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).collate;
        }
        return this.collate;
    }

    public Column setCollate(String collate) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCollate(collate);
            return this;
        }
        this.collate = collate;
        return this;
    }

    public Column setBefore(String before) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setBefore(before);
            return this;
        }
        this.before = before;
        return this;
    }

    public boolean equals(Column column) {
        return this.equals(column, true);
    }

    public boolean equals(Column column, boolean ignoreCase) {
        Boolean colAutoIncrement;
        if (null == column) {
            return false;
        }
        if (!BasicUtil.equals((Object)this.name, (Object)column.getName(), ignoreCase)) {
            return false;
        }
        TypeMetadata columnTypeMetadata = column.getTypeMetadata();
        TypeMetadata origin = null;
        TypeMetadata columnOrigin = null;
        if (null != this.typeMetadata) {
            origin = this.typeMetadata.getOrigin();
        }
        if (null != columnTypeMetadata) {
            columnOrigin = columnTypeMetadata.getOrigin();
        }
        if (!(BasicUtil.equals((Object)this.typeMetadata, (Object)columnTypeMetadata, ignoreCase) || BasicUtil.equals((Object)this.typeMetadata, (Object)columnOrigin, ignoreCase) || BasicUtil.equals((Object)origin, (Object)columnTypeMetadata, ignoreCase) || BasicUtil.equals((Object)origin, (Object)columnOrigin, ignoreCase))) {
            return false;
        }
        if (!(null != this.typeMetadata && TypeMetadata.NONE != this.typeMetadata && 0 != this.typeMetadata.ignoreLength() || BasicUtil.equals(this.getLength(), column.getLength()))) {
            return false;
        }
        if (!(null != this.typeMetadata && TypeMetadata.NONE != this.typeMetadata && 0 != this.typeMetadata.ignorePrecision() || BasicUtil.equals(this.getPrecision(), column.getPrecision()))) {
            return false;
        }
        if (!(null != this.typeMetadata && TypeMetadata.NONE != this.typeMetadata && 0 != this.typeMetadata.ignoreScale() || BasicUtil.equals(this.getScale(), column.getScale()))) {
            return false;
        }
        if (!BasicUtil.equals(this.getDefaultValue(), column.getDefaultValue())) {
            return false;
        }
        if (!BasicUtil.equals(BasicUtil.evl(this.getComment()), BasicUtil.evl(column.getComment()))) {
            return false;
        }
        if (!BasicUtil.equals(this.getNullable(), column.getNullable())) {
            return false;
        }
        Boolean isAutoIncrement = this.getAutoIncrement();
        if (isAutoIncrement == null) {
            isAutoIncrement = false;
        }
        if ((colAutoIncrement = column.getAutoIncrement()) == null) {
            colAutoIncrement = false;
        }
        if (isAutoIncrement != colAutoIncrement) {
            return false;
        }
        if (!BasicUtil.equals((Object)this.getCharset(), (Object)column.getCharset(), ignoreCase)) {
            return false;
        }
        if (!BasicUtil.equals(this.getPrimaryKey(), column.getPrimaryKey())) {
            return false;
        }
        return null == this.table || !this.table.isSort() || BasicUtil.equals(this.getPosition(), column.getPosition());
    }

    public TypeMetadata getTypeMetadata() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).typeMetadata;
        }
        if (this.array && null != this.typeMetadata) {
            this.typeMetadata.setArray(this.array);
        }
        return this.typeMetadata;
    }

    public TypeMetadata.CATEGORY getTypeCategory() {
        if (null != this.typeMetadata) {
            return this.typeMetadata.getCategory();
        }
        return TypeMetadata.CATEGORY.NONE;
    }

    public Column setTypeMetadata(TypeMetadata typeMetadata) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setTypeMetadata(typeMetadata);
            return this;
        }
        this.typeMetadata = typeMetadata;
        return this;
    }

    @Override
    public Column setNewName(String newName, boolean setmap, boolean getmap) {
        LinkedHashMap<String, Column> pks;
        if (null == this.update) {
            this.update(setmap, getmap);
        }
        ((Column)this.update).setName(newName);
        Table table = this.getTable();
        if (null != table && null != (pks = table.getPrimaryKeyColumns()) && pks.containsKey(this.getName().toUpperCase())) {
            pks.remove(this.getName().toUpperCase());
            pks.put(newName.toUpperCase(), (Column)this.update);
        }
        return (Column)this.update;
    }

    public JavaType getJavaType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).javaType;
        }
        return this.javaType;
    }

    public Column setJavaType(JavaType javaType) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setJavaType(javaType);
            return this;
        }
        this.javaType = javaType;
        return this;
    }

    public Integer getSrid() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).srid;
        }
        return this.srid;
    }

    public Column setSrid(Integer srid) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setSrid(srid);
            return this;
        }
        this.srid = srid;
        return this;
    }

    public Column getReference() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).reference;
        }
        return this.reference;
    }

    public Column setReference(Column reference) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setReference(reference);
            return this;
        }
        this.reference = reference;
        return this;
    }

    public ColumnFamily getFamily() {
        return this.family;
    }

    public Column setFamily(ColumnFamily family) {
        this.family = family;
        return this;
    }

    public void ignoreLength(int ignoreLength) {
        this.ignoreLength = ignoreLength;
    }

    public void maxLength(int maxLength) {
        this.maxLength = maxLength;
    }

    public void ignorePrecision(int ignorePrecision) {
        this.ignorePrecision = ignorePrecision;
    }

    public void maxPrecision(int maxPrecision) {
        this.maxPrecision = maxPrecision;
    }

    public void ignoreScale(int ignoreScale) {
        this.ignoreScale = ignoreScale;
    }

    public void maxScale(int maxScale) {
        this.maxScale = maxScale;
    }

    public int ignoreScale(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataReferHolder.ignoreScale(database, this.typeMetadata);
        }
        return this.ignoreScale();
    }

    public String formula(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataReferHolder.formula(database, this.typeMetadata);
        }
        return null;
    }

    public int ignoreLength() {
        if (-1 != this.ignoreLength) {
            return this.ignoreLength;
        }
        if (null != this.typeMetadata) {
            return this.typeMetadata.ignoreLength();
        }
        return this.ignoreLength;
    }

    public int ignoreLength(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataReferHolder.ignoreLength(database, this.typeMetadata);
        }
        return this.ignoreLength();
    }

    public int maxLength() {
        if (-1 != this.maxLength) {
            return this.maxLength;
        }
        if (null != this.typeMetadata) {
            return this.typeMetadata.maxLength();
        }
        return this.maxLength;
    }

    public int maxLength(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataReferHolder.maxLength(database, this.typeMetadata);
        }
        return this.maxLength();
    }

    public int ignorePrecision() {
        if (-1 != this.ignorePrecision) {
            return this.ignorePrecision;
        }
        if (null != this.typeMetadata) {
            return this.typeMetadata.ignorePrecision();
        }
        return this.ignorePrecision;
    }

    public int ignorePrecision(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataReferHolder.ignorePrecision(database, this.typeMetadata);
        }
        return this.ignorePrecision();
    }

    public int maxPrecision() {
        if (-1 != this.maxPrecision) {
            return this.maxPrecision;
        }
        if (null != this.typeMetadata) {
            return this.typeMetadata.maxPrecision();
        }
        return this.maxPrecision;
    }

    public int maxPrecision(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataReferHolder.maxPrecision(database, this.typeMetadata);
        }
        return this.maxPrecision();
    }

    public String getFinalType() {
        return this.finalType;
    }

    public Column setFinalType(String finalType) {
        this.finalType = finalType;
        return this;
    }

    public int ignoreScale() {
        if (-1 != this.ignoreScale) {
            return this.ignoreScale;
        }
        if (null != this.typeMetadata) {
            return this.typeMetadata.ignoreScale();
        }
        return this.ignoreScale;
    }

    public int maxScale() {
        if (-1 != this.maxScale) {
            return this.maxScale;
        }
        if (null != this.typeMetadata) {
            return this.typeMetadata.maxScale();
        }
        return this.maxScale;
    }

    public int maxScale(DatabaseType database) {
        if (null != this.typeMetadata) {
            return MetadataReferHolder.maxScale(database, this.typeMetadata);
        }
        return this.maxScale();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append(" ");
        builder.append(this.getFullType());
        if (BasicUtil.isNotEmpty(this.defaultValue)) {
            builder.append(" default ").append(this.defaultValue);
        }
        return builder.toString();
    }

    @Override
    public String keyword() {
        return this.keyword;
    }

    public static class Property {
        String type;

        public Property(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }

    public static enum Aggregation {
        MIN("MIN", "\u6700\u5c0f"),
        MAX("MAX", "\u6700\u5927"),
        SUM("SUM", "\u6c42\u548c"),
        REPLACE("REPLACE", "\u66ff\u6362"),
        REPLACE_IF_NOT_NULL("REPLACE_IF_NOT_NULL", "\u975e\u7a7a\u503c\u66ff\u6362"),
        HLL_UNION("HLL_UNION", "HLL \u7c7b\u578b\u7684\u5217\u7684\u805a\u5408\u65b9\u5f0f"),
        BITMAP_UNION("BITMAP_UNION", "BIMTAP \u7c7b\u578b\u7684\u5217\u7684\u805a\u5408\u65b9\u5f0f\uff0c");

        final String code;
        final String name;

        private Aggregation(String code, String name) {
            this.code = code;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum TYPE implements Type
    {
        NORMAL(1),
        TAG(2);

        public final int value;

        private TYPE(int value) {
            this.value = value;
        }

        @Override
        public int value() {
            return this.value;
        }
    }
}

