/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Parameter;

public class Procedure
extends Metadata<Procedure>
implements Serializable {
    protected String keyword = "PROCEDURE";
    private String returnType;
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private List<Parameter> inputs = new ArrayList<Parameter>();
    private List<Parameter> outputs = new ArrayList<Parameter>();
    private List<Object> result;
    private boolean hasReturn = false;
    private PageNavi navi;
    public static final String FIELD_KEYWORD = "KEYWORD";
    public static final String FIELD_RETURN_TYPE = "RETURN_TYPE";
    public static final String FIELD_PARAMETER = "PARAMETER";
    public static final String FIELD_INPUT = "INPUT";
    public static final String FIELD_OUTPUT = "OUTPUT";
    public static final String FIELD_RESULT = "RESULT";
    public static final String FIELD_HAS_RETURN = "HAS_RETURN";
    public static final String FIELD_HAS_RETURN_CHECK = "HAS_RETURN_CHECK";
    public static final String FIELD_HAS_RETURN_CHECK_VALUE = "HAS_RETURN_CHECK_VALUE";
    public static final String FIELD_NAVI = "NAVI";

    public Procedure(String name) {
        this();
        this.name = name;
    }

    public Procedure() {
    }

    public Procedure addInput(Parameter ... params) {
        if (null != params) {
            for (Parameter parameter : params) {
                this.inputs.add(parameter);
            }
        }
        return this;
    }

    public Procedure addOutput(Parameter ... params) {
        if (null != params) {
            for (Parameter parameter : params) {
                this.outputs.add(parameter);
            }
        }
        return this;
    }

    public Procedure addInput(Object value, Integer type) {
        Parameter param = new Parameter();
        param.setType(type);
        param.setValue(value);
        this.inputs.add(param);
        return this;
    }

    public Procedure addInput(String value) {
        return this.addInput(value, 12);
    }

    public Procedure regOutput(Integer type) {
        return this.regOutput(null, type);
    }

    public Procedure regOutput() {
        return this.regOutput(12);
    }

    public Procedure regOutput(Object value, Integer type) {
        Parameter param = new Parameter();
        param.setValue(value);
        param.setType(type);
        this.outputs.add(param);
        return this;
    }

    public Procedure regOutput(String value) {
        Parameter param = new Parameter();
        param.setValue(value);
        this.outputs.add(param);
        return this;
    }

    public List<Object> getResult() {
        if (this.getmap && null != this.update) {
            return ((Procedure)this.update).result;
        }
        return this.result;
    }

    public Procedure setResult(List<Object> result) {
        this.result = result;
        return this;
    }

    public List<Object> getOutput() {
        if (this.getmap && null != this.update) {
            return ((Procedure)this.update).result;
        }
        return this.result;
    }

    public List<Parameter> getInputs() {
        if (this.getmap && null != this.update) {
            return ((Procedure)this.update).inputs;
        }
        return this.inputs;
    }

    public List<Parameter> getOutputs() {
        if (this.getmap && null != this.update) {
            return ((Procedure)this.update).outputs;
        }
        return this.outputs;
    }

    public Procedure regReturn() {
        if (this.getmap && null != this.update) {
            return ((Procedure)this.update).regReturn();
        }
        this.hasReturn = true;
        return this;
    }

    public boolean hasReturn() {
        if (this.getmap && null != this.update) {
            return ((Procedure)this.update).hasReturn;
        }
        return this.hasReturn;
    }

    public PageNavi getNavi() {
        return this.navi;
    }

    public Procedure setNavi(PageNavi navi) {
        this.navi = navi;
        return this;
    }

    public String getReturnType() {
        if (this.getmap && null != this.update) {
            return ((Procedure)this.update).returnType;
        }
        return this.returnType;
    }

    public Procedure setReturnType(String returnType) {
        if (this.setmap && null != this.update) {
            ((Procedure)this.update).returnType = returnType;
        }
        this.returnType = returnType;
        return this;
    }

    @Override
    public Procedure clone() {
        Procedure copy = (Procedure)super.clone();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Parameter parameter : this.parameters) {
            parameters.add((Parameter)parameter.clone());
        }
        copy.parameters = parameters;
        ArrayList<Parameter> inputs = new ArrayList<Parameter>();
        for (Parameter parameter : this.inputs) {
            inputs.add((Parameter)parameter.clone());
        }
        copy.inputs = inputs;
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        for (Parameter parameter : this.outputs) {
            arrayList.add((Parameter)parameter.clone());
        }
        copy.outputs = arrayList;
        return copy;
    }

    @Override
    public String keyword() {
        return this.keyword;
    }
}

