/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;

public class SnowflakeWorker {
    private final long TWEPOCH = DateUtil.parse(ConfigTable.SNOWFLAKE_TWEPOCH).getTime();
    private final long workerIdBits = 10L;
    private final long maxWorkerId = 1023L;
    private final long sequenceBits = 12L;
    private final long workerIdShift = 12L;
    private final long timestampLeftShift = 22L;
    private final long sequenceMask = 4095L;
    private long workerId;
    private long sequence = 0L;
    private long lastTimestamp = -1L;

    public SnowflakeWorker(long workerId) {
        if (workerId > 1023L || workerId < 0L) {
            throw new IllegalArgumentException(String.format("workerId can't be greater than %d or less than 0", 1023L));
        }
        this.workerId = workerId;
    }

    public synchronized long next() {
        long timestamp = System.currentTimeMillis();
        if (timestamp < this.lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.TWEPOCH << 22 | this.workerId << 12 | this.sequence;
    }

    protected long tilNextMillis(long lastTimestamp) {
        long timestamp = System.currentTimeMillis();
        while (timestamp <= lastTimestamp) {
            timestamp = System.currentTimeMillis();
        }
        return timestamp;
    }
}

