/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.util.Arrays;
import org.apache.fory.Fory;
import org.apache.fory.collection.ForyObjectMap;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.meta.Encoders;
import org.apache.fory.meta.MetaString;
import org.apache.fory.resolver.MetaStringBytes;
import org.apache.fory.resolver.MetaStringResolver;
import org.apache.fory.serializer.ImmutableSerializer;
import org.apache.fory.util.Preconditions;

public class EnumSerializer
extends ImmutableSerializer<Enum> {
    private final MetaStringResolver metaStringResolver;
    private final Enum[] enumConstants;
    private final ForyObjectMap<MetaStringBytes, Enum> metaStringtoEnumRepresentation;
    private final MetaStringBytes[] metaStringBytesArrByEnumOrdinal;

    public EnumSerializer(Fory fory, Class<Enum> cls) {
        super(fory, cls, false);
        this.metaStringResolver = fory.getMetaStringResolver();
        if (cls.isEnum()) {
            this.enumConstants = cls.getEnumConstants();
        } else {
            Preconditions.checkArgument(Enum.class.isAssignableFrom(cls) && cls != Enum.class);
            Class<?> enclosingClass = cls.getEnclosingClass();
            Preconditions.checkNotNull(enclosingClass);
            Preconditions.checkArgument(enclosingClass.isEnum());
            this.enumConstants = (Enum[])enclosingClass.getEnumConstants();
        }
        this.metaStringBytesArrByEnumOrdinal = new MetaStringBytes[this.enumConstants.length];
        if (fory.getConfig().serializeEnumByName()) {
            int initialCapacity = (int)Math.ceil((float)this.enumConstants.length / 0.5f);
            this.metaStringtoEnumRepresentation = new ForyObjectMap(initialCapacity, 0.5f);
            for (Enum enumConstant : this.enumConstants) {
                if (enumConstant == null) continue;
                MetaString ms = Encoders.GENERIC_ENCODER.encode(enumConstant.name());
                MetaStringBytes msb = this.metaStringResolver.getOrCreateMetaStringBytes(ms);
                this.metaStringtoEnumRepresentation.put(msb, enumConstant);
                this.metaStringBytesArrByEnumOrdinal[enumConstant.ordinal()] = msb;
            }
        } else {
            this.metaStringtoEnumRepresentation = null;
        }
    }

    @Override
    public void write(MemoryBuffer buffer, Enum value) {
        if (this.fory.getConfig().serializeEnumByName()) {
            MetaStringBytes metaStringBytes = this.metaStringBytesArrByEnumOrdinal[value.ordinal()];
            this.metaStringResolver.writeMetaStringBytes(buffer, metaStringBytes);
        } else {
            buffer.writeVarUint32Small7(value.ordinal());
        }
    }

    @Override
    public Enum read(MemoryBuffer buffer) {
        if (this.fory.getConfig().serializeEnumByName()) {
            MetaStringBytes metaStringBytes = this.metaStringResolver.readMetaStringBytes(buffer);
            Enum e = this.metaStringtoEnumRepresentation.get(metaStringBytes);
            if (e != null) {
                return e;
            }
            return this.handleNonexistentEnumValue(metaStringBytes.decode(Encoders.GENERIC_DECODER));
        }
        int value = buffer.readVarUint32Small7();
        if (value >= this.enumConstants.length) {
            return this.handleNonexistentEnumValue(value);
        }
        return this.enumConstants[value];
    }

    @Override
    public void xwrite(MemoryBuffer buffer, Enum value) {
        buffer.writeVarUint32Small7(value.ordinal());
    }

    @Override
    public Enum xread(MemoryBuffer buffer) {
        int value = buffer.readVarUint32Small7();
        if (value >= this.enumConstants.length) {
            return this.handleNonexistentEnumValue(value);
        }
        return this.enumConstants[value];
    }

    private Enum handleNonexistentEnumValue(int value) {
        if (this.fory.getConfig().deserializeNonexistentEnumValueAsNull()) {
            return null;
        }
        throw new IllegalArgumentException(String.format("Enum ordinal %s not in %s", value, Arrays.toString(this.enumConstants)));
    }

    private Enum handleNonexistentEnumValue(String value) {
        if (this.fory.getConfig().deserializeNonexistentEnumValueAsNull()) {
            return null;
        }
        throw new IllegalArgumentException(String.format("Enum string %s not in %s", value, Arrays.toString(this.enumConstants)));
    }
}

