/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.ClassInfoHolder;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.resolver.RefResolver;
import org.apache.fory.resolver.XtypeResolver;
import org.apache.fory.serializer.AbstractObjectSerializer;
import org.apache.fory.serializer.Serializer;

interface SerializationBinding {
    public <T> void writeRef(MemoryBuffer var1, T var2);

    public <T> void writeRef(MemoryBuffer var1, T var2, Serializer<T> var3);

    public void writeRef(MemoryBuffer var1, Object var2, ClassInfoHolder var3);

    public void writeRef(MemoryBuffer var1, Object var2, ClassInfo var3);

    public void writeNonRef(MemoryBuffer var1, Object var2);

    public void writeNonRef(MemoryBuffer var1, Object var2, ClassInfo var3);

    public void writeNonRef(MemoryBuffer var1, Object var2, ClassInfoHolder var3);

    public void writeNullable(MemoryBuffer var1, Object var2);

    public void writeNullable(MemoryBuffer var1, Object var2, Serializer var3);

    public void writeNullable(MemoryBuffer var1, Object var2, ClassInfoHolder var3);

    public void writeNullable(MemoryBuffer var1, Object var2, ClassInfo var3);

    public void writeNullable(MemoryBuffer var1, Object var2, ClassInfoHolder var3, boolean var4);

    public void writeNullable(MemoryBuffer var1, Object var2, Serializer var3, boolean var4);

    public void writeContainerFieldValue(MemoryBuffer var1, Object var2, ClassInfo var3);

    public void write(MemoryBuffer var1, Serializer var2, Object var3);

    public Object read(MemoryBuffer var1, Serializer var2);

    public <T> T readRef(MemoryBuffer var1, Serializer<T> var2);

    public Object readRef(MemoryBuffer var1, AbstractObjectSerializer.GenericTypeField var2);

    public Object readRef(MemoryBuffer var1, ClassInfoHolder var2);

    public Object readRef(MemoryBuffer var1);

    public Object readNonRef(MemoryBuffer var1);

    public Object readNonRef(MemoryBuffer var1, ClassInfoHolder var2);

    public Object readNonRef(MemoryBuffer var1, AbstractObjectSerializer.GenericTypeField var2);

    public Object readNullable(MemoryBuffer var1, Serializer<Object> var2);

    public Object readNullable(MemoryBuffer var1, Serializer<Object> var2, boolean var3);

    public Object readContainerFieldValue(MemoryBuffer var1, AbstractObjectSerializer.GenericTypeField var2);

    public Object readContainerFieldValueRef(MemoryBuffer var1, AbstractObjectSerializer.GenericTypeField var2);

    public int preserveRefId(int var1);

    public static SerializationBinding createBinding(Fory fory) {
        if (fory.isCrossLanguage()) {
            return new XlangSerializationBinding(fory);
        }
        return new JavaSerializationBinding(fory);
    }

    public static final class XlangSerializationBinding
    implements SerializationBinding {
        private final Fory fory;
        private final XtypeResolver xtypeResolver;
        private final RefResolver refResolver;

        XlangSerializationBinding(Fory fory) {
            this.fory = fory;
            this.xtypeResolver = fory.getXtypeResolver();
            this.refResolver = fory.getRefResolver();
        }

        @Override
        public <T> void writeRef(MemoryBuffer buffer, T obj) {
            this.fory.xwriteRef(buffer, obj);
        }

        @Override
        public <T> void writeRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
            this.fory.xwriteRef(buffer, obj, serializer);
        }

        @Override
        public void writeRef(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
            this.fory.xwriteRef(buffer, obj);
        }

        @Override
        public void writeRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
            this.fory.xwriteRef(buffer, obj);
        }

        @Override
        public <T> T readRef(MemoryBuffer buffer, Serializer<T> serializer) {
            return (T)this.fory.xreadRef(buffer, serializer);
        }

        @Override
        public Object readRef(MemoryBuffer buffer, AbstractObjectSerializer.GenericTypeField field) {
            if (field.isArray) {
                this.fory.getGenerics().pushGenericType(field.genericType);
                Object o = this.fory.xreadRef(buffer);
                this.fory.getGenerics().popGenericType();
                return o;
            }
            return this.fory.xreadRef(buffer);
        }

        @Override
        public Object readRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
            return this.fory.xreadRef(buffer);
        }

        @Override
        public Object readRef(MemoryBuffer buffer) {
            return this.fory.xreadRef(buffer);
        }

        @Override
        public Object readNonRef(MemoryBuffer buffer) {
            return this.fory.xreadNonRef(buffer);
        }

        @Override
        public Object readNonRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
            return this.fory.xreadNonRef(buffer, this.xtypeResolver.readClassInfo(buffer, classInfoHolder));
        }

        @Override
        public Object readNonRef(MemoryBuffer buffer, AbstractObjectSerializer.GenericTypeField field) {
            if (field.isArray) {
                this.fory.getGenerics().pushGenericType(field.genericType);
                Object o = this.fory.xreadNonRef(buffer);
                this.fory.getGenerics().popGenericType();
                return o;
            }
            return this.fory.xreadNonRef(buffer);
        }

        @Override
        public Object readNullable(MemoryBuffer buffer, Serializer<Object> serializer) {
            return this.fory.xreadNullable(buffer, serializer);
        }

        @Override
        public Object readNullable(MemoryBuffer buffer, Serializer<Object> serializer, boolean nullable) {
            if (nullable) {
                return this.readNullable(buffer, serializer);
            }
            return this.read(buffer, serializer);
        }

        @Override
        public Object readContainerFieldValue(MemoryBuffer buffer, AbstractObjectSerializer.GenericTypeField field) {
            return this.fory.xreadNonRef(buffer, field.containerClassInfo);
        }

        @Override
        public Object readContainerFieldValueRef(MemoryBuffer buffer, AbstractObjectSerializer.GenericTypeField field) {
            int nextReadRefId = this.refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.fory.xreadNonRef(buffer, field.containerClassInfo);
                this.refResolver.setReadObject(nextReadRefId, o);
                return o;
            }
            return this.refResolver.getReadObject();
        }

        @Override
        public void write(MemoryBuffer buffer, Serializer serializer, Object value) {
            serializer.xwrite(buffer, value);
        }

        @Override
        public Object read(MemoryBuffer buffer, Serializer serializer) {
            return serializer.xread(buffer);
        }

        @Override
        public void writeNonRef(MemoryBuffer buffer, Object obj) {
            this.fory.xwriteNonRef(buffer, obj);
        }

        @Override
        public void writeNonRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
            this.fory.xwriteNonRef(buffer, obj, classInfo);
        }

        @Override
        public void writeNonRef(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
            this.fory.xwriteNonRef(buffer, obj, this.xtypeResolver.getClassInfo(obj.getClass(), classInfoHolder));
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj) {
            if (obj == null) {
                buffer.writeByte((byte)-3);
            } else {
                buffer.writeByte((byte)-1);
                this.fory.xwriteNonRef(buffer, obj);
            }
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj, Serializer serializer) {
            if (obj == null) {
                buffer.writeByte((byte)-3);
            } else {
                buffer.writeByte((byte)-1);
                serializer.xwrite(buffer, obj);
            }
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
            if (obj == null) {
                buffer.writeByte((byte)-3);
            } else {
                buffer.writeByte((byte)-1);
                this.fory.xwriteNonRef(buffer, obj, this.xtypeResolver.getClassInfo(obj.getClass(), classInfoHolder));
            }
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
            if (obj == null) {
                buffer.writeByte((byte)-3);
            } else {
                buffer.writeByte((byte)-1);
                this.fory.xwriteNonRef(buffer, obj, classInfo);
            }
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder, boolean nullable) {
            if (nullable) {
                this.writeNullable(buffer, obj, classInfoHolder);
            } else {
                this.writeNonRef(buffer, obj, classInfoHolder);
            }
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj, Serializer serializer, boolean nullable) {
            if (nullable) {
                this.writeNullable(buffer, obj, serializer);
            } else {
                this.write(buffer, serializer, obj);
            }
        }

        @Override
        public void writeContainerFieldValue(MemoryBuffer buffer, Object fieldValue, ClassInfo classInfo) {
            this.fory.xwriteData(buffer, classInfo, fieldValue);
        }

        @Override
        public int preserveRefId(int refId) {
            return this.refResolver.preserveRefId(refId);
        }
    }

    public static final class JavaSerializationBinding
    implements SerializationBinding {
        private final Fory fory;
        private final ClassResolver classResolver;
        private final RefResolver refResolver;

        JavaSerializationBinding(Fory fory) {
            this.fory = fory;
            this.classResolver = fory.getClassResolver();
            this.refResolver = fory.getRefResolver();
        }

        @Override
        public <T> void writeRef(MemoryBuffer buffer, T obj) {
            this.fory.writeRef(buffer, obj);
        }

        @Override
        public <T> void writeRef(MemoryBuffer buffer, T obj, Serializer<T> serializer) {
            this.fory.writeRef(buffer, obj, serializer);
        }

        @Override
        public void writeRef(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
            this.fory.writeRef(buffer, obj, classInfoHolder);
        }

        @Override
        public void writeRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
            this.fory.writeRef(buffer, obj, classInfo);
        }

        @Override
        public <T> T readRef(MemoryBuffer buffer, Serializer<T> serializer) {
            return this.fory.readRef(buffer, serializer);
        }

        @Override
        public Object readRef(MemoryBuffer buffer, AbstractObjectSerializer.GenericTypeField field) {
            return this.fory.readRef(buffer, field.classInfoHolder);
        }

        @Override
        public Object readRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
            return this.fory.readRef(buffer, classInfoHolder);
        }

        @Override
        public Object readRef(MemoryBuffer buffer) {
            return this.fory.readRef(buffer);
        }

        @Override
        public Object readNonRef(MemoryBuffer buffer) {
            return this.fory.readNonRef(buffer);
        }

        @Override
        public Object readNonRef(MemoryBuffer buffer, ClassInfoHolder classInfoHolder) {
            return this.fory.readNonRef(buffer, classInfoHolder);
        }

        @Override
        public Object readNonRef(MemoryBuffer buffer, AbstractObjectSerializer.GenericTypeField field) {
            return this.fory.readNonRef(buffer, field.classInfoHolder);
        }

        @Override
        public Object readNullable(MemoryBuffer buffer, Serializer<Object> serializer) {
            return this.fory.readNullable(buffer, serializer);
        }

        @Override
        public Object readNullable(MemoryBuffer buffer, Serializer<Object> serializer, boolean nullable) {
            if (nullable) {
                return this.readNullable(buffer, serializer);
            }
            return this.read(buffer, serializer);
        }

        @Override
        public Object readContainerFieldValue(MemoryBuffer buffer, AbstractObjectSerializer.GenericTypeField field) {
            return this.fory.readNonRef(buffer, field.classInfoHolder);
        }

        @Override
        public Object readContainerFieldValueRef(MemoryBuffer buffer, AbstractObjectSerializer.GenericTypeField fieldInfo) {
            RefResolver refResolver = this.fory.getRefResolver();
            int nextReadRefId = refResolver.tryPreserveRefId(buffer);
            if (nextReadRefId >= -1) {
                Object o = this.fory.readData(buffer, this.classResolver.readClassInfo(buffer));
                refResolver.setReadObject(nextReadRefId, o);
                return o;
            }
            return refResolver.getReadObject();
        }

        @Override
        public void write(MemoryBuffer buffer, Serializer serializer, Object value) {
            serializer.write(buffer, value);
        }

        @Override
        public Object read(MemoryBuffer buffer, Serializer serializer) {
            return serializer.read(buffer);
        }

        @Override
        public void writeNonRef(MemoryBuffer buffer, Object obj) {
            this.fory.writeNonRef(buffer, obj);
        }

        @Override
        public void writeNonRef(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
            this.fory.writeNonRef(buffer, obj, classInfo);
        }

        @Override
        public void writeNonRef(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
            this.fory.writeNonRef(buffer, obj, this.classResolver.getClassInfo(obj.getClass(), classInfoHolder));
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj) {
            if (obj == null) {
                buffer.writeByte((byte)-3);
            } else {
                buffer.writeByte((byte)-1);
                this.writeNonRef(buffer, obj);
            }
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj, Serializer serializer) {
            if (obj == null) {
                buffer.writeByte((byte)-3);
            } else {
                buffer.writeByte((byte)-1);
                serializer.write(buffer, obj);
            }
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder) {
            if (obj == null) {
                buffer.writeByte((byte)-3);
            } else {
                buffer.writeByte((byte)-1);
                this.fory.writeNonRef(buffer, obj, this.classResolver.getClassInfo(obj.getClass(), classInfoHolder));
            }
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfo classInfo) {
            if (obj == null) {
                buffer.writeByte((byte)-3);
            } else {
                buffer.writeByte((byte)-1);
                this.fory.writeNonRef(buffer, obj, classInfo);
            }
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj, ClassInfoHolder classInfoHolder, boolean nullable) {
            if (nullable) {
                this.writeNullable(buffer, obj, classInfoHolder);
            } else {
                this.writeNonRef(buffer, obj, classInfoHolder);
            }
        }

        @Override
        public void writeNullable(MemoryBuffer buffer, Object obj, Serializer serializer, boolean nullable) {
            if (nullable) {
                this.writeNullable(buffer, obj, serializer);
            } else {
                this.write(buffer, serializer, obj);
            }
        }

        @Override
        public void writeContainerFieldValue(MemoryBuffer buffer, Object fieldValue, ClassInfo classInfo) {
            this.fory.writeNonRef(buffer, fieldValue, classInfo);
        }

        @Override
        public int preserveRefId(int refId) {
            return this.refResolver.preserveRefId(refId);
        }
    }
}

