/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Currency;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.regex.Pattern;
import org.apache.fory.Fory;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.memory.Platform;
import org.apache.fory.reflect.ReflectionUtils;
import org.apache.fory.resolver.ClassResolver;
import org.apache.fory.serializer.CompatibleSerializer;
import org.apache.fory.serializer.ImmutableSerializer;
import org.apache.fory.serializer.ObjectSerializer;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.StringSerializer;
import org.apache.fory.util.ExceptionUtils;
import org.apache.fory.util.GraalvmSupport;
import org.apache.fory.util.StringUtils;
import org.apache.fory.util.function.Functions;
import org.apache.fory.util.unsafe._JDKAccess;

public class Serializers {
    private static final Cache<Class, Tuple2<MethodType, MethodHandle>> CTR_MAP;
    private static final MethodType SIG1;
    private static final MethodType SIG2;
    private static final MethodType SIG3;
    private static final MethodType SIG4;
    private static final ToIntFunction GET_CODER;
    private static final Function GET_VALUE;

    public static <T> Serializer<T> newSerializer(Fory fory, Class type, Class<? extends Serializer> serializerClass) {
        Serializer serializer = fory.getClassResolver().getSerializer(type, false);
        try {
            if (serializerClass == ObjectSerializer.class) {
                return new ObjectSerializer(fory, type);
            }
            if (serializerClass == CompatibleSerializer.class) {
                return new CompatibleSerializer(fory, type);
            }
            Tuple2 ctrInfo = (Tuple2)CTR_MAP.getIfPresent(serializerClass);
            if (ctrInfo != null) {
                MethodType sig = (MethodType)ctrInfo.f0;
                MethodHandle handle = (MethodHandle)ctrInfo.f1;
                if (sig.equals((Object)SIG1)) {
                    return handle.invoke(fory, type);
                }
                if (sig.equals((Object)SIG2)) {
                    return handle.invoke(fory);
                }
                if (sig.equals((Object)SIG3)) {
                    return handle.invoke(type);
                }
                return handle.invoke();
            }
            return Serializers.createSerializer(fory, type, serializerClass);
        }
        catch (InvocationTargetException e) {
            fory.getClassResolver().resetSerializer(type, serializer);
            if (e.getCause() != null) {
                Platform.throwException(e.getCause());
            } else {
                Platform.throwException(e);
            }
        }
        catch (Throwable t) {
            fory.getClassResolver().resetSerializer(type, serializer);
            Platform.throwException(t);
        }
        throw new IllegalStateException("unreachable");
    }

    private static <T> Serializer<T> createSerializer(Fory fory, Class<?> type, Class<? extends Serializer> serializerClass) throws Throwable {
        MethodHandles.Lookup lookup = _JDKAccess._trustedLookup(serializerClass);
        try {
            MethodHandle ctr = lookup.findConstructor(serializerClass, SIG1);
            CTR_MAP.put(serializerClass, Tuple2.of(SIG1, ctr));
            return ctr.invoke(fory, type);
        }
        catch (NoSuchMethodException e) {
            ExceptionUtils.ignore(e);
            try {
                MethodHandle ctr = lookup.findConstructor(serializerClass, SIG2);
                CTR_MAP.put(serializerClass, Tuple2.of(SIG2, ctr));
                return ctr.invoke(fory);
            }
            catch (NoSuchMethodException e2) {
                ExceptionUtils.ignore(e2);
                try {
                    MethodHandle ctr = lookup.findConstructor(serializerClass, SIG3);
                    CTR_MAP.put(serializerClass, Tuple2.of(SIG3, ctr));
                    return ctr.invoke(type);
                }
                catch (NoSuchMethodException e3) {
                    MethodHandle ctr = ReflectionUtils.getCtrHandle(serializerClass, new Class[0]);
                    CTR_MAP.put(serializerClass, Tuple2.of(SIG4, ctr));
                    return ctr.invoke();
                }
            }
        }
    }

    public static Object readPrimitiveValue(Fory fory, MemoryBuffer buffer, short classId) {
        switch (classId) {
            case 5: {
                return buffer.readBoolean();
            }
            case 6: {
                return buffer.readByte();
            }
            case 7: {
                return Character.valueOf(buffer.readChar());
            }
            case 8: {
                return buffer.readInt16();
            }
            case 9: {
                if (fory.compressInt()) {
                    return buffer.readVarInt32();
                }
                return buffer.readInt32();
            }
            case 10: {
                return Float.valueOf(buffer.readFloat32());
            }
            case 11: {
                return fory.readInt64(buffer);
            }
            case 12: {
                return buffer.readFloat64();
            }
        }
        throw new IllegalStateException("unreachable");
    }

    public static void registerDefaultSerializers(Fory fory) {
        ClassResolver resolver = fory.getClassResolver();
        resolver.registerSerializer(Class.class, new ClassSerializer(fory));
        resolver.registerSerializer(StringBuilder.class, new StringBuilderSerializer(fory));
        resolver.registerSerializer(StringBuffer.class, new StringBufferSerializer(fory));
        resolver.registerSerializer(BigInteger.class, new BigIntegerSerializer(fory));
        resolver.registerSerializer(BigDecimal.class, new BigDecimalSerializer(fory));
        resolver.registerSerializer(AtomicBoolean.class, new AtomicBooleanSerializer(fory));
        resolver.registerSerializer(AtomicInteger.class, new AtomicIntegerSerializer(fory));
        resolver.registerSerializer(AtomicLong.class, new AtomicLongSerializer(fory));
        resolver.registerSerializer(AtomicReference.class, new AtomicReferenceSerializer(fory));
        resolver.registerSerializer(Currency.class, new CurrencySerializer(fory));
        resolver.registerSerializer(URI.class, new URISerializer(fory));
        resolver.registerSerializer(Pattern.class, new RegexSerializer(fory));
        resolver.registerSerializer(UUID.class, new UUIDSerializer(fory));
        resolver.registerSerializer(Object.class, new EmptyObjectSerializer(fory));
    }

    static {
        ToIntFunction getCoder;
        CTR_MAP = GraalvmSupport.isGraalBuildtime() ? CacheBuilder.newBuilder().concurrencyLevel(32).build() : CacheBuilder.newBuilder().weakKeys().softValues().build();
        SIG1 = MethodType.methodType(Void.TYPE, Fory.class, Class.class);
        SIG2 = MethodType.methodType(Void.TYPE, Fory.class);
        SIG3 = MethodType.methodType(Void.TYPE, Class.class);
        SIG4 = MethodType.methodType(Void.TYPE);
        GET_VALUE = (Function)Functions.makeGetterFunction(StringBuilder.class.getSuperclass(), "getValue");
        try {
            Method getCoderMethod = StringBuilder.class.getSuperclass().getDeclaredMethod("getCoder", new Class[0]);
            getCoder = (ToIntFunction)Functions.makeGetterFunction(getCoderMethod, Integer.TYPE);
        }
        catch (NoSuchMethodException e) {
            getCoder = null;
        }
        GET_CODER = getCoder;
    }

    public static final class ClassSerializer
    extends ImmutableSerializer<Class> {
        public ClassSerializer(Fory fory) {
            super(fory, Class.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Class value) {
            this.fory.getClassResolver().writeClassInternal(buffer, value);
        }

        @Override
        public Class read(MemoryBuffer buffer) {
            return this.fory.getClassResolver().readClassInternal(buffer);
        }
    }

    public static final class StringBuilderSerializer
    extends AbstractStringBuilderSerializer<StringBuilder> {
        public StringBuilderSerializer(Fory fory) {
            super(fory, StringBuilder.class);
        }

        @Override
        public StringBuilder copy(StringBuilder origin) {
            return new StringBuilder(origin);
        }

        @Override
        public StringBuilder read(MemoryBuffer buffer) {
            return new StringBuilder(this.stringSerializer.readJavaString(buffer));
        }

        @Override
        public StringBuilder xread(MemoryBuffer buffer) {
            return new StringBuilder(this.stringSerializer.readString(buffer));
        }
    }

    public static final class StringBufferSerializer
    extends AbstractStringBuilderSerializer<StringBuffer> {
        public StringBufferSerializer(Fory fory) {
            super(fory, StringBuffer.class);
        }

        @Override
        public StringBuffer copy(StringBuffer origin) {
            return new StringBuffer(origin);
        }

        @Override
        public StringBuffer read(MemoryBuffer buffer) {
            return new StringBuffer(this.stringSerializer.readJavaString(buffer));
        }

        @Override
        public StringBuffer xread(MemoryBuffer buffer) {
            return new StringBuffer(this.stringSerializer.readString(buffer));
        }
    }

    public static final class BigIntegerSerializer
    extends ImmutableSerializer<BigInteger> {
        public BigIntegerSerializer(Fory fory) {
            super(fory, BigInteger.class);
        }

        @Override
        public void write(MemoryBuffer buffer, BigInteger value) {
            byte[] bytes = value.toByteArray();
            buffer.writeVarUint32Small7(bytes.length);
            buffer.writeBytes(bytes);
        }

        @Override
        public BigInteger read(MemoryBuffer buffer) {
            int len = buffer.readVarUint32Small7();
            byte[] bytes = buffer.readBytes(len);
            return new BigInteger(bytes);
        }
    }

    public static final class BigDecimalSerializer
    extends ImmutableSerializer<BigDecimal> {
        public BigDecimalSerializer(Fory fory) {
            super(fory, BigDecimal.class);
        }

        @Override
        public void write(MemoryBuffer buffer, BigDecimal value) {
            byte[] bytes = value.unscaledValue().toByteArray();
            buffer.writeVarUint32Small7(value.scale());
            buffer.writeVarUint32Small7(value.precision());
            buffer.writeVarUint32Small7(bytes.length);
            buffer.writeBytes(bytes);
        }

        @Override
        public BigDecimal read(MemoryBuffer buffer) {
            int scale = buffer.readVarUint32Small7();
            int precision = buffer.readVarUint32Small7();
            int len = buffer.readVarUint32Small7();
            byte[] bytes = buffer.readBytes(len);
            BigInteger bigInteger = new BigInteger(bytes);
            return new BigDecimal(bigInteger, scale, new MathContext(precision));
        }
    }

    public static final class AtomicBooleanSerializer
    extends Serializer<AtomicBoolean> {
        public AtomicBooleanSerializer(Fory fory) {
            super(fory, AtomicBoolean.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicBoolean value) {
            buffer.writeBoolean(value.get());
        }

        @Override
        public AtomicBoolean copy(AtomicBoolean origin) {
            return new AtomicBoolean(origin.get());
        }

        @Override
        public AtomicBoolean read(MemoryBuffer buffer) {
            return new AtomicBoolean(buffer.readBoolean());
        }
    }

    public static final class AtomicIntegerSerializer
    extends Serializer<AtomicInteger> {
        public AtomicIntegerSerializer(Fory fory) {
            super(fory, AtomicInteger.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicInteger value) {
            buffer.writeInt32(value.get());
        }

        @Override
        public AtomicInteger copy(AtomicInteger origin) {
            return new AtomicInteger(origin.get());
        }

        @Override
        public AtomicInteger read(MemoryBuffer buffer) {
            return new AtomicInteger(buffer.readInt32());
        }
    }

    public static final class AtomicLongSerializer
    extends Serializer<AtomicLong> {
        public AtomicLongSerializer(Fory fory) {
            super(fory, AtomicLong.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicLong value) {
            buffer.writeInt64(value.get());
        }

        @Override
        public AtomicLong copy(AtomicLong origin) {
            return new AtomicLong(origin.get());
        }

        @Override
        public AtomicLong read(MemoryBuffer buffer) {
            return new AtomicLong(buffer.readInt64());
        }
    }

    public static final class AtomicReferenceSerializer
    extends Serializer<AtomicReference> {
        public AtomicReferenceSerializer(Fory fory) {
            super(fory, AtomicReference.class);
        }

        @Override
        public void write(MemoryBuffer buffer, AtomicReference value) {
            this.fory.writeRef(buffer, value.get());
        }

        @Override
        public AtomicReference copy(AtomicReference origin) {
            return new AtomicReference(this.fory.copyObject(origin.get()));
        }

        @Override
        public AtomicReference read(MemoryBuffer buffer) {
            return new AtomicReference<Object>(this.fory.readRef(buffer));
        }
    }

    public static final class CurrencySerializer
    extends ImmutableSerializer<Currency> {
        public CurrencySerializer(Fory fory) {
            super(fory, Currency.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Currency object) {
            this.fory.writeJavaString(buffer, object.getCurrencyCode());
        }

        @Override
        public Currency read(MemoryBuffer buffer) {
            String currencyCode = this.fory.readJavaString(buffer);
            return Currency.getInstance(currencyCode);
        }
    }

    public static final class URISerializer
    extends ImmutableSerializer<URI> {
        public URISerializer(Fory fory) {
            super(fory, URI.class);
        }

        @Override
        public void write(MemoryBuffer buffer, URI uri) {
            this.fory.writeString(buffer, uri.toString());
        }

        @Override
        public URI read(MemoryBuffer buffer) {
            return URI.create(this.fory.readString(buffer));
        }
    }

    public static final class RegexSerializer
    extends ImmutableSerializer<Pattern> {
        public RegexSerializer(Fory fory) {
            super(fory, Pattern.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Pattern pattern) {
            this.fory.writeJavaString(buffer, pattern.pattern());
            buffer.writeInt32(pattern.flags());
        }

        @Override
        public Pattern read(MemoryBuffer buffer) {
            String regex = this.fory.readJavaString(buffer);
            int flags = buffer.readInt32();
            return Pattern.compile(regex, flags);
        }
    }

    public static final class UUIDSerializer
    extends ImmutableSerializer<UUID> {
        public UUIDSerializer(Fory fory) {
            super(fory, UUID.class);
        }

        @Override
        public void write(MemoryBuffer buffer, UUID uuid) {
            buffer.writeInt64(uuid.getMostSignificantBits());
            buffer.writeInt64(uuid.getLeastSignificantBits());
        }

        @Override
        public UUID read(MemoryBuffer buffer) {
            return new UUID(buffer.readInt64(), buffer.readInt64());
        }
    }

    public static final class EmptyObjectSerializer
    extends ImmutableSerializer<Object> {
        public EmptyObjectSerializer(Fory fory) {
            super(fory, Object.class);
        }

        @Override
        public void write(MemoryBuffer buffer, Object value) {
        }

        @Override
        public Object read(MemoryBuffer buffer) {
            return new Object();
        }
    }

    public static final class CharsetSerializer<T extends Charset>
    extends ImmutableSerializer<T> {
        public CharsetSerializer(Fory fory, Class<T> type) {
            super(fory, type);
        }

        @Override
        public void write(MemoryBuffer buffer, T object) {
            this.fory.writeJavaString(buffer, ((Charset)object).name());
        }

        @Override
        public T read(MemoryBuffer buffer) {
            return (T)Charset.forName(this.fory.readJavaString(buffer));
        }
    }

    public static abstract class AbstractStringBuilderSerializer<T extends CharSequence>
    extends Serializer<T> {
        protected final StringSerializer stringSerializer;

        public AbstractStringBuilderSerializer(Fory fory, Class<T> type) {
            super(fory, type);
            this.stringSerializer = new StringSerializer(fory);
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            this.stringSerializer.writeString(buffer, value.toString());
        }

        @Override
        public void write(MemoryBuffer buffer, T value) {
            if (GET_CODER != null) {
                int coder = GET_CODER.applyAsInt(value);
                byte[] v = (byte[])GET_VALUE.apply(value);
                int bytesLen = value.length();
                if (coder != 0) {
                    if (coder != 1) {
                        throw new UnsupportedOperationException("Unsupported coder " + coder);
                    }
                    bytesLen <<= 1;
                }
                long header = (long)bytesLen << 2 | (long)coder;
                buffer.writeVarUint64(header);
                buffer.writeBytes(v, 0, bytesLen);
            } else {
                char[] v = (char[])GET_VALUE.apply(value);
                if (StringUtils.isLatin(v)) {
                    this.stringSerializer.writeCharsLatin1(buffer, v, value.length());
                } else {
                    this.stringSerializer.writeCharsUTF16(buffer, v, value.length());
                }
            }
        }
    }

    public static abstract class CrossLanguageCompatibleSerializer<T>
    extends Serializer<T> {
        public CrossLanguageCompatibleSerializer(Fory fory, Class<T> cls) {
            super(fory, cls);
        }

        public CrossLanguageCompatibleSerializer(Fory fory, Class<T> cls, boolean needToWriteRef, boolean immutable) {
            super(fory, cls, needToWriteRef, immutable);
        }

        public CrossLanguageCompatibleSerializer(Fory fory, Class<T> cls, boolean needToWriteRef) {
            super(fory, cls, needToWriteRef);
        }

        @Override
        public void xwrite(MemoryBuffer buffer, T value) {
            this.write(buffer, value);
        }

        @Override
        public T xread(MemoryBuffer buffer) {
            return this.read(buffer);
        }
    }
}

