/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.meta;

import org.apache.fory.type.TypeUtils;

public class ClassSpec {
    public final String entireClassName;
    public final boolean isEnum;
    public final boolean isArray;
    public final int dimension;
    public final int typeId;
    public Class<?> type;

    public ClassSpec(Class<?> cls) {
        this(cls.getName(), cls.isEnum(), cls.isArray(), cls.isArray() ? TypeUtils.getArrayDimensions(cls) : 0, -1);
        this.type = cls;
    }

    public ClassSpec(Class<?> cls, int typeId) {
        this(cls.getName(), cls.isEnum(), cls.isArray(), cls.isArray() ? TypeUtils.getArrayDimensions(cls) : 0, typeId);
    }

    public ClassSpec(String entireClassName, boolean isEnum, boolean isArray, int dimension) {
        this(entireClassName, isEnum, isArray, dimension, -1);
    }

    public ClassSpec(String entireClassName, boolean isEnum, boolean isArray, int dimension, int typeId) {
        this.entireClassName = entireClassName;
        this.isEnum = isEnum;
        this.isArray = isArray;
        this.dimension = dimension;
        this.typeId = typeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassSpec classSpec = (ClassSpec)o;
        return this.entireClassName.equals(classSpec.entireClassName);
    }

    public int hashCode() {
        return this.entireClassName.hashCode();
    }
}

