/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.meta;

import java.util.ArrayList;
import java.util.List;
import org.apache.fory.collection.Tuple2;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.meta.ClassDef;
import org.apache.fory.meta.ClassDefDecoder;
import org.apache.fory.meta.ClassSpec;
import org.apache.fory.meta.Encoders;
import org.apache.fory.meta.MetaString;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.XtypeResolver;
import org.apache.fory.serializer.NonexistentClass;

class TypeDefDecoder {
    TypeDefDecoder() {
    }

    public static ClassDef decodeClassDef(XtypeResolver resolver, MemoryBuffer inputBuffer, long id) {
        int xtypeId;
        ClassInfo userTypeInfo;
        String typeName;
        String namespace;
        ClassInfo userTypeInfo2;
        Tuple2<byte[], byte[]> decoded = ClassDefDecoder.decodeClassDefBuf(inputBuffer, resolver, id);
        MemoryBuffer buffer = MemoryBuffer.fromByteArray((byte[])decoded.f0);
        byte header = buffer.readByte();
        int numFields = header & 0x1F;
        if (numFields == 31) {
            numFields += buffer.readVarUint32Small7() + 31;
        }
        ClassSpec classSpec = (header & 0x20) != 0 ? ((userTypeInfo2 = resolver.getUserTypeInfo(namespace = ClassDefDecoder.readPkgName(buffer), typeName = ClassDefDecoder.readTypeName(buffer))) == null ? new ClassSpec(NonexistentClass.NonexistentMetaShared.class) : new ClassSpec(userTypeInfo2.getCls())) : ((userTypeInfo = resolver.getUserTypeInfo(xtypeId = buffer.readVarUint32Small7())) == null ? new ClassSpec(NonexistentClass.NonexistentMetaShared.class, xtypeId) : new ClassSpec(userTypeInfo.getCls(), xtypeId));
        List<ClassDef.FieldInfo> classFields = TypeDefDecoder.readFieldsInfo(buffer, resolver, classSpec.entireClassName, numFields);
        boolean hasFieldsMeta = (id & 0x1000L) != 0L;
        return new ClassDef(classSpec, classFields, hasFieldsMeta, id, (byte[])decoded.f1);
    }

    private static List<ClassDef.FieldInfo> readFieldsInfo(MemoryBuffer buffer, XtypeResolver resolver, String className, int numFields) {
        ArrayList<ClassDef.FieldInfo> fieldInfos = new ArrayList<ClassDef.FieldInfo>(numFields);
        for (int i = 0; i < numFields; ++i) {
            byte header = buffer.readByte();
            int encodingFlags = header >>> 6 & 3;
            boolean useTagID = encodingFlags == 3;
            int fieldNameSize = header >>> 2 & 0xF;
            if (fieldNameSize == 15) {
                fieldNameSize += buffer.readVarUint32Small7();
            }
            ++fieldNameSize;
            boolean nullable = (header & 2) != 0;
            boolean trackingRef = (header & 1) != 0;
            int typeId = buffer.readVarUint32Small14();
            ClassDef.FieldType fieldType = ClassDef.FieldType.xread(buffer, resolver, typeId, nullable, trackingRef);
            if (useTagID) {
                throw new UnsupportedOperationException("Type tag not supported currently, parsed fieldInfos %s " + fieldInfos);
            }
            MetaString.Encoding encoding = Encoders.fieldNameEncodings[encodingFlags];
            String fieldName = Encoders.FIELD_NAME_DECODER.decode(buffer.readBytes(fieldNameSize), encoding);
            fieldInfos.add(new ClassDef.FieldInfo(className, fieldName, fieldType));
        }
        return fieldInfos;
    }
}

