/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.fory.Fory;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.reflect.FieldAccessor;
import org.apache.fory.resolver.ClassInfo;
import org.apache.fory.resolver.FieldResolver;
import org.apache.fory.serializer.AbstractObjectSerializer;
import org.apache.fory.serializer.CompatibleSerializerBase;
import org.apache.fory.serializer.Serializer;
import org.apache.fory.serializer.collection.CollectionLikeSerializer;
import org.apache.fory.serializer.collection.MapLikeSerializer;
import org.apache.fory.util.Preconditions;
import org.apache.fory.util.record.RecordInfo;
import org.apache.fory.util.record.RecordUtils;

public final class CompatibleSerializer<T>
extends CompatibleSerializerBase<T> {
    private static final int INDEX_FOR_SKIP_FILL_VALUES = -1;
    private final FieldResolver fieldResolver;
    private final RecordInfo recordInfo;

    public CompatibleSerializer(Fory fory, Class<T> cls) {
        super(fory, cls);
        this.classResolver.setSerializerIfAbsent(cls, this);
        this.fieldResolver = this.classResolver.getFieldResolver(cls);
        if (this.isRecord) {
            List<String> fieldNames = this.fieldResolver.getAllFieldsList().stream().map(FieldResolver.FieldInfo::getName).collect(Collectors.toList());
            this.recordInfo = new RecordInfo(cls, fieldNames);
        } else {
            this.recordInfo = null;
        }
    }

    public CompatibleSerializer(Fory fory, Class<T> cls, FieldResolver fieldResolver) {
        super(fory, cls);
        Preconditions.checkArgument(!this.isRecord, cls);
        this.recordInfo = null;
        this.fieldResolver = fieldResolver;
    }

    @Override
    public void write(MemoryBuffer buffer, T value) {
        for (FieldResolver.FieldInfo fieldInfo : this.fieldResolver.getEmbedTypes4Fields()) {
            buffer.writeInt32((int)fieldInfo.getEncodedFieldInfo());
            this.readAndWriteFieldValue(buffer, fieldInfo, value);
        }
        for (FieldResolver.FieldInfo fieldInfo : this.fieldResolver.getEmbedTypes9Fields()) {
            buffer.writeInt64(fieldInfo.getEncodedFieldInfo());
            this.readAndWriteFieldValue(buffer, fieldInfo, value);
        }
        for (FieldResolver.FieldInfo fieldInfo : this.fieldResolver.getEmbedTypesHashFields()) {
            buffer.writeInt64(fieldInfo.getEncodedFieldInfo());
            this.readAndWriteFieldValue(buffer, fieldInfo, value);
        }
        for (FieldResolver.FieldInfo fieldInfo : this.fieldResolver.getSeparateTypesHashFields()) {
            buffer.writeInt64(fieldInfo.getEncodedFieldInfo());
            this.readAndWriteFieldValue(buffer, fieldInfo, value);
        }
        buffer.writeInt64(this.fieldResolver.getEndTag());
    }

    public void writeFieldsValues(MemoryBuffer buffer, Object[] vals) {
        FieldResolver fieldResolver = this.fieldResolver;
        Fory fory = this.fory;
        int index = 0;
        for (FieldResolver.FieldInfo fieldInfo : fieldResolver.getEmbedTypes4Fields()) {
            buffer.writeInt32((int)fieldInfo.getEncodedFieldInfo());
            this.writeFieldValue(fieldInfo, buffer, vals[index++]);
        }
        for (FieldResolver.FieldInfo fieldInfo : fieldResolver.getEmbedTypes9Fields()) {
            buffer.writeInt64(fieldInfo.getEncodedFieldInfo());
            this.writeFieldValue(fieldInfo, buffer, vals[index++]);
        }
        for (FieldResolver.FieldInfo fieldInfo : fieldResolver.getEmbedTypesHashFields()) {
            buffer.writeInt64(fieldInfo.getEncodedFieldInfo());
            this.writeFieldValue(fieldInfo, buffer, vals[index++]);
        }
        for (FieldResolver.FieldInfo fieldInfo : fieldResolver.getSeparateTypesHashFields()) {
            buffer.writeInt64(fieldInfo.getEncodedFieldInfo());
            Object value = vals[index++];
            if (fory.getRefResolver().writeRefOrNull(buffer, value)) continue;
            byte fieldType = fieldInfo.getFieldType();
            buffer.writeByte(fieldType);
            Preconditions.checkArgument(fieldType == 0);
            ClassInfo classInfo = fieldInfo.getClassInfo(value.getClass());
            fory.writeNonRef(buffer, value, classInfo);
        }
        buffer.writeInt64(fieldResolver.getEndTag());
    }

    private void readAndWriteFieldValue(MemoryBuffer buffer, FieldResolver.FieldInfo fieldInfo, Object targetObject) {
        FieldAccessor fieldAccessor = fieldInfo.getFieldAccessor();
        boolean nullable = fieldInfo.isNullable();
        short classId = fieldInfo.getEmbeddedClassId();
        if (AbstractObjectSerializer.writePrimitiveFieldValueFailed(this.fory, buffer, targetObject, fieldAccessor, classId)) {
            boolean writeBasicObjectResult;
            Object fieldValue = fieldAccessor.getObject(targetObject);
            boolean bl = writeBasicObjectResult = nullable ? AbstractObjectSerializer.writeBasicNullableObjectFieldValueFailed(this.fory, buffer, fieldValue, classId) : AbstractObjectSerializer.writeBasicObjectFieldValueFailed(this.fory, buffer, fieldValue, classId);
            if (writeBasicObjectResult) {
                if (classId == 0) {
                    this.writeSeparateFieldValue(fieldInfo, buffer, fieldValue);
                } else {
                    ClassInfo classInfo = fieldInfo.getClassInfo(classId);
                    Serializer serializer = classInfo.getSerializer();
                    this.fory.writeRef(buffer, fieldValue, serializer);
                }
            }
        }
    }

    private void writeFieldValue(FieldResolver.FieldInfo fieldInfo, MemoryBuffer buffer, Object fieldValue) {
        short classId = fieldInfo.getEmbeddedClassId();
        switch (classId) {
            case 5: {
                buffer.writeBoolean((Boolean)fieldValue);
                return;
            }
            case 6: {
                buffer.writeByte((Byte)fieldValue);
                return;
            }
            case 7: {
                buffer.writeChar(((Character)fieldValue).charValue());
                return;
            }
            case 8: {
                buffer.writeInt16((Short)fieldValue);
                return;
            }
            case 9: {
                if (this.fory.compressInt()) {
                    buffer.writeVarInt32((Integer)fieldValue);
                } else {
                    buffer.writeInt32((Integer)fieldValue);
                }
                return;
            }
            case 10: {
                buffer.writeFloat32(((Float)fieldValue).floatValue());
                return;
            }
            case 11: {
                this.fory.writeInt64(buffer, (Long)fieldValue);
                return;
            }
            case 12: {
                buffer.writeFloat64((Double)fieldValue);
                return;
            }
            case 22: {
                this.fory.writeJavaStringRef(buffer, (String)fieldValue);
                break;
            }
            case 0: {
                this.writeSeparateFieldValue(fieldInfo, buffer, fieldValue);
                break;
            }
            default: {
                ClassInfo classInfo = fieldInfo.getClassInfo(classId);
                Serializer serializer = classInfo.getSerializer();
                this.fory.writeRef(buffer, fieldValue, serializer);
            }
        }
    }

    private void writeSeparateFieldValue(FieldResolver.FieldInfo fieldInfo, MemoryBuffer buffer, Object fieldValue) {
        if (!this.refResolver.writeRefOrNull(buffer, fieldValue)) {
            byte fieldType = fieldInfo.getFieldType();
            buffer.writeByte(fieldType);
            if (fieldType == 0) {
                ClassInfo classInfo = fieldInfo.getClassInfo(fieldValue.getClass());
                this.fory.writeNonRef(buffer, fieldValue, classInfo);
            } else if (fieldType == 1) {
                this.writeCollectionField(buffer, (FieldResolver.CollectionFieldInfo)fieldInfo, (Collection)fieldValue);
            } else if (fieldType == 4) {
                this.writeMapKVFinal(buffer, (FieldResolver.MapFieldInfo)fieldInfo, (Map)fieldValue);
            } else if (fieldType == 2) {
                this.writeMapKeyFinal(buffer, (FieldResolver.MapFieldInfo)fieldInfo, (Map)fieldValue);
            } else {
                Preconditions.checkArgument(fieldType == 3);
                this.writeMapValueFinal(buffer, (FieldResolver.MapFieldInfo)fieldInfo, (Map)fieldValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCollectionField(MemoryBuffer buffer, FieldResolver.CollectionFieldInfo fieldInfo, Collection fieldValue) {
        ClassInfo elementClassInfo = fieldInfo.getElementClassInfo();
        this.classResolver.writeClassInfo(buffer, elementClassInfo);
        ClassInfo classInfo = fieldInfo.getClassInfo(fieldValue.getClass());
        this.classResolver.writeClassInfo(buffer, classInfo);
        CollectionLikeSerializer collectionSerializer = (CollectionLikeSerializer)classInfo.getSerializer();
        try {
            collectionSerializer.setElementSerializer(elementClassInfo.getSerializer());
            collectionSerializer.write(buffer, fieldValue);
        }
        finally {
            collectionSerializer.setElementSerializer(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapKVFinal(MemoryBuffer buffer, FieldResolver.MapFieldInfo fieldInfo, Map fieldValue) {
        ClassInfo keyClassInfo = fieldInfo.getKeyClassInfo();
        ClassInfo valueClassInfo = fieldInfo.getValueClassInfo();
        this.classResolver.writeClassInfo(buffer, keyClassInfo);
        this.classResolver.writeClassInfo(buffer, valueClassInfo);
        ClassInfo classInfo = fieldInfo.getClassInfo(fieldValue.getClass());
        this.classResolver.writeClassInfo(buffer, classInfo);
        MapLikeSerializer mapSerializer = (MapLikeSerializer)classInfo.getSerializer();
        try {
            mapSerializer.setKeySerializer(keyClassInfo.getSerializer());
            mapSerializer.setValueSerializer(valueClassInfo.getSerializer());
            mapSerializer.write(buffer, fieldValue);
        }
        finally {
            mapSerializer.setKeySerializer(null);
            mapSerializer.setValueSerializer(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapKeyFinal(MemoryBuffer buffer, FieldResolver.MapFieldInfo fieldInfo, Map fieldValue) {
        ClassInfo keyClassInfo = fieldInfo.getKeyClassInfo();
        this.classResolver.writeClassInfo(buffer, keyClassInfo);
        ClassInfo classInfo = fieldInfo.getClassInfo(fieldValue.getClass());
        this.classResolver.writeClassInfo(buffer, classInfo);
        MapLikeSerializer mapSerializer = (MapLikeSerializer)classInfo.getSerializer();
        try {
            mapSerializer.setKeySerializer(keyClassInfo.getSerializer());
            mapSerializer.write(buffer, fieldValue);
        }
        finally {
            mapSerializer.setKeySerializer(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeMapValueFinal(MemoryBuffer buffer, FieldResolver.MapFieldInfo fieldInfo, Map fieldValue) {
        ClassInfo valueClassInfo = fieldInfo.getValueClassInfo();
        this.classResolver.writeClassInfo(buffer, valueClassInfo);
        ClassInfo classInfo = fieldInfo.getClassInfo(fieldValue.getClass());
        this.classResolver.writeClassInfo(buffer, classInfo);
        MapLikeSerializer mapSerializer = (MapLikeSerializer)classInfo.getSerializer();
        try {
            mapSerializer.setValueSerializer(valueClassInfo.getSerializer());
            mapSerializer.write(buffer, fieldValue);
        }
        finally {
            mapSerializer.setValueSerializer(null);
        }
    }

    @Override
    public T read(MemoryBuffer buffer) {
        if (this.isRecord) {
            Object[] fieldValues = new Object[this.fieldResolver.getNumFields()];
            this.readFields(buffer, fieldValues);
            fieldValues = RecordUtils.remapping(this.recordInfo, fieldValues);
            assert (this.objectCreator != null);
            Object t = this.objectCreator.newInstanceWithArguments(fieldValues);
            Arrays.fill(this.recordInfo.getRecordComponents(), null);
            return t;
        }
        Object obj = this.newBean();
        this.refResolver.reference(obj);
        return this.readAndSetFields(buffer, obj);
    }

    @Override
    public T readAndSetFields(MemoryBuffer buffer, T obj) {
        long endTag;
        long partFieldInfo = this.readEmbedTypes4Fields(buffer, obj, null, -1);
        if (partFieldInfo == (endTag = this.fieldResolver.getEndTag())) {
            return obj;
        }
        long tmp = buffer.readInt32();
        partFieldInfo = tmp << 32 | partFieldInfo & 0xFFFFFFFFL;
        if ((partFieldInfo = this.readEmbedTypes9Fields(buffer, partFieldInfo, obj, null, -1)) == endTag) {
            return obj;
        }
        if ((partFieldInfo = this.readEmbedTypesHashFields(buffer, partFieldInfo, obj, null, -1)) == endTag) {
            return obj;
        }
        this.readSeparateTypesHashField(buffer, partFieldInfo, obj, null, -1);
        return obj;
    }

    public void readFields(MemoryBuffer buffer, Object[] vals) {
        long endTag;
        int startIndex = 0;
        long partFieldInfo = this.readEmbedTypes4Fields(buffer, null, vals, startIndex);
        if (partFieldInfo == (endTag = this.fieldResolver.getEndTag())) {
            return;
        }
        long tmp = buffer.readInt32();
        partFieldInfo = tmp << 32 | partFieldInfo & 0xFFFFFFFFL;
        if ((partFieldInfo = this.readEmbedTypes9Fields(buffer, partFieldInfo, null, vals, startIndex += this.fieldResolver.getEmbedTypes4Fields().length)) == endTag) {
            return;
        }
        if ((partFieldInfo = this.readEmbedTypesHashFields(buffer, partFieldInfo, null, vals, startIndex += this.fieldResolver.getEmbedTypes9Fields().length)) == endTag) {
            return;
        }
        this.readSeparateTypesHashField(buffer, partFieldInfo, null, vals, startIndex += this.fieldResolver.getEmbedTypesHashFields().length);
    }

    private long readEmbedTypes4Fields(MemoryBuffer buffer, Object obj, Object[] vals, int startIndex) {
        long partFieldInfo = buffer.readInt32();
        FieldResolver.FieldInfo[] embedTypes4Fields = this.fieldResolver.getEmbedTypes4Fields();
        if (embedTypes4Fields.length > 0) {
            long minFieldInfo = embedTypes4Fields[0].getEncodedFieldInfo();
            while ((partFieldInfo & 3L) == 1L && partFieldInfo < minFieldInfo) {
                long part = this.fieldResolver.skipDataBy4(buffer, (int)partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readInt32();
            }
            for (int i = 0; i < embedTypes4Fields.length; ++i) {
                FieldResolver.FieldInfo fieldInfo = embedTypes4Fields[i];
                long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
                if (encodedFieldInfo == partFieldInfo) {
                    if (obj != null) {
                        this.readAndSetFieldValue(fieldInfo, buffer, obj);
                    } else {
                        vals[startIndex + i] = this.readFieldValue(fieldInfo, buffer);
                    }
                    partFieldInfo = buffer.readInt32();
                    continue;
                }
                if ((partFieldInfo & 3L) != 1L) break;
                if (partFieldInfo >= encodedFieldInfo) continue;
                long part = this.fieldResolver.skipDataBy4(buffer, (int)partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readInt32();
                --i;
            }
        }
        while ((partFieldInfo & 3L) == 1L) {
            long part = this.fieldResolver.skipDataBy4(buffer, (int)partFieldInfo);
            if (part != partFieldInfo) {
                return part;
            }
            partFieldInfo = buffer.readInt32();
        }
        return partFieldInfo;
    }

    private long readEmbedTypes9Fields(MemoryBuffer buffer, long partFieldInfo, Object obj, Object[] vals, int startIndex) {
        FieldResolver.FieldInfo[] embedTypes9Fields = this.fieldResolver.getEmbedTypes9Fields();
        if (embedTypes9Fields.length > 0) {
            long minFieldInfo = embedTypes9Fields[0].getEncodedFieldInfo();
            while ((partFieldInfo & 7L) == 3L && partFieldInfo < minFieldInfo) {
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readInt64();
            }
            for (int i = 0; i < embedTypes9Fields.length; ++i) {
                FieldResolver.FieldInfo fieldInfo = embedTypes9Fields[i];
                long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
                if (encodedFieldInfo == partFieldInfo) {
                    if (obj != null) {
                        this.readAndSetFieldValue(fieldInfo, buffer, obj);
                    } else {
                        vals[startIndex + i] = this.readFieldValue(fieldInfo, buffer);
                    }
                    partFieldInfo = buffer.readInt64();
                    continue;
                }
                if ((partFieldInfo & 7L) != 3L) break;
                if (partFieldInfo >= encodedFieldInfo) continue;
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readInt64();
                --i;
            }
        }
        while ((partFieldInfo & 7L) == 3L) {
            long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
            if (part != partFieldInfo) {
                return part;
            }
            partFieldInfo = buffer.readInt64();
        }
        return partFieldInfo;
    }

    private long readEmbedTypesHashFields(MemoryBuffer buffer, long partFieldInfo, Object obj, Object[] vals, int startIndex) {
        FieldResolver.FieldInfo[] embedTypesHashFields = this.fieldResolver.getEmbedTypesHashFields();
        if (embedTypesHashFields.length > 0) {
            long minFieldInfo = embedTypesHashFields[0].getEncodedFieldInfo();
            while ((partFieldInfo & 7L) == 7L && partFieldInfo < minFieldInfo) {
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readInt64();
            }
            for (int i = 0; i < embedTypesHashFields.length; ++i) {
                FieldResolver.FieldInfo fieldInfo = embedTypesHashFields[i];
                long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
                if (encodedFieldInfo == partFieldInfo) {
                    if (obj != null) {
                        this.readAndSetFieldValue(fieldInfo, buffer, obj);
                    } else {
                        vals[startIndex + i] = this.readFieldValue(fieldInfo, buffer);
                    }
                    partFieldInfo = buffer.readInt64();
                    continue;
                }
                if ((partFieldInfo & 7L) != 7L) break;
                if (partFieldInfo >= encodedFieldInfo) continue;
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return part;
                }
                partFieldInfo = buffer.readInt64();
                --i;
            }
        }
        while ((partFieldInfo & 7L) == 7L) {
            long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
            if (part != partFieldInfo) {
                return part;
            }
            partFieldInfo = buffer.readInt64();
        }
        return partFieldInfo;
    }

    private void readSeparateTypesHashField(MemoryBuffer buffer, long partFieldInfo, Object obj, Object[] vals, int startIndex) {
        FieldResolver.FieldInfo[] separateTypesHashFields = this.fieldResolver.getSeparateTypesHashFields();
        if (separateTypesHashFields.length > 0) {
            long minFieldInfo = separateTypesHashFields[0].getEncodedFieldInfo();
            while ((partFieldInfo & 3L) == 0L && partFieldInfo < minFieldInfo) {
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return;
                }
                partFieldInfo = buffer.readInt64();
            }
            for (int i = 0; i < separateTypesHashFields.length; ++i) {
                FieldResolver.FieldInfo fieldInfo = separateTypesHashFields[i];
                long encodedFieldInfo = fieldInfo.getEncodedFieldInfo();
                if (encodedFieldInfo == partFieldInfo) {
                    if (obj != null) {
                        this.readAndSetFieldValue(fieldInfo, buffer, obj);
                    } else {
                        vals[startIndex + i] = this.readFieldValue(fieldInfo, buffer);
                    }
                    partFieldInfo = buffer.readInt64();
                    continue;
                }
                if ((partFieldInfo & 3L) != 0L) break;
                if (partFieldInfo >= encodedFieldInfo) continue;
                long part = this.fieldResolver.skipDataBy8(buffer, partFieldInfo);
                if (part != partFieldInfo) {
                    return;
                }
                partFieldInfo = buffer.readInt64();
                --i;
            }
        }
        this.fieldResolver.skipEndFields(buffer, partFieldInfo);
    }

    private void readAndSetFieldValue(FieldResolver.FieldInfo fieldInfo, MemoryBuffer buffer, Object targetObject) {
        FieldAccessor fieldAccessor = fieldInfo.getFieldAccessor();
        short classId = fieldInfo.getEmbeddedClassId();
        boolean nullable = fieldInfo.isNullable();
        if (AbstractObjectSerializer.readPrimitiveFieldValueFailed(this.fory, buffer, targetObject, fieldAccessor, classId) && (nullable ? AbstractObjectSerializer.readBasicNullableObjectFieldValueFailed(this.fory, buffer, targetObject, fieldAccessor, classId) : AbstractObjectSerializer.readBasicObjectFieldValueFailed(this.fory, buffer, targetObject, fieldAccessor, classId))) {
            if (classId == 0) {
                Object fieldValue = this.fieldResolver.readObjectField(buffer, fieldInfo);
                fieldAccessor.putObject(targetObject, fieldValue);
            } else {
                ClassInfo classInfo = fieldInfo.getClassInfo(classId);
                Serializer serializer = classInfo.getSerializer();
                fieldAccessor.putObject(targetObject, this.fory.readRef(buffer, serializer));
            }
        }
    }

    private Object readFieldValue(FieldResolver.FieldInfo fieldInfo, MemoryBuffer buffer) {
        short classId = fieldInfo.getEmbeddedClassId();
        switch (classId) {
            case 5: {
                return buffer.readBoolean();
            }
            case 6: {
                return buffer.readByte();
            }
            case 7: {
                return Character.valueOf(buffer.readChar());
            }
            case 8: {
                return buffer.readInt16();
            }
            case 9: {
                if (this.fory.compressInt()) {
                    return buffer.readVarInt32();
                }
                return buffer.readInt32();
            }
            case 10: {
                return Float.valueOf(buffer.readFloat32());
            }
            case 11: {
                return this.fory.readInt64(buffer);
            }
            case 12: {
                return buffer.readFloat64();
            }
            case 22: {
                return this.fory.readJavaStringRef(buffer);
            }
            case 0: {
                return this.fieldResolver.readObjectField(buffer, fieldInfo);
            }
        }
        ClassInfo classInfo = fieldInfo.getClassInfo(classId);
        Serializer serializer = classInfo.getSerializer();
        return this.fory.readRef(buffer, serializer);
    }
}

