/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.serializer.converter;

import com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.util.Set;
import org.apache.fory.reflect.FieldAccessor;
import org.apache.fory.serializer.converter.FieldConverter;
import org.apache.fory.type.TypeUtils;

public class FieldConverters {
    public static FieldConverter<?> getConverter(Class<?> from, Field field) {
        Class<?> to = field.getType();
        from = TypeUtils.wrap(from);
        if (to == Integer.TYPE) {
            if (IntConverter.compatibleTypes.contains(from)) {
                return new IntConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Integer.class) {
            if (IntConverter.compatibleTypes.contains(from)) {
                return new BoxedIntConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Boolean.TYPE) {
            if (BooleanConverter.compatibleTypes.contains(from)) {
                return new BooleanConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Boolean.class) {
            if (BooleanConverter.compatibleTypes.contains(from)) {
                return new BoxedBooleanConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Byte.TYPE) {
            if (ByteConverter.compatibleTypes.contains(from)) {
                return new ByteConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Byte.class) {
            if (ByteConverter.compatibleTypes.contains(from)) {
                return new BoxedByteConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Short.TYPE) {
            if (ShortConverter.compatibleTypes.contains(from)) {
                return new ShortConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Short.class) {
            if (ShortConverter.compatibleTypes.contains(from)) {
                return new BoxedShortConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Long.TYPE) {
            if (LongConverter.compatibleTypes.contains(from)) {
                return new LongConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Long.class) {
            if (LongConverter.compatibleTypes.contains(from)) {
                return new BoxedLongConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Float.TYPE) {
            if (FloatConverter.compatibleTypes.contains(from)) {
                return new FloatConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Float.class) {
            if (FloatConverter.compatibleTypes.contains(from)) {
                return new BoxedFloatConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Double.TYPE) {
            if (DoubleConverter.compatibleTypes.contains(from)) {
                return new DoubleConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == Double.class) {
            if (DoubleConverter.compatibleTypes.contains(from)) {
                return new BoxedDoubleConverter(FieldAccessor.createAccessor(field));
            }
        } else if (to == String.class && StringConverter.compatibleTypes.contains(from)) {
            return new StringConverter(FieldAccessor.createAccessor(field));
        }
        return null;
    }

    public static class IntConverter
    extends FieldConverter<Integer> {
        static Set<Class<?>> compatibleTypes = ImmutableSet.of(String.class, Long.class, Integer.class);

        protected IntConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Integer convertFrom(Object from) {
            if (from == null) {
                return 0;
            }
            if (from instanceof Long) {
                return Math.toIntExact((Long)from);
            }
            if (from instanceof Integer) {
                return (Integer)from;
            }
            if (from instanceof String) {
                return Integer.parseInt((String)from);
            }
            throw new UnsupportedOperationException("Incompatible type: " + from.getClass());
        }

        @Override
        public Integer convert(Object from) {
            return IntConverter.convertFrom(from);
        }
    }

    public static class BoxedIntConverter
    extends FieldConverter<Integer> {
        protected BoxedIntConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Integer convertFrom(Object from) {
            if (from == null) {
                return null;
            }
            return IntConverter.convertFrom(from);
        }

        @Override
        public Integer convert(Object from) {
            return BoxedIntConverter.convertFrom(from);
        }
    }

    public static class BooleanConverter
    extends FieldConverter<Boolean> {
        static Set<Class<?>> compatibleTypes = ImmutableSet.of(String.class, Boolean.class);

        protected BooleanConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Boolean convertFrom(Object from) {
            if (from == null) {
                return false;
            }
            if (from instanceof Boolean) {
                return (Boolean)from;
            }
            if (from instanceof String) {
                return Boolean.parseBoolean((String)from);
            }
            throw new UnsupportedOperationException("Incompatible type: " + from.getClass());
        }

        @Override
        public Boolean convert(Object from) {
            return BooleanConverter.convertFrom(from);
        }
    }

    public static class BoxedBooleanConverter
    extends FieldConverter<Boolean> {
        protected BoxedBooleanConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Boolean convertFrom(Object from) {
            if (from == null) {
                return null;
            }
            return BooleanConverter.convertFrom(from);
        }

        @Override
        public Boolean convert(Object from) {
            return BoxedBooleanConverter.convertFrom(from);
        }
    }

    public static class ByteConverter
    extends FieldConverter<Byte> {
        static Set<Class<?>> compatibleTypes = ImmutableSet.of(String.class, Integer.class, Long.class, Short.class, Byte.class);

        protected ByteConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Byte convertFrom(Object from) {
            if (from == null) {
                return (byte)0;
            }
            if (from instanceof Byte) {
                return (Byte)from;
            }
            if (from instanceof Integer) {
                return ((Integer)from).byteValue();
            }
            if (from instanceof Long) {
                return ((Long)from).byteValue();
            }
            if (from instanceof Short) {
                return ((Short)from).byteValue();
            }
            if (from instanceof String) {
                return Byte.parseByte((String)from);
            }
            throw new UnsupportedOperationException("Incompatible type: " + from.getClass());
        }

        @Override
        public Byte convert(Object from) {
            return ByteConverter.convertFrom(from);
        }
    }

    public static class BoxedByteConverter
    extends FieldConverter<Byte> {
        protected BoxedByteConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Byte convertFrom(Object from) {
            if (from == null) {
                return null;
            }
            return ByteConverter.convertFrom(from);
        }

        @Override
        public Byte convert(Object from) {
            return BoxedByteConverter.convertFrom(from);
        }
    }

    public static class ShortConverter
    extends FieldConverter<Short> {
        static Set<Class<?>> compatibleTypes = ImmutableSet.of(String.class, Integer.class, Long.class, Short.class);

        protected ShortConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Short convertFrom(Object from) {
            if (from == null) {
                return (short)0;
            }
            if (from instanceof Short) {
                return (Short)from;
            }
            if (from instanceof Integer) {
                return ((Integer)from).shortValue();
            }
            if (from instanceof Long) {
                return ((Long)from).shortValue();
            }
            if (from instanceof String) {
                return Short.parseShort((String)from);
            }
            throw new UnsupportedOperationException("Incompatible type: " + from.getClass());
        }

        @Override
        public Short convert(Object from) {
            return ShortConverter.convertFrom(from);
        }
    }

    public static class BoxedShortConverter
    extends FieldConverter<Short> {
        protected BoxedShortConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Short convertFrom(Object from) {
            if (from == null) {
                return null;
            }
            return ShortConverter.convertFrom(from);
        }

        @Override
        public Short convert(Object from) {
            return BoxedShortConverter.convertFrom(from);
        }
    }

    public static class LongConverter
    extends FieldConverter<Long> {
        static Set<Class<?>> compatibleTypes = ImmutableSet.of(String.class, Long.class);

        protected LongConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Long convertFrom(Object from) {
            if (from == null) {
                return 0L;
            }
            if (from instanceof Long) {
                return (Long)from;
            }
            if (from instanceof String) {
                return Long.parseLong((String)from);
            }
            throw new UnsupportedOperationException("Incompatible type: " + from.getClass());
        }

        @Override
        public Long convert(Object from) {
            return LongConverter.convertFrom(from);
        }
    }

    public static class BoxedLongConverter
    extends FieldConverter<Long> {
        protected BoxedLongConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Long convertFrom(Object from) {
            if (from == null) {
                return null;
            }
            return LongConverter.convertFrom(from);
        }

        @Override
        public Long convert(Object from) {
            return BoxedLongConverter.convertFrom(from);
        }
    }

    public static class FloatConverter
    extends FieldConverter<Float> {
        static Set<Class<?>> compatibleTypes = ImmutableSet.of(String.class, Float.class);

        protected FloatConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Float convertFrom(Object from) {
            if (from == null) {
                return Float.valueOf(0.0f);
            }
            if (from instanceof String) {
                return Float.valueOf(Float.parseFloat((String)from));
            }
            if (from instanceof Float) {
                return (Float)from;
            }
            throw new UnsupportedOperationException("Incompatible type: " + from.getClass());
        }

        @Override
        public Float convert(Object from) {
            return FloatConverter.convertFrom(from);
        }
    }

    public static class BoxedFloatConverter
    extends FieldConverter<Float> {
        protected BoxedFloatConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Float convertFrom(Object from) {
            if (from == null) {
                return null;
            }
            return FloatConverter.convertFrom(from);
        }

        @Override
        public Float convert(Object from) {
            return BoxedFloatConverter.convertFrom(from);
        }
    }

    public static class DoubleConverter
    extends FieldConverter<Double> {
        static Set<Class<?>> compatibleTypes = ImmutableSet.of(String.class, Float.class, Double.class);

        protected DoubleConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Double convertFrom(Object from) {
            if (from == null) {
                return 0.0;
            }
            if (from instanceof String) {
                return Double.parseDouble((String)from);
            }
            if (from instanceof Double) {
                return (Double)from;
            }
            if (from instanceof Float) {
                return ((Float)from).doubleValue();
            }
            throw new UnsupportedOperationException("Incompatible type: " + from.getClass());
        }

        @Override
        public Double convert(Object from) {
            return DoubleConverter.convertFrom(from);
        }
    }

    public static class BoxedDoubleConverter
    extends FieldConverter<Double> {
        protected BoxedDoubleConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static Double convertFrom(Object from) {
            if (from == null) {
                return null;
            }
            return DoubleConverter.convertFrom(from);
        }

        @Override
        public Double convert(Object from) {
            return BoxedDoubleConverter.convertFrom(from);
        }
    }

    public static class StringConverter
    extends FieldConverter<String> {
        static Set<Class<?>> compatibleTypes = ImmutableSet.of(Integer.class, Long.class, Short.class, Byte.class, Boolean.class, Float.class, (Object[])new Class[]{Double.class});

        protected StringConverter(FieldAccessor fieldAccessor) {
            super(fieldAccessor);
        }

        public static String convertFrom(Object from) {
            if (from == null) {
                return null;
            }
            if (from instanceof Number || from instanceof Boolean) {
                return from.toString();
            }
            throw new UnsupportedOperationException("Incompatible type: " + from.getClass());
        }

        @Override
        public String convert(Object from) {
            return StringConverter.convertFrom(from);
        }
    }
}

