/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fory.util;

import java.lang.reflect.Constructor;
import java.util.Objects;
import org.apache.fory.Fory;
import org.apache.fory.exception.ForyException;
import org.apache.fory.memory.MemoryBuffer;
import org.apache.fory.serializer.Serializer;

public class GraalvmSupport {
    public static final boolean IN_GRAALVM_NATIVE_IMAGE;
    private static final String GRAAL_IMAGE_CODE_KEY = "org.graalvm.nativeimage.imagecode";
    private static final String GRAAL_IMAGE_BUILDTIME = "buildtime";
    private static final String GRAAL_IMAGE_RUNTIME = "runtime";

    public static boolean isGraalBuildtime() {
        return IN_GRAALVM_NATIVE_IMAGE && GRAAL_IMAGE_BUILDTIME.equals(System.getProperty(GRAAL_IMAGE_CODE_KEY));
    }

    public static boolean isGraalRuntime() {
        return IN_GRAALVM_NATIVE_IMAGE && GRAAL_IMAGE_RUNTIME.equals(System.getProperty(GRAAL_IMAGE_CODE_KEY));
    }

    public static ForyException throwNoArgCtrException(Class<?> type) {
        throw new ForyException("Please provide a no-arg constructor for " + type);
    }

    static {
        String imageCode = System.getProperty(GRAAL_IMAGE_CODE_KEY);
        IN_GRAALVM_NATIVE_IMAGE = imageCode != null;
    }

    public static class GraalvmSerializerHolder
    extends Serializer {
        private final Class serializerClass;
        private Serializer serializer;

        public GraalvmSerializerHolder(Fory fory, Class<?> type, Class<?> serializerClass) {
            super(fory, type);
            this.serializerClass = Objects.requireNonNull(serializerClass);
        }

        public Class<? extends Serializer> getSerializerClass() {
            return this.serializerClass;
        }

        public void write(MemoryBuffer buffer, Object value) {
            this.getSerializer().write(buffer, value);
        }

        public Object read(MemoryBuffer buffer) {
            return this.getSerializer().read(buffer);
        }

        private Serializer getSerializer() {
            if (this.serializer == null) {
                try {
                    Constructor ctr = this.serializerClass.getDeclaredConstructor(Fory.class, Class.class);
                    ctr.setAccessible(true);
                    this.serializer = (Serializer)ctr.newInstance(this.fory, this.type);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return this.serializer;
        }
    }
}

