/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.version;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Named;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rules.version.AbstractVersionEnforcer;
import org.codehaus.plexus.util.StringUtils;

@Named(value="requireJavaVersion")
public final class RequireJavaVersion
extends AbstractVersionEnforcer {
    private static final Pattern JDK8_VERSION_PATTERN = Pattern.compile("([\\d.]+)");
    private boolean display = false;

    @Override
    public void setVersion(String theVersion) {
        if ("8".equals(theVersion)) {
            super.setVersion("1.8");
            return;
        }
        if (!theVersion.contains("8")) {
            super.setVersion(theVersion);
            return;
        }
        Matcher matcher = JDK8_VERSION_PATTERN.matcher(theVersion);
        StringBuffer result = new StringBuffer();
        while (matcher.find()) {
            if ("8".equals(matcher.group(1))) {
                matcher.appendReplacement(result, "1.8");
                continue;
            }
            matcher.appendReplacement(result, "$1");
        }
        matcher.appendTail(result);
        super.setVersion(result.toString());
    }

    public void execute() throws EnforcerRuleException {
        String javaVersion = SystemUtils.JAVA_VERSION;
        String javaVersionNormalized = RequireJavaVersion.normalizeJDKVersion(javaVersion);
        if (this.display) {
            this.getLog().info((CharSequence)("Detected Java Version: '" + javaVersion + "'"));
            this.getLog().info((CharSequence)("Normalized Java Version: '" + javaVersionNormalized + "'"));
        } else {
            this.getLog().debug((CharSequence)("Detected Java Version: '" + javaVersion + "'"));
            this.getLog().debug((CharSequence)("Normalized Java Version: '" + javaVersionNormalized + "'"));
        }
        DefaultArtifactVersion detectedJdkVersion = new DefaultArtifactVersion(javaVersionNormalized);
        this.getLog().debug((CharSequence)("Parsed Version: Major: " + detectedJdkVersion.getMajorVersion() + " Minor: " + detectedJdkVersion.getMinorVersion() + " Incremental: " + detectedJdkVersion.getIncrementalVersion() + " Build: " + detectedJdkVersion.getBuildNumber() + " Qualifier: " + detectedJdkVersion.getQualifier()));
        this.setCustomMessageIfNoneConfigured((ArtifactVersion)detectedJdkVersion, this.getVersion());
        this.enforceVersion("JDK", this.getVersion(), (ArtifactVersion)detectedJdkVersion);
    }

    public static String normalizeJDKVersion(String theJdkVersion) {
        theJdkVersion = theJdkVersion.replaceAll("_|-", ".");
        String[] tokenArray = StringUtils.split((String)theJdkVersion, (String)".");
        List<String> tokens = Arrays.asList(tokenArray);
        StringBuilder buffer = new StringBuilder(theJdkVersion.length());
        Iterator<String> iter = tokens.iterator();
        for (int i = 0; i < tokens.size() && i < 4; ++i) {
            String section = iter.next();
            if ((section = section.replaceAll("[^0-9]", "")) == null || section.isEmpty()) continue;
            buffer.append(Integer.parseInt(section));
            if (i != 2) {
                buffer.append('.');
                continue;
            }
            buffer.append('-');
        }
        String version = buffer.toString();
        version = StringUtils.stripEnd((String)version, (String)"-");
        return StringUtils.stripEnd((String)version, (String)".");
    }

    private void setCustomMessageIfNoneConfigured(ArtifactVersion detectedJdkVersion, String allowedVersionRange) {
        if (this.getMessage() == null) {
            String version;
            try {
                VersionRange vr = VersionRange.createFromVersionSpec((String)allowedVersionRange);
                version = AbstractVersionEnforcer.toString(vr);
            }
            catch (InvalidVersionSpecificationException e) {
                this.getLog().debug((CharSequence)("Could not parse allowed version range " + allowedVersionRange + " " + e.getMessage()));
                version = allowedVersionRange;
            }
            String message = String.format("Detected JDK version %s (JAVA_HOME=%s) is not in the allowed range %s.", detectedJdkVersion, SystemUtils.JAVA_HOME, version);
            super.setMessage(message);
        }
    }

    public String toString() {
        return String.format("%s[message=%s, version=%s, display=%b]", ((Object)((Object)this)).getClass().getSimpleName(), this.getMessage(), this.getVersion(), this.display);
    }
}

