/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.ap.internal.processor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.mapstruct.ap.internal.model.Annotation;
import org.mapstruct.ap.internal.model.Mapper;
import org.mapstruct.ap.internal.model.annotation.AnnotationElement;
import org.mapstruct.ap.internal.processor.AnnotationBasedComponentModelProcessor;

public class SpringComponentProcessor
extends AnnotationBasedComponentModelProcessor {
    @Override
    protected String getComponentModelIdentifier() {
        return "spring";
    }

    @Override
    protected List<Annotation> getTypeAnnotations(Mapper mapper) {
        ArrayList<Annotation> typeAnnotations = new ArrayList<Annotation>();
        if (!this.isAlreadyAnnotatedAsSpringStereotype(mapper)) {
            typeAnnotations.add(this.component());
        }
        if (mapper.getDecorator() != null) {
            typeAnnotations.add(this.qualifierDelegate());
        }
        return typeAnnotations;
    }

    @Override
    protected List<Annotation> getDecoratorAnnotations() {
        return Arrays.asList(this.component(), this.primary());
    }

    @Override
    protected List<Annotation> getMapperReferenceAnnotations() {
        return Collections.singletonList(this.autowired());
    }

    @Override
    protected List<Annotation> getDelegatorReferenceAnnotations(Mapper mapper) {
        return Arrays.asList(this.autowired(), this.qualifierDelegate());
    }

    @Override
    protected boolean requiresGenerationOfDecoratorClass() {
        return true;
    }

    private Annotation autowired() {
        return new Annotation(this.getTypeFactory().getType("org.springframework.beans.factory.annotation.Autowired"));
    }

    private Annotation qualifierDelegate() {
        return new Annotation(this.getTypeFactory().getType("org.springframework.beans.factory.annotation.Qualifier"), Collections.singletonList(new AnnotationElement(AnnotationElement.AnnotationElementType.STRING, Collections.singletonList("delegate"))));
    }

    private Annotation primary() {
        return new Annotation(this.getTypeFactory().getType("org.springframework.context.annotation.Primary"));
    }

    private Annotation component() {
        return new Annotation(this.getTypeFactory().getType("org.springframework.stereotype.Component"));
    }

    private boolean isAlreadyAnnotatedAsSpringStereotype(Mapper mapper) {
        HashSet handledElements = new HashSet();
        return mapper.getAnnotations().stream().anyMatch(annotation -> this.isOrIncludesComponentAnnotation((Annotation)annotation, (Set<Element>)handledElements));
    }

    private boolean isOrIncludesComponentAnnotation(Annotation annotation, Set<Element> handledElements) {
        return this.isOrIncludesComponentAnnotation(annotation.getType().getTypeElement(), handledElements);
    }

    private boolean isOrIncludesComponentAnnotation(Element element, Set<Element> handledElements) {
        if ("org.springframework.stereotype.Component".equals(((TypeElement)element).getQualifiedName().toString())) {
            return true;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            Element annotationMirrorElement = annotationMirror.getAnnotationType().asElement();
            if (this.isAnnotationInPackage(annotationMirrorElement, "java.lang.annotation") || handledElements.contains(annotationMirrorElement)) continue;
            handledElements.add(annotationMirrorElement);
            boolean isOrIncludesComponentAnnotation = this.isOrIncludesComponentAnnotation(annotationMirrorElement, handledElements);
            if (!isOrIncludesComponentAnnotation) continue;
            return true;
        }
        return false;
    }

    private PackageElement getPackageOf(Element element) {
        while (element.getKind() != ElementKind.PACKAGE) {
            element = element.getEnclosingElement();
        }
        return (PackageElement)element;
    }

    private boolean isAnnotationInPackage(Element element, String packageFQN) {
        return packageFQN.equals(this.getPackageOf(element).getQualifiedName().toString());
    }
}

