/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.CompletionHandler;
import java.nio.channels.SeekableByteChannel;
import java.util.Arrays;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import org.redisson.RedissonBucket;
import org.redisson.api.RBinaryStream;
import org.redisson.api.RFuture;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonBinaryStream
extends RedissonBucket<byte[]>
implements RBinaryStream {
    protected RedissonBinaryStream(CommandAsyncExecutor connectionManager, String name) {
        super(ByteArrayCodec.INSTANCE, connectionManager, name);
    }

    @Override
    public InputStream getInputStream() {
        return new RedissonInputStream();
    }

    @Override
    public OutputStream getOutputStream() {
        return new RedissonOutputStream();
    }

    @Override
    public SeekableByteChannel getChannel() {
        return new RedissonByteChannel();
    }

    @Override
    public AsynchronousByteChannel getAsynchronousChannel() {
        return new RedissonAsynchronousByteChannel();
    }

    class RedissonInputStream
    extends InputStream {
        private volatile long index;
        private volatile long mark;

        RedissonInputStream() {
        }

        @Override
        public long skip(long n) throws IOException {
            long k = RedissonBinaryStream.this.size() - this.index;
            if (n < k) {
                k = n;
                if (n < 0L) {
                    k = 0L;
                }
            }
            this.index += k;
            return k;
        }

        @Override
        public void mark(int readlimit) {
            this.mark = this.index;
        }

        @Override
        public void reset() {
            this.index = this.mark;
        }

        @Override
        public int available() throws IOException {
            return (int)(RedissonBinaryStream.this.size() - this.index);
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            int len = this.read(b);
            if (len == -1) {
                return -1;
            }
            return b[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || len > b.length - off) {
                throw new IndexOutOfBoundsException();
            }
            byte[] data = (byte[])RedissonBinaryStream.this.get(RedissonBinaryStream.this.commandExecutor.readAsync(RedissonBinaryStream.this.getRawName(), RedissonBinaryStream.this.codec, RedisCommands.GETRANGE, RedissonBinaryStream.this.getRawName(), this.index, this.index + (long)len - 1L));
            if (data.length == 0) {
                return -1;
            }
            this.index += (long)len;
            System.arraycopy(data, 0, b, off, data.length);
            return data.length;
        }
    }

    class RedissonOutputStream
    extends OutputStream {
        RedissonOutputStream() {
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] dest;
            if (b.length == len && off == 0) {
                dest = b;
            } else {
                dest = new byte[len];
                System.arraycopy(b, off, dest, 0, len);
            }
            RedissonBinaryStream.this.get(RedissonBinaryStream.this.commandExecutor.writeAsync(RedissonBinaryStream.this.getRawName(), RedissonBinaryStream.this.codec, RedisCommands.APPEND, RedissonBinaryStream.this.getRawName(), dest));
        }
    }

    class RedissonByteChannel
    implements SeekableByteChannel {
        int position;

        RedissonByteChannel() {
        }

        @Override
        public int read(ByteBuffer dst) throws IOException {
            byte[] data = (byte[])RedissonBinaryStream.this.get(RedissonBinaryStream.this.commandExecutor.readAsync(RedissonBinaryStream.this.getRawName(), RedissonBinaryStream.this.codec, RedisCommands.GETRANGE, RedissonBinaryStream.this.getRawName(), this.position, this.position + dst.remaining() - 1));
            if (data.length == 0) {
                return -1;
            }
            this.position += data.length;
            dst.put(data);
            return data.length;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            ByteBuf b = Unpooled.wrappedBuffer((ByteBuffer)src);
            RedissonBinaryStream.this.get(RedissonBinaryStream.this.commandExecutor.writeAsync(RedissonBinaryStream.this.getRawName(), RedissonBinaryStream.this.codec, RedisCommands.SETRANGE, RedissonBinaryStream.this.getRawName(), this.position, b));
            this.position += b.readableBytes();
            return b.readableBytes();
        }

        @Override
        public long position() throws IOException {
            return this.position;
        }

        @Override
        public SeekableByteChannel position(long newPosition) throws IOException {
            this.position = (int)newPosition;
            return this;
        }

        @Override
        public long size() throws IOException {
            return RedissonBinaryStream.this.size();
        }

        @Override
        public SeekableByteChannel truncate(long size) throws IOException {
            if (size < 0L) {
                throw new IllegalArgumentException("Negative size");
            }
            if (size == 0L) {
                RedissonBinaryStream.this.delete();
                return this;
            }
            RedissonBinaryStream.this.get(RedissonBinaryStream.this.commandExecutor.evalWriteAsync(RedissonBinaryStream.this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local len = redis.call('strlen', KEYS[1]); if tonumber(ARGV[1]) >= len then return;end;local limitedValue = redis.call('getrange', KEYS[1], 0, tonumber(ARGV[1])-1); redis.call('set', KEYS[1], limitedValue); ", Arrays.asList(RedissonBinaryStream.this.getRawName()), size));
            return this;
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }
    }

    public class RedissonAsynchronousByteChannel
    implements AsynchronousByteChannel {
        volatile int position;

        public long position() {
            return this.position;
        }

        public void position(long newPosition) {
            this.position = (int)newPosition;
        }

        @Override
        public <A> void read(ByteBuffer dst, A attachment, CompletionHandler<Integer, ? super A> handler) {
            RFuture res = (RFuture)this.read(dst);
            res.whenComplete((r, e) -> {
                if (e != null) {
                    handler.failed((Throwable)e, (Object)attachment);
                } else {
                    handler.completed((Integer)r, (Object)attachment);
                }
            });
        }

        @Override
        public Future<Integer> read(ByteBuffer dst) {
            RFuture res = RedissonBinaryStream.this.commandExecutor.readAsync(RedissonBinaryStream.this.getRawName(), RedissonBinaryStream.this.codec, RedisCommands.GETRANGE, RedissonBinaryStream.this.getRawName(), this.position, this.position + dst.remaining() - 1);
            CompletionStage<Integer> f = res.thenApply(data -> {
                if (((byte[])data).length == 0) {
                    return -1;
                }
                this.position += ((byte[])data).length;
                dst.put((byte[])data);
                return ((byte[])data).length;
            });
            return new CompletableFutureWrapper<Integer>(f);
        }

        @Override
        public <A> void write(ByteBuffer src, A attachment, CompletionHandler<Integer, ? super A> handler) {
            RFuture res = (RFuture)this.write(src);
            res.whenComplete((r, e) -> {
                if (e != null) {
                    handler.failed((Throwable)e, (Object)attachment);
                } else {
                    handler.completed((Integer)r, (Object)attachment);
                }
            });
        }

        @Override
        public Future<Integer> write(ByteBuffer src) {
            ByteBuf b = Unpooled.wrappedBuffer((ByteBuffer)src);
            RFuture res = RedissonBinaryStream.this.commandExecutor.writeAsync(RedissonBinaryStream.this.getRawName(), RedissonBinaryStream.this.codec, RedisCommands.SETRANGE, RedissonBinaryStream.this.getRawName(), this.position, b);
            CompletionStage<Integer> f = res.thenApply(r -> {
                this.position += b.readableBytes();
                return b.readableBytes();
            });
            return new CompletableFutureWrapper<Integer>(f);
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

