/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import org.redisson.RedissonMultimap;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetMultimapIterator;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RSet;
import org.redisson.api.RSetMultimap;
import org.redisson.api.listener.SetAddListener;
import org.redisson.api.listener.SetRemoveListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanAmountReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;

public class RedissonSetMultimap<K, V>
extends RedissonMultimap<K, V>
implements RSetMultimap<K, V> {
    private static final RedisStrictCommand<Boolean> SCARD_VALUE = new RedisStrictCommand<Boolean>("SCARD", new BooleanAmountReplayConvertor());
    private static final RedisCommand<Boolean> SISMEMBER_VALUE = new RedisCommand<Boolean>("SISMEMBER", new BooleanReplayConvertor());

    public RedissonSetMultimap(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    public RedissonSetMultimap(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local keys = redis.call('hgetall', KEYS[1]); local size = 0; for i, v in ipairs(keys) do if i % 2 == 0 then local name = ARGV[1] .. v; size = size + redis.call('scard', name); end;end; return size; ", Arrays.asList(this.getRawName()), this.prefix);
    }

    @Override
    public RFuture<Long> fastRemoveValueAsync(V ... values) {
        ArrayList<Object> args = new ArrayList<Object>(values.length + 1);
        args.add(this.prefix);
        this.encodeMapValues(args, Arrays.asList(values));
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_INTEGER, "local keys = redis.call('hgetall', KEYS[1]); local size = 0; for i, v in ipairs(keys) do if i % 2 == 0 then local name = ARGV[1] .. v; for j = 2, #ARGV, 1 do size = size + redis.call('srem', name, ARGV[j]); end; if redis.call('exists', name) == 0 then redis.call('hdel', KEYS[1], keys[i-1]); end; end;end; return 0; ", Arrays.asList(this.getRawName()), args.toArray());
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        String keyHash = this.keyHash(key);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, SCARD_VALUE, setName);
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        ByteBuf valueState = this.encodeMapValue(value);
        return this.commandExecutor.evalReadAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local keys = redis.call('hgetall', KEYS[1]); for i, v in ipairs(keys) do if i % 2 == 0 then local name = ARGV[2] .. v; if redis.call('sismember', name, ARGV[1]) == 1 then return 1; end;end;end; return 0; ", Arrays.asList(this.getRawName()), valueState, this.prefix);
    }

    @Override
    public RFuture<Boolean> containsEntryAsync(Object key, Object value) {
        String keyHash = this.keyHash(key);
        ByteBuf valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, SISMEMBER_VALUE, setName, valueState);
    }

    @Override
    public RFuture<Boolean> putAsync(K key, V value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        ByteBuf valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('hsetnx', KEYS[1], ARGV[1], ARGV[2]); return redis.call('sadd', KEYS[2], ARGV[3]); ", Arrays.asList(this.getRawName(), setName), keyState, keyHash, valueState);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        ByteBuf valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local res = redis.call('srem', KEYS[2], ARGV[2]); if res == 1 and redis.call('scard', KEYS[2]) == 0 then redis.call('hdel', KEYS[1], ARGV[1]); end; return res; ", Arrays.asList(this.getRawName(), setName), keyState, valueState);
    }

    @Override
    public RFuture<Boolean> putAllAsync(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        ByteBuf keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            ByteBuf valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN_AMOUNT, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); local n = 0; for i=3, #ARGV, 5000 do n = n + redis.call('sadd', KEYS[2], unpack(ARGV, i, math.min(i+4999, table.getn(ARGV)))) end; return n; ", Arrays.asList(this.getRawName(), setName), params.toArray());
    }

    @Override
    public RSet<V> get(K key) {
        String keyHash = this.keyHash(key);
        String setName = this.getValuesName(keyHash);
        return new InnerSet(setName, key);
    }

    @Override
    public Set<V> getAll(K key) {
        return (Set)super.getAll(key);
    }

    @Override
    public RFuture<Collection<V>> getAllAsync(K key) {
        String keyHash = this.keyHash(key);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readAsync(this.getRawName(), this.codec, RedisCommands.SMEMBERS, setName);
    }

    @Override
    public Set<V> removeAll(Object key) {
        return (Set)this.get(this.removeAllAsync(key));
    }

    @Override
    public RFuture<Collection<V>> removeAllAsync(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SET, "redis.call('hdel', KEYS[1], ARGV[1]); local members = redis.call('smembers', KEYS[2]); redis.call('del', KEYS[2]); return members; ", Arrays.asList(this.getRawName(), setName), keyState);
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return (Set)super.entries();
    }

    @Override
    public Set<V> replaceValues(K key, Iterable<? extends V> values) {
        return (Set)this.get(this.replaceValuesAsync(key, values));
    }

    @Override
    public void fastReplaceValues(K key, Iterable<? extends V> values) {
        this.get(this.fastReplaceValuesAsync(key, values));
    }

    @Override
    Iterator<V> valuesIterator() {
        return new RedissonSetMultimapIterator<K, V, V>(this, this.commandExecutor, this.codec){

            @Override
            V getValue(V entry) {
                return entry;
            }
        };
    }

    @Override
    RedissonSetMultimapIterator<K, V, Map.Entry<K, V>> entryIterator() {
        return new RedissonSetMultimapIterator(this, this.commandExecutor, this.codec);
    }

    @Override
    public RFuture<Collection<V>> replaceValuesAsync(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        ByteBuf keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            ByteBuf valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_SET, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); local members = redis.call('smembers', KEYS[2]); redis.call('del', KEYS[2]); if #ARGV > 2 then for i=3, #ARGV, 5000 do redis.call('sadd', KEYS[2], unpack(ARGV, i, math.min(i+4999, table.getn(ARGV)))) end; end; return members; ", Arrays.asList(this.getRawName(), setName), params.toArray());
    }

    @Override
    public RFuture<Void> fastReplaceValuesAsync(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        ByteBuf keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            ByteBuf valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_VOID, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); redis.call('del', KEYS[2]); if #ARGV > 2 then for i=3, #ARGV, 5000 do redis.call('sadd', KEYS[2], unpack(ARGV, i, math.min(i+4999, table.getn(ARGV)))) end; end; ", Arrays.asList(this.getRawName(), setName), params.toArray());
    }

    @Override
    protected <T extends ObjectListener> int addListener(String name, T listener, BiConsumer<T, String> consumer) {
        if (listener instanceof SetAddListener || listener instanceof SetRemoveListener) {
            String prefix = this.getValuesName("");
            return this.addListener(name, listener, consumer, m -> m.startsWith(prefix));
        }
        return super.addListener(name, listener, consumer);
    }

    @Override
    protected <T extends ObjectListener> RFuture<Integer> addListenerAsync(String name, T listener, BiConsumer<T, String> consumer) {
        if (listener instanceof SetAddListener || listener instanceof SetRemoveListener) {
            String prefix = this.getValuesName("");
            return this.addListenerAsync(name, listener, consumer, m -> m.startsWith(prefix));
        }
        return super.addListenerAsync(name, listener, consumer);
    }

    @Override
    public int addListener(ObjectListener listener) {
        if (listener instanceof SetAddListener) {
            return this.addListener("__keyevent@*:sadd", (SetAddListener)listener, SetAddListener::onAdd);
        }
        if (listener instanceof SetRemoveListener) {
            return this.addListener("__keyevent@*:srem", (SetRemoveListener)listener, SetRemoveListener::onRemove);
        }
        return super.addListener(listener);
    }

    @Override
    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        if (listener instanceof SetAddListener) {
            return this.addListenerAsync("__keyevent@*:sadd", (SetAddListener)listener, SetAddListener::onAdd);
        }
        if (listener instanceof SetRemoveListener) {
            return this.addListenerAsync("__keyevent@*:srem", (SetRemoveListener)listener, SetRemoveListener::onRemove);
        }
        return super.addListenerAsync(listener);
    }

    @Override
    public void removeListener(int listenerId) {
        this.removeListener(listenerId, "__keyevent@*:sadd", "__keyevent@*:srem");
        super.removeListener(listenerId);
    }

    @Override
    public RFuture<Void> removeListenerAsync(int listenerId) {
        return this.removeListenerAsync(listenerId, "__keyevent@*:sadd", "__keyevent@*:srem");
    }

    protected class InnerSet
    extends RedissonSet<V> {
        private final String setName;
        private final K key;

        public InnerSet(String setName, K key) {
            super(RedissonSetMultimap.this.codec, RedissonSetMultimap.this.commandExecutor, setName, null);
            this.setName = setName;
            this.key = key;
        }

        @Override
        public RFuture<Boolean> addAsync(V value) {
            return RedissonSetMultimap.this.putAsync(this.key, value);
        }

        @Override
        public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
            return RedissonSetMultimap.this.putAllAsync(this.key, c);
        }

        @Override
        public RFuture<Boolean> removeAsync(Object value) {
            return RedissonSetMultimap.this.removeAsync(this.key, value);
        }

        @Override
        public RFuture<Boolean> removeAllAsync(Collection<?> c) {
            if (c.isEmpty()) {
                return new CompletableFutureWrapper<Boolean>(false);
            }
            ArrayList<Object> args = new ArrayList<Object>(c.size() + 1);
            args.add(this.encodeMapKey(this.key));
            this.encode(args, c);
            return this.commandExecutor.evalWriteAsync(RedissonSetMultimap.this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN_AMOUNT, "local count = 0;for i=2, #ARGV, 5000 do count = count + redis.call('srem', KEYS[2], unpack(ARGV, i, math.min(i+4999, table.getn(ARGV)))) end; if count > 0 then if redis.call('scard', KEYS[2]) == 0 then redis.call('hdel', KEYS[1], ARGV[1]); end; return 1;end;return 0; ", Arrays.asList(RedissonSetMultimap.this.getRawName(), this.setName), args.toArray());
        }

        @Override
        public RFuture<Boolean> deleteAsync() {
            ByteBuf keyState = this.encodeMapKey(this.key);
            return RedissonSetMultimap.this.fastRemoveAsync(Arrays.asList(keyState), Arrays.asList(RedissonSetMultimap.this.getRawName(), this.setName), RedisCommands.EVAL_BOOLEAN_AMOUNT);
        }

        @Override
        public RFuture<Boolean> clearExpireAsync() {
            throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
        }

        @Override
        public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
            throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
        }

        @Override
        protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
            throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
        }

        @Override
        public RFuture<Long> remainTimeToLiveAsync() {
            throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
        }

        @Override
        public RFuture<Void> renameAsync(String newName) {
            throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
        }

        @Override
        public RFuture<Boolean> renamenxAsync(String newName) {
            throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
        }
    }
}

