/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.BuildInfo;

public class WebDriverException
extends RuntimeException {
    public static final String SESSION_ID = "Session ID";
    public static final String DRIVER_INFO = "Driver info";
    protected static final String BASE_SUPPORT_URL = "https://www.seleniumhq.org/exceptions/";
    private static final String HOST_NAME;
    private static final String HOST_ADDRESS;
    private Map<String, String> extraInfo = new HashMap<String, String>();

    public WebDriverException() {
    }

    public WebDriverException(String message) {
        super(message);
    }

    public WebDriverException(Throwable cause) {
        super(cause);
    }

    public WebDriverException(String message, Throwable cause) {
        super(message, cause);
    }

    @Override
    public String getMessage() {
        return super.getCause() instanceof WebDriverException ? super.getMessage() : this.createMessage(super.getMessage());
    }

    private String createMessage(String originalMessageString) {
        String supportMessage = this.getSupportUrl() == null ? "" : "For documentation on this error, please visit: " + this.getSupportUrl() + "\n";
        return (originalMessageString == null ? "" : originalMessageString + "\n") + supportMessage + this.getBuildInformation() + "\n" + this.getSystemInformation() + this.getAdditionalInformation();
    }

    public String getSystemInformation() {
        return String.format("System info: host: '%s', ip: '%s', os.name: '%s', os.arch: '%s', os.version: '%s', java.version: '%s'", HOST_NAME, HOST_ADDRESS, System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("os.version"), System.getProperty("java.version"));
    }

    public String getSupportUrl() {
        return null;
    }

    public BuildInfo getBuildInformation() {
        return new BuildInfo();
    }

    public static String getDriverName(StackTraceElement[] stackTraceElements) {
        String driverName = "unknown";
        for (StackTraceElement e : stackTraceElements) {
            if (!e.getClassName().endsWith("Driver")) continue;
            String[] bits = e.getClassName().split("\\.");
            driverName = bits[bits.length - 1];
        }
        return driverName;
    }

    public void addInfo(String key, String value) {
        this.extraInfo.put(key, value);
    }

    public String getAdditionalInformation() {
        if (!this.extraInfo.containsKey(DRIVER_INFO)) {
            this.extraInfo.put(DRIVER_INFO, "driver.version: " + WebDriverException.getDriverName(this.getStackTrace()));
        }
        String result = "";
        for (Map.Entry<String, String> entry : this.extraInfo.entrySet()) {
            if (entry.getValue() != null && entry.getValue().startsWith(entry.getKey())) {
                result = result + "\n" + entry.getValue();
                continue;
            }
            result = result + "\n" + entry.getKey() + ": " + entry.getValue();
        }
        return result;
    }

    static {
        String host;
        String current;
        block40: {
            current = System.getProperty("os.name");
            host = System.getenv("HOSTNAME");
            if (host == null) {
                host = System.getenv("COMPUTERNAME");
            }
            if (host == null && "Mac OS X".equals(current)) {
                try {
                    Process process = Runtime.getRuntime().exec("hostname");
                    if (!process.waitFor(2L, TimeUnit.SECONDS)) {
                        process.destroyForcibly();
                        process.waitFor(2L, TimeUnit.SECONDS);
                    }
                    if (process.exitValue() != 0) break block40;
                    try (InputStreamReader isr = new InputStreamReader(process.getInputStream());
                         BufferedReader reader = new BufferedReader(isr);){
                        host = reader.readLine();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (host == null) {
            try {
                host = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                host = "Unknown";
            }
        }
        HOST_NAME = host;
        String address = null;
        if ("Mac OS X".equals(current)) {
            try {
                NetworkInterface en0 = NetworkInterface.getByName("en0");
                Enumeration<InetAddress> addresses = en0.getInetAddresses();
                if (addresses.hasMoreElements()) {
                    InetAddress inetAddress = addresses.nextElement();
                    address = inetAddress.getHostAddress();
                }
            }
            catch (Exception en0) {
                // empty catch block
            }
        }
        if (address == null) {
            try {
                address = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e) {
                address = "Unknown";
            }
        }
        HOST_ADDRESS = address;
    }
}

