/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.bs.boot;

import cn.zhxu.bs.BeanReflector;
import cn.zhxu.bs.BeanSearcher;
import cn.zhxu.bs.DbMapping;
import cn.zhxu.bs.FieldConvertor;
import cn.zhxu.bs.FieldOp;
import cn.zhxu.bs.FieldOpPool;
import cn.zhxu.bs.MapSearcher;
import cn.zhxu.bs.MetaResolver;
import cn.zhxu.bs.PageExtractor;
import cn.zhxu.bs.ParamFilter;
import cn.zhxu.bs.ParamResolver;
import cn.zhxu.bs.ResultFilter;
import cn.zhxu.bs.SnippetResolver;
import cn.zhxu.bs.SqlExecutor;
import cn.zhxu.bs.SqlInterceptor;
import cn.zhxu.bs.SqlResolver;
import cn.zhxu.bs.boot.BeanSearcherConfigOnJsonKit;
import cn.zhxu.bs.boot.BeanSearcherConfigOnLabel;
import cn.zhxu.bs.boot.BeanSearcherConfigOnOracle;
import cn.zhxu.bs.boot.BeanSearcherConvertors;
import cn.zhxu.bs.boot.BeanSearcherParamFilters;
import cn.zhxu.bs.boot.DataSourceDialect;
import cn.zhxu.bs.boot.IllegalConfigException;
import cn.zhxu.bs.boot.NamedDataSource;
import cn.zhxu.bs.boot.SpringSqlExecutor;
import cn.zhxu.bs.boot.prop.BeanSearcherFieldConvertor;
import cn.zhxu.bs.boot.prop.BeanSearcherParams;
import cn.zhxu.bs.boot.prop.BeanSearcherProperties;
import cn.zhxu.bs.boot.prop.BeanSearcherSql;
import cn.zhxu.bs.convertor.DateFormatFieldConvertor;
import cn.zhxu.bs.dialect.Dialect;
import cn.zhxu.bs.dialect.DynamicDialect;
import cn.zhxu.bs.dialect.DynamicDialectSupport;
import cn.zhxu.bs.dialect.MySqlDialect;
import cn.zhxu.bs.dialect.OracleDialect;
import cn.zhxu.bs.dialect.PostgreSqlDialect;
import cn.zhxu.bs.dialect.SqlServerDialect;
import cn.zhxu.bs.group.DefaultGroupResolver;
import cn.zhxu.bs.group.ExprParser;
import cn.zhxu.bs.group.GroupPair;
import cn.zhxu.bs.group.GroupResolver;
import cn.zhxu.bs.implement.DefaultBeanReflector;
import cn.zhxu.bs.implement.DefaultBeanSearcher;
import cn.zhxu.bs.implement.DefaultDbMapping;
import cn.zhxu.bs.implement.DefaultMapSearcher;
import cn.zhxu.bs.implement.DefaultMetaResolver;
import cn.zhxu.bs.implement.DefaultParamResolver;
import cn.zhxu.bs.implement.DefaultSqlResolver;
import cn.zhxu.bs.implement.JoinParaSerializer;
import cn.zhxu.bs.implement.PageOffsetExtractor;
import cn.zhxu.bs.implement.PageSizeExtractor;
import cn.zhxu.bs.util.Cache;
import cn.zhxu.bs.util.LRUCache;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Primary;

@Configuration
@EnableConfigurationProperties(value={BeanSearcherProperties.class, BeanSearcherFieldConvertor.class, BeanSearcherParams.class, BeanSearcherSql.class})
@Import(value={BeanSearcherConvertors.class, BeanSearcherParamFilters.class, BeanSearcherConfigOnLabel.class, BeanSearcherConfigOnJsonKit.class, BeanSearcherConfigOnOracle.class})
public class BeanSearcherAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={PageExtractor.class})
    public PageExtractor pageExtractor(BeanSearcherParams config) {
        PageSizeExtractor extractor;
        PageSizeExtractor p;
        BeanSearcherParams.Pagination conf = config.getPagination();
        String type = conf.getType();
        if ("page".equals(type)) {
            p = new PageSizeExtractor();
            p.setPageName(conf.getPage());
            extractor = p;
        } else if ("offset".equals(type)) {
            p = new PageOffsetExtractor();
            p.setOffsetName(conf.getOffset());
            extractor = p;
        } else {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.type: " + type + "], only 'page' / 'offset' allowed.");
        }
        int defaultSize = conf.getDefaultSize();
        int maxAllowedSize = conf.getMaxAllowedSize();
        long maxAllowedOffset = conf.getMaxAllowedOffset();
        if (defaultSize > maxAllowedSize) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.default-size: " + defaultSize + "] can not greater than [bean-searcher.params.pagination.max-allowed-size: " + maxAllowedSize + "].");
        }
        if (defaultSize < 1) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.default-size: " + defaultSize + "] must greater equal 1");
        }
        if (maxAllowedOffset < 1L) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.params.pagination.max-allowed-offset: " + maxAllowedOffset + "] must greater equal 1");
        }
        extractor.setMaxAllowedSize(maxAllowedSize);
        extractor.setMaxAllowedOffset(maxAllowedOffset);
        extractor.setDefaultSize(defaultSize);
        extractor.setSizeName(conf.getSize());
        extractor.setStart(conf.getStart());
        return extractor;
    }

    @Bean
    @ConditionalOnMissingBean(value={Dialect.class})
    public Dialect dialect(BeanSearcherSql config, ObjectProvider<List<DataSourceDialect>> dialects) {
        BeanSearcherSql.Dialect defaultType = config.getDialect();
        if (defaultType == null) {
            throw new IllegalConfigException("Invalid config: [bean-searcher.sql.dialect] can not be null.");
        }
        Dialect defaultDialect = this.createDialect(defaultType, "dialect");
        if (config.isDialectDynamic()) {
            DynamicDialect dynamicDialect = new DynamicDialect();
            dynamicDialect.setDefaultDialect(defaultDialect);
            BeanSearcherAutoConfiguration.ifAvailable(dialects, list -> list.forEach(item -> dynamicDialect.put(item.getDataSource(), item.getDialect())));
            config.getDialects().forEach((ds, dType) -> dynamicDialect.put(ds, this.createDialect((BeanSearcherSql.Dialect)((Object)dType), "dialects." + ds)));
            return dynamicDialect;
        }
        return defaultDialect;
    }

    private Dialect createDialect(BeanSearcherSql.Dialect dialectType, String propKey) {
        switch (dialectType) {
            case MySQL: {
                return new MySqlDialect();
            }
            case Oracle: {
                return new OracleDialect();
            }
            case PostgreSQL: 
            case PgSQL: {
                return new PostgreSqlDialect();
            }
            case SqlServer: {
                return new SqlServerDialect();
            }
        }
        throw new IllegalConfigException("Invalid config: [bean-searcher.sql." + propKey + ": " + (Object)((Object)dialectType) + "]. Please see https://bs.zhxu.cn/guide/latest/advance.html#sql-%E6%96%B9%E8%A8%80%EF%BC%88dialect%EF%BC%89 for help.");
    }

    @Bean
    @ConditionalOnProperty(name={"bean-searcher.sql.dialect-dynamic"}, havingValue="true")
    @ConditionalOnMissingBean(value={DynamicDialectSupport.class})
    public DynamicDialectSupport dynamicDialectSupport() {
        return new DynamicDialectSupport();
    }

    @Bean
    @ConditionalOnMissingBean(value={FieldOpPool.class})
    public FieldOpPool fieldOpPool(Dialect dialect, ObjectProvider<List<FieldOp>> fieldOps) {
        FieldOpPool pool = FieldOpPool.DEFAULT;
        BeanSearcherAutoConfiguration.ifAvailable(fieldOps, ops -> ops.forEach(arg_0 -> ((FieldOpPool)pool).addFieldOp(arg_0)));
        pool.setDialect(dialect);
        return pool;
    }

    @Bean
    @ConditionalOnMissingBean(value={GroupResolver.class})
    public GroupResolver groupResolver(BeanSearcherParams config, ObjectProvider<ExprParser.Factory> parserFactory) {
        DefaultGroupResolver groupResolver = new DefaultGroupResolver();
        BeanSearcherParams.Group conf = config.getGroup();
        groupResolver.setEnabled(conf.isEnable());
        groupResolver.setCache((Cache)new LRUCache(conf.getCacheSize()));
        groupResolver.setMaxExprLength(conf.getMaxExprLength());
        BeanSearcherAutoConfiguration.ifAvailable(parserFactory, arg_0 -> ((DefaultGroupResolver)groupResolver).setParserFactory(arg_0));
        return groupResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={ParamResolver.class})
    public ParamResolver paramResolver(PageExtractor pageExtractor, FieldOpPool fieldOpPool, List<ParamFilter> paramFilters, List<FieldConvertor.ParamConvertor> convertors, GroupResolver groupResolver, BeanSearcherParams config) {
        DefaultParamResolver paramResolver = new DefaultParamResolver(convertors, paramFilters);
        paramResolver.setPageExtractor(pageExtractor);
        paramResolver.setFieldOpPool(fieldOpPool);
        paramResolver.setGroupResolver(groupResolver);
        BeanSearcherParams.Group group = config.getGroup();
        ((ParamResolver.Configuration)((ParamResolver.Configuration)((ParamResolver.Configuration)((ParamResolver.Configuration)((ParamResolver.Configuration)((ParamResolver.Configuration)((ParamResolver.Configuration)((ParamResolver.Configuration)((ParamResolver.Configuration)paramResolver.getConfiguration().gexprMerge(group.isMergeable()).groupSeparator(group.getSeparator())).gexpr(group.getExprName())).selectExclude(config.getSelectExclude())).onlySelect(config.getOnlySelect())).separator(config.getSeparator())).op(config.getOperatorKey())).ic(config.getIgnoreCaseKey())).orderBy(config.getOrderBy())).order(config.getOrder())).sort(config.getSort());
        return paramResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={SqlResolver.class})
    public SqlResolver sqlResolver(Dialect dialect, ObjectProvider<GroupPair.Resolver> groupPairResolver, ObjectProvider<JoinParaSerializer> joinParaSerializer) {
        DefaultSqlResolver resolver = new DefaultSqlResolver(dialect);
        BeanSearcherAutoConfiguration.ifAvailable(groupPairResolver, arg_0 -> ((DefaultSqlResolver)resolver).setGroupPairResolver(arg_0));
        BeanSearcherAutoConfiguration.ifAvailable(joinParaSerializer, arg_0 -> ((DefaultSqlResolver)resolver).setJoinParaSerializer(arg_0));
        return resolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={SqlExecutor.class})
    public SqlExecutor sqlExecutor(ObjectProvider<DataSource> dataSource, ObjectProvider<List<NamedDataSource>> namedDataSources, ObjectProvider<SqlExecutor.SlowListener> slowListener, BeanSearcherSql config) {
        SpringSqlExecutor executor = new SpringSqlExecutor((DataSource)dataSource.getIfAvailable());
        BeanSearcherAutoConfiguration.ifAvailable(namedDataSources, ndsList -> {
            for (NamedDataSource nds : ndsList) {
                executor.setDataSource(nds.getName(), nds.getDataSource());
            }
        });
        BeanSearcherAutoConfiguration.ifAvailable(slowListener, arg_0 -> ((SpringSqlExecutor)executor).setSlowListener(arg_0));
        executor.setSlowSqlThreshold(config.getSlowSqlThreshold());
        return executor;
    }

    @Bean
    @ConditionalOnMissingBean(value={BeanReflector.class})
    public BeanReflector beanReflector(ObjectProvider<List<FieldConvertor.BFieldConvertor>> convertorsProvider) {
        List convertors = (List)convertorsProvider.getIfAvailable();
        if (convertors != null) {
            return new DefaultBeanReflector(convertors);
        }
        return new DefaultBeanReflector();
    }

    @Bean
    @ConditionalOnMissingBean(value={DbMapping.class})
    public DbMapping dbMapping(BeanSearcherSql config) {
        DefaultDbMapping mapping = new DefaultDbMapping();
        BeanSearcherSql.DefaultMapping conf = config.getDefaultMapping();
        mapping.setTablePrefix(conf.getTablePrefix());
        mapping.setUpperCase(conf.isUpperCase());
        mapping.setUnderlineCase(conf.isUnderlineCase());
        mapping.setRedundantSuffixes(conf.getRedundantSuffixes());
        mapping.setIgnoreFields(conf.getIgnoreFields());
        mapping.setDefaultInheritType(conf.getInheritType());
        mapping.setDefaultSortType(conf.getSortType());
        mapping.setAroundChar(conf.getAroundChar());
        return mapping;
    }

    @Bean
    @ConditionalOnMissingBean(value={MetaResolver.class})
    public MetaResolver metaResolver(DbMapping dbMapping, ObjectProvider<SnippetResolver> snippetResolver) {
        DefaultMetaResolver metaResolver = new DefaultMetaResolver(dbMapping);
        BeanSearcherAutoConfiguration.ifAvailable(snippetResolver, arg_0 -> ((DefaultMetaResolver)metaResolver).setSnippetResolver(arg_0));
        return metaResolver;
    }

    @Bean
    @ConditionalOnMissingBean(value={BeanSearcher.class})
    @ConditionalOnProperty(name={"bean-searcher.use-bean-searcher"}, havingValue="true", matchIfMissing=true)
    public BeanSearcher beanSearcher(MetaResolver metaResolver, ParamResolver paramResolver, SqlResolver sqlResolver, SqlExecutor sqlExecutor, BeanReflector beanReflector, ObjectProvider<List<SqlInterceptor>> interceptors, ObjectProvider<List<ResultFilter>> processors, BeanSearcherParams config) {
        DefaultBeanSearcher searcher = new DefaultBeanSearcher();
        searcher.setMetaResolver(metaResolver);
        searcher.setParamResolver(paramResolver);
        searcher.setSqlResolver(sqlResolver);
        searcher.setSqlExecutor(sqlExecutor);
        searcher.setBeanReflector(beanReflector);
        searcher.setFailOnParamError(config.isFailOnError());
        BeanSearcherAutoConfiguration.ifAvailable(interceptors, arg_0 -> ((DefaultBeanSearcher)searcher).setInterceptors(arg_0));
        BeanSearcherAutoConfiguration.ifAvailable(processors, arg_0 -> ((DefaultBeanSearcher)searcher).setResultFilters(arg_0));
        return searcher;
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={MapSearcher.class})
    @ConditionalOnProperty(name={"bean-searcher.use-map-searcher"}, havingValue="true", matchIfMissing=true)
    public MapSearcher mapSearcher(MetaResolver metaResolver, ParamResolver paramResolver, SqlResolver sqlResolver, SqlExecutor sqlExecutor, ObjectProvider<List<FieldConvertor.MFieldConvertor>> convertors, ObjectProvider<List<SqlInterceptor>> interceptors, ObjectProvider<List<ResultFilter>> resultFilters, BeanSearcherParams config) {
        DefaultMapSearcher searcher = new DefaultMapSearcher();
        searcher.setMetaResolver(metaResolver);
        searcher.setParamResolver(paramResolver);
        searcher.setSqlResolver(sqlResolver);
        searcher.setSqlExecutor(sqlExecutor);
        searcher.setFailOnParamError(config.isFailOnError());
        List list = (List)convertors.getIfAvailable();
        if (list != null) {
            ArrayList newList = new ArrayList(list);
            newList.sort((o1, o2) -> {
                if (o1 instanceof DateFormatFieldConvertor) {
                    return -1;
                }
                if (o2 instanceof DateFormatFieldConvertor) {
                    return 1;
                }
                return 0;
            });
            searcher.setConvertors(newList);
        }
        BeanSearcherAutoConfiguration.ifAvailable(interceptors, arg_0 -> ((DefaultMapSearcher)searcher).setInterceptors(arg_0));
        BeanSearcherAutoConfiguration.ifAvailable(resultFilters, arg_0 -> ((DefaultMapSearcher)searcher).setResultFilters(arg_0));
        return searcher;
    }

    static <T> void ifAvailable(ObjectProvider<T> provider, Consumer<T> consumer) {
        Object dependency = provider.getIfAvailable();
        if (dependency != null) {
            consumer.accept(dependency);
        }
    }
}

