/*
 * Decompiled with CFR 0.152.
 */
package cn.zhxu.data.jackson;

import cn.zhxu.data.Array;
import cn.zhxu.data.DataConvertor;
import cn.zhxu.data.Mapper;
import cn.zhxu.data.jackson.JacksonArray;
import cn.zhxu.data.jackson.JacksonList;
import cn.zhxu.data.jackson.JacksonMap;
import cn.zhxu.data.jackson.JacksonMapper;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;

public class JacksonDataConvertor
implements DataConvertor {
    private ObjectMapper objectMapper;

    public JacksonDataConvertor() {
        this(new ObjectMapper());
    }

    public JacksonDataConvertor(ObjectMapper objectMapper) {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.objectMapper = objectMapper;
    }

    public Mapper toMapper(InputStream in, Charset charset) {
        try {
            return this.toMapper(this.objectMapper.readTree((Reader)new InputStreamReader(in, charset)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public Mapper toMapper(String in) {
        try {
            return this.toMapper(this.objectMapper.readTree(in));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    private Mapper toMapper(JsonNode json) {
        if (json.isObject()) {
            return new JacksonMapper(this.objectMapper, (ObjectNode)json);
        }
        if (json.isNull() || json.isMissingNode()) {
            return null;
        }
        throw new IllegalArgumentException("\u4e0d\u662f \u4e00\u4e2a json \u5bf9\u8c61\uff1a" + json);
    }

    public Array toArray(InputStream in, Charset charset) {
        try {
            return this.toArray(this.objectMapper.readTree((Reader)new InputStreamReader(in, charset)));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public Array toArray(String in) {
        try {
            return this.toArray(this.objectMapper.readTree(in));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    protected Array toArray(JsonNode json) {
        if (json.isArray()) {
            return new JacksonArray(this.objectMapper, (ArrayNode)json);
        }
        if (json.isNull() || json.isMissingNode()) {
            return null;
        }
        throw new IllegalStateException("\u4e0d\u662f\u6570\u7ec4\uff1a" + json);
    }

    public byte[] serialize(Object object, Charset charset, boolean pretty) {
        return this.serialize(object, pretty).getBytes(charset);
    }

    public String serialize(Object object, boolean pretty) {
        if (object instanceof Mapper) {
            object = ((Mapper)object).toMap();
        }
        if (object instanceof Array) {
            object = ((Array)object).toList();
        }
        try {
            if (pretty) {
                return this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object);
            }
            return this.objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Java Bean [" + object + "] Jackson \u5e8f\u5217\u5316\u5f02\u5e38", e);
        }
    }

    protected <T> TypeReference<T> toTypeRef(final Type type) {
        return new TypeReference<T>(){

            public Type getType() {
                return type;
            }
        };
    }

    public <T> T toBean(Type type, InputStream in, Charset charset) {
        try {
            return (T)this.objectMapper.readValue((Reader)new InputStreamReader(in, charset), this.toTypeRef(type));
        }
        catch (IOException e) {
            throw new IllegalStateException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public <T> T toBean(Type type, String in) {
        try {
            return (T)this.objectMapper.readValue(in, this.toTypeRef(type));
        }
        catch (IOException e) {
            throw new IllegalStateException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public <T> List<T> toList(Class<T> type, InputStream in, Charset charset) {
        try {
            return (List)this.objectMapper.readValue((Reader)new InputStreamReader(in, charset), (JavaType)this.listType(type));
        }
        catch (IOException e) {
            throw new IllegalStateException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    public <T> List<T> toList(Class<T> type, String in) {
        try {
            return (List)this.objectMapper.readValue(in, (JavaType)this.listType(type));
        }
        catch (IOException e) {
            throw new IllegalStateException("Jackson \u89e3\u6790\u5f02\u5e38", e);
        }
    }

    private <T> CollectionType listType(Class<T> type) {
        return this.objectMapper.getTypeFactory().constructCollectionType(ArrayList.class, type);
    }

    public static Object toPlainObject(JsonNode value) {
        if (value != null) {
            if (value.isObject()) {
                return new JacksonMap((ObjectNode)value);
            }
            if (value.isArray()) {
                return new JacksonList((ArrayNode)value);
            }
            if (value.isBoolean()) {
                return value.asBoolean();
            }
            if (value.isTextual()) {
                return value.asText();
            }
            if (value.isInt()) {
                return value.asInt();
            }
            if (value.isLong()) {
                return value.asLong();
            }
            if (value.isFloat()) {
                return Float.valueOf(value.floatValue());
            }
            if (value.isDouble()) {
                return value.asDouble();
            }
            if (value.isBigDecimal()) {
                return value.decimalValue();
            }
            if (value.isBigInteger()) {
                return value.bigIntegerValue();
            }
        }
        return null;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }
}

