/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.service.handler;

import cn.hutool.core.collection.CollUtil;
import com.aizuda.snailjob.common.core.exception.AbstractError;
import com.aizuda.snailjob.common.core.exception.BaseSnailJobException;
import com.aizuda.snailjob.common.core.exception.SnailJobAuthenticationException;
import com.aizuda.snailjob.common.core.model.Result;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.ConstraintViolationException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeMismatchException;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpMediaTypeNotSupportedException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.MissingServletRequestParameterException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.annotation.HandlerMethodValidationException;

@ControllerAdvice(basePackages={"com.aizuda.snailjob.server"})
@ResponseBody
public class RestExceptionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestExceptionHandler.class);
    public static final String DELIMITER_TO = "@";
    public static final String DELIMITER_COLON = ":";

    @ExceptionHandler(value={Exception.class})
    public Result onException(Exception ex) {
        log.error("Exception class onException,", (Throwable)ex);
        return new Result(0, "System exception");
    }

    @ExceptionHandler(value={BaseSnailJobException.class})
    public Result onBusinessException(BaseSnailJobException ex) {
        log.error("Exception class businessException", (Throwable)ex);
        if (ex instanceof SnailJobAuthenticationException) {
            SnailJobAuthenticationException authenticationException = (SnailJobAuthenticationException)ex;
            return new Result(authenticationException.getErrorCode().intValue(), ex.getMessage());
        }
        return new Result(0, ex.getMessage());
    }

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    public Result requestNotReadable(HttpMessageNotReadableException ex) {
        log.error("Exception class HttpMessageNotReadableException,", (Throwable)ex);
        return new Result(0, AbstractError.PARAM_INCORRECT.toString());
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public Result onConstraintViolationException(ConstraintViolationException e) {
        Set constraintViolations = e.getConstraintViolations();
        if (CollUtil.isNotEmpty((Collection)constraintViolations)) {
            String errorMessage = StreamUtils.join((Collection)constraintViolations, ConstraintViolation::getMessage, (CharSequence)";");
            return new Result(0, errorMessage);
        }
        return new Result(0, e.getMessage());
    }

    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    public Result onMethodArgumentNotValidException(MethodArgumentNotValidException e) {
        BindingResult result = e.getBindingResult();
        if (result.hasErrors()) {
            StringBuilder sb = new StringBuilder();
            List errors = result.getFieldErrors();
            if (CollUtil.isNotEmpty((Collection)errors)) {
                FieldError error = (FieldError)errors.get(0);
                String rejectedValue = Objects.toString(error.getRejectedValue(), "");
                String defMsg = error.getDefaultMessage();
                if (rejectedValue.contains(DELIMITER_TO)) {
                    sb.append(defMsg);
                } else if (DELIMITER_COLON.contains(defMsg)) {
                    sb.append(error.getField()).append(" ").append(defMsg);
                } else {
                    sb.append(error.getField()).append(" ").append(defMsg).append(DELIMITER_COLON).append(rejectedValue);
                }
            } else {
                String msg = ((ObjectError)result.getAllErrors().get(0)).getDefaultMessage();
                sb.append(msg);
            }
            return new Result(0, sb.toString());
        }
        return null;
    }

    @ExceptionHandler(value={HandlerMethodValidationException.class})
    public Result onHandlerMethodValidationException(HandlerMethodValidationException e) {
        Object[] detailMessageArguments = e.getDetailMessageArguments();
        if (detailMessageArguments != null && detailMessageArguments.length > 0) {
            return new Result(0, detailMessageArguments[0].toString());
        }
        return new Result((Object)"Parameter validation failed");
    }

    @ExceptionHandler(value={TypeMismatchException.class})
    public Result requestTypeMismatch(TypeMismatchException ex) {
        log.error("Exception class TypeMismatchException {},", (Object)ex.getMessage());
        return new Result(0, AbstractError.PARAM_INCORRECT.toString());
    }

    @ExceptionHandler(value={MissingServletRequestParameterException.class})
    public Result requestMissingServletRequest(MissingServletRequestParameterException ex) {
        log.error("Exception class MissingServletRequestParameterException {},", (Object)ex.getMessage());
        return new Result(0, AbstractError.PARAM_INCORRECT.toString());
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    public Result request405() {
        log.error(" Exception class HttpRequestMethodNotSupportedException");
        return new Result(0, AbstractError.PARAM_INCORRECT.toString());
    }

    @ExceptionHandler(value={HttpMediaTypeNotSupportedException.class})
    public Result request415(HttpMediaTypeNotSupportedException ex) {
        log.error("Exception class HttpMediaTypeNotSupportedException {}", (Object)ex.getMessage());
        return new Result(0, AbstractError.PARAM_INCORRECT.toString());
    }
}

