/*
 * Decompiled with CFR 0.152.
 */
package com.ql.util.express.parse;

import com.ql.util.express.match.INodeType;
import com.ql.util.express.match.QLPattern;
import com.ql.util.express.match.QLPatternNode;
import com.ql.util.express.parse.NodeTypeKind;
import com.ql.util.express.parse.NodeTypeManager;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class NodeType
implements INodeType {
    private static final Pattern PATTERN = Pattern.compile("([,:])\\s*(([A-Z]|-|_)*)\\s*=");
    private final NodeTypeManager manager;
    private final String name;
    private final String defineStr;
    private NodeTypeKind kind;
    private NodeType realNodeType;
    private String instructionFactory;
    private QLPatternNode qlPatternNode;

    protected NodeType(NodeTypeManager nodeTypeManager, String name, String defineStr) {
        this.manager = nodeTypeManager;
        this.defineStr = defineStr;
        this.name = name;
    }

    public static String[][] splitProperties(String str) {
        Matcher matcher = PATTERN.matcher(str);
        ArrayList<String[]> list = new ArrayList<String[]>();
        int endIndex = 0;
        while (matcher.find()) {
            if (!list.isEmpty()) {
                ((String[])list.get((int)(list.size() - 1)))[1] = str.substring(endIndex, matcher.start()).trim();
            }
            list.add(new String[2]);
            ((String[])list.get((int)(list.size() - 1)))[0] = str.substring(matcher.start() + 1, matcher.end() - 1).trim();
            endIndex = matcher.end();
        }
        if (!list.isEmpty()) {
            ((String[])list.get((int)(list.size() - 1)))[1] = str.substring(endIndex).trim();
        }
        return (String[][])list.toArray((T[])new String[0][2]);
    }

    public void initial() {
        try {
            String[][] properties;
            int index = this.defineStr.indexOf(":", 1);
            for (String[] tempList : properties = NodeType.splitProperties(this.defineStr.substring(index))) {
                if ("type".equalsIgnoreCase(tempList[0])) {
                    this.setKind(NodeTypeKind.valueOf(tempList[1]));
                    continue;
                }
                if ("real".equalsIgnoreCase(tempList[0])) {
                    this.realNodeType = this.manager.findNodeType(tempList[1]);
                    continue;
                }
                if ("factory".equalsIgnoreCase(tempList[0])) {
                    this.instructionFactory = tempList[1];
                    continue;
                }
                if ("define".equalsIgnoreCase(tempList[0])) {
                    this.qlPatternNode = QLPattern.createPattern(this.manager, this.name, tempList[1]);
                    continue;
                }
                throw new RuntimeException("\u4e0d\u80fd\u8bc6\u522b\"" + this.name + "\"\u7684\u5c5e\u6027\u7c7b\u578b\uff1a" + tempList[0] + " \u5b9a\u4e49\uff1a" + this.defineStr);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("\u8282\u70b9\u7c7b\u578b\"" + this.name + "\"\u521d\u59cb\u5316\u5931\u8d25,\u5b9a\u4e49\uff1a" + this.defineStr, e);
        }
    }

    public boolean isEqualsOrChild(String parent) {
        return this.manager.findNodeType(parent).isContainerChild(this);
    }

    public boolean isContainerChild(NodeType child) {
        if (this.equals(child)) {
            return true;
        }
        if (this.qlPatternNode == null) {
            return false;
        }
        if (this.qlPatternNode.isDetailMode()) {
            return ((NodeType)this.qlPatternNode.getNodeType()).isContainerChild(child);
        }
        if (this.qlPatternNode.isAndMode() && !this.qlPatternNode.getChildren().isEmpty()) {
            return false;
        }
        for (QLPatternNode node : this.qlPatternNode.getChildren()) {
            if (node.getNodeType() == null || !((NodeType)node.getNodeType()).isContainerChild(child)) continue;
            return true;
        }
        return false;
    }

    public void addChild(NodeType child) throws Exception {
        String str = child.name;
        if (this.qlPatternNode != null) {
            str = this.qlPatternNode + "|" + str;
        }
        this.qlPatternNode = QLPattern.createPattern(this.manager, this.name, str);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.name).append(":TYPE=").append((Object)this.kind);
        if (this.instructionFactory != null) {
            result.append(",FACTORY=").append(this.instructionFactory);
        }
        if (this.qlPatternNode != null) {
            result.append(",DEFINE=").append(this.qlPatternNode);
        }
        return result.toString();
    }

    public NodeType getRealNodeType() {
        return this.realNodeType;
    }

    public NodeTypeKind getKind() {
        return this.kind;
    }

    public String getInstructionFactory() {
        return this.instructionFactory;
    }

    public void setInstructionFactory(String instructionFactory) {
        this.instructionFactory = instructionFactory;
    }

    @Override
    public NodeTypeManager getManager() {
        return this.manager;
    }

    public String getDefineStr() {
        return this.defineStr;
    }

    public void setKind(NodeTypeKind kind) {
        this.kind = kind;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public QLPatternNode getPatternNode() {
        return this.qlPatternNode;
    }
}

