/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.adapter.reactor;

import com.alibaba.csp.sentinel.AsyncEntry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.reactor.ContextConfig;
import com.alibaba.csp.sentinel.adapter.reactor.EntryConfig;
import com.alibaba.csp.sentinel.adapter.reactor.InheritableBaseSubscriber;
import com.alibaba.csp.sentinel.context.Context;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.AssertUtil;
import com.alibaba.csp.sentinel.util.function.Supplier;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;

public class SentinelReactorSubscriber<T>
extends InheritableBaseSubscriber<T> {
    private final EntryConfig entryConfig;
    private final CoreSubscriber<? super T> actual;
    private final boolean unary;
    private volatile AsyncEntry currentEntry;
    private final AtomicBoolean entryExited = new AtomicBoolean(false);

    public SentinelReactorSubscriber(EntryConfig entryConfig, CoreSubscriber<? super T> actual, boolean unary) {
        this.checkEntryConfig(entryConfig);
        this.entryConfig = entryConfig;
        this.actual = actual;
        this.unary = unary;
    }

    private void checkEntryConfig(EntryConfig config) {
        AssertUtil.notNull((Object)config, (String)"entryConfig cannot be null");
    }

    public reactor.util.context.Context currentContext() {
        if (this.currentEntry == null || this.entryExited.get()) {
            return this.actual.currentContext();
        }
        Context sentinelContext = this.currentEntry.getAsyncContext();
        if (sentinelContext == null) {
            return this.actual.currentContext();
        }
        return this.actual.currentContext().put((Object)"_sentinel_context", (Object)this.currentEntry.getAsyncContext());
    }

    private void doWithContextOrCurrent(Supplier<Optional<Context>> contextSupplier, Runnable f) {
        Optional contextOpt = (Optional)contextSupplier.get();
        if (!contextOpt.isPresent()) {
            f.run();
        } else {
            ContextUtil.runOnContext((Context)((Context)contextOpt.get()), (Runnable)f);
        }
    }

    private void entryWhenSubscribed() {
        ContextConfig sentinelContextConfig = this.entryConfig.getContextConfig();
        if (sentinelContextConfig != null) {
            ContextUtil.enter((String)sentinelContextConfig.getContextName(), (String)sentinelContextConfig.getOrigin());
        }
        try {
            AsyncEntry entry;
            this.currentEntry = entry = SphU.asyncEntry((String)this.entryConfig.getResourceName(), (int)this.entryConfig.getResourceType(), (EntryType)this.entryConfig.getEntryType(), (int)this.entryConfig.getAcquireCount(), (Object[])this.entryConfig.getArgs());
            this.actual.onSubscribe((Subscription)this);
        }
        catch (BlockException ex) {
            this.entryExited.set(true);
            this.cancel();
            this.actual.onSubscribe((Subscription)this);
            this.actual.onError((Throwable)ex);
        }
        finally {
            if (sentinelContextConfig != null) {
                ContextUtil.exit();
            }
        }
    }

    @Override
    protected void hookOnSubscribe(Subscription subscription) {
        this.doWithContextOrCurrent((Supplier<Optional<Context>>)((Supplier)() -> this.currentContext().getOrEmpty((Object)"_sentinel_context")), this::entryWhenSubscribed);
    }

    @Override
    protected void hookOnNext(T value) {
        if (this.isDisposed()) {
            this.tryCompleteEntry();
            return;
        }
        this.doWithContextOrCurrent((Supplier<Optional<Context>>)((Supplier)() -> Optional.ofNullable(this.currentEntry).map(AsyncEntry::getAsyncContext)), () -> this.actual.onNext(value));
        if (this.unary) {
            this.tryCompleteEntry();
        }
    }

    @Override
    protected void hookOnComplete() {
        this.tryCompleteEntry();
        this.actual.onComplete();
    }

    @Override
    protected boolean shouldCallErrorDropHook() {
        return !this.entryExited.get();
    }

    @Override
    protected void hookOnError(Throwable t) {
        if (this.currentEntry != null && this.currentEntry.getAsyncContext() != null) {
            Tracer.traceContext((Throwable)t, (int)1, (Context)this.currentEntry.getAsyncContext());
        }
        this.tryCompleteEntry();
        this.actual.onError(t);
    }

    @Override
    protected void hookOnCancel() {
    }

    private boolean tryCompleteEntry() {
        if (this.currentEntry != null && this.entryExited.compareAndSet(false, true)) {
            this.currentEntry.exit(1, this.entryConfig.getArgs());
            return true;
        }
        return false;
    }
}

