/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.remoting.transport;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.remoting.Channel;
import com.alibaba.dubbo.remoting.ChannelHandler;
import com.alibaba.dubbo.remoting.Endpoint;
import com.alibaba.dubbo.remoting.RemotingException;
import com.alibaba.dubbo.remoting.transport.ChannelHandlerDelegate;

public abstract class AbstractPeer
implements Endpoint,
ChannelHandler {
    private final ChannelHandler handler;
    private volatile URL url;
    private volatile boolean closed;

    public AbstractPeer(URL url, ChannelHandler handler) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        if (handler == null) {
            throw new IllegalArgumentException("handler == null");
        }
        this.url = url;
        this.handler = handler;
    }

    public void send(Object message) throws RemotingException {
        this.send(message, this.url.getParameter("sent", false));
    }

    public void close() {
        this.closed = true;
    }

    public void close(int timeout) {
        this.close();
    }

    public URL getUrl() {
        return this.url;
    }

    protected void setUrl(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.url = url;
    }

    public ChannelHandler getChannelHandler() {
        if (this.handler instanceof ChannelHandlerDelegate) {
            return ((ChannelHandlerDelegate)this.handler).getHandler();
        }
        return this.handler;
    }

    @Deprecated
    public ChannelHandler getHandler() {
        return this.getDelegateHandler();
    }

    public ChannelHandler getDelegateHandler() {
        return this.handler;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void connected(Channel ch) throws RemotingException {
        if (this.closed) {
            return;
        }
        this.handler.connected(ch);
    }

    public void disconnected(Channel ch) throws RemotingException {
        this.handler.disconnected(ch);
    }

    public void sent(Channel ch, Object msg) throws RemotingException {
        if (this.closed) {
            return;
        }
        this.handler.sent(ch, msg);
    }

    public void received(Channel ch, Object msg) throws RemotingException {
        if (this.closed) {
            return;
        }
        this.handler.received(ch, msg);
    }

    public void caught(Channel ch, Throwable ex) throws RemotingException {
        this.handler.caught(ch, ex);
    }
}

