/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.dubbo.rpc.filter;

import com.alibaba.dubbo.common.URL;
import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Activate(group={"consumer"}, value={"actives"})
public class ActiveLimitFilter
implements Filter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        RpcStatus rpcStatus;
        Result result;
        URL url = invoker.getUrl();
        String methodName = invocation.getMethodName();
        int max = invoker.getUrl().getMethodParameter(methodName, "actives", 0);
        RpcStatus count = RpcStatus.getStatus(invoker.getUrl(), invocation.getMethodName());
        if (max > 0) {
            long timeout = invoker.getUrl().getMethodParameter(invocation.getMethodName(), "timeout", 0);
            long start = System.currentTimeMillis();
            long remain = timeout;
            int active = count.getActive();
            if (active >= max) {
                RpcStatus rpcStatus2 = count;
                synchronized (rpcStatus2) {
                    while ((active = count.getActive()) >= max) {
                        long elapsed;
                        try {
                            count.wait(remain);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                        }
                        if ((remain = timeout - (elapsed = System.currentTimeMillis() - start)) > 0L) continue;
                        throw new RpcException("Waiting concurrent invoke timeout in client-side for service:  " + invoker.getInterface().getName() + ", method: " + invocation.getMethodName() + ", elapsed: " + elapsed + ", timeout: " + timeout + ". concurrent invokes: " + active + ". max concurrent invoke limit: " + max);
                    }
                }
            }
        }
        try {
            long begin = System.currentTimeMillis();
            RpcStatus.beginCount(url, methodName);
            try {
                Result result2 = invoker.invoke(invocation);
                RpcStatus.endCount(url, methodName, System.currentTimeMillis() - begin, true);
                result = result2;
            }
            catch (RuntimeException t) {
                RpcStatus.endCount(url, methodName, System.currentTimeMillis() - begin, false);
                throw t;
            }
            Object var19_17 = null;
            if (max <= 0) return result;
            rpcStatus = count;
        }
        catch (Throwable throwable) {
            Object var19_18 = null;
            if (max <= 0) throw throwable;
            RpcStatus rpcStatus3 = count;
            synchronized (rpcStatus3) {
                count.notify();
                throw throwable;
            }
        }
        synchronized (rpcStatus) {
            count.notify();
            return result;
        }
    }
}

