/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting;

import com.alipay.remoting.AbstractLifeCycle;
import com.alipay.remoting.LifeCycleException;
import com.alipay.remoting.RemotingServer;
import com.alipay.remoting.config.BoltOption;
import com.alipay.remoting.config.BoltOptions;
import com.alipay.remoting.config.ConfigManager;
import com.alipay.remoting.config.Configurable;
import com.alipay.remoting.config.ConfigurableInstance;
import com.alipay.remoting.config.configs.ConfigContainer;
import com.alipay.remoting.config.configs.ConfigItem;
import com.alipay.remoting.config.configs.ConfigType;
import com.alipay.remoting.config.configs.DefaultConfigContainer;
import com.alipay.remoting.config.switches.GlobalSwitch;
import com.alipay.remoting.log.BoltLoggerFactory;
import java.net.InetSocketAddress;
import org.slf4j.Logger;

public abstract class AbstractRemotingServer
extends AbstractLifeCycle
implements RemotingServer,
ConfigurableInstance {
    private static final Logger logger = BoltLoggerFactory.getLogger("CommonDefault");
    private String ip;
    private int port;
    private final BoltOptions options;
    private final ConfigType configType;
    private final GlobalSwitch globalSwitch;
    private final ConfigContainer configContainer;

    public AbstractRemotingServer(int port) {
        this(new InetSocketAddress(port).getAddress().getHostAddress(), port);
    }

    public AbstractRemotingServer(String ip, int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException(String.format("Illegal port value: %d, which should between 0 and 65535.", port));
        }
        this.ip = ip;
        this.port = port;
        this.options = new BoltOptions();
        this.configType = ConfigType.SERVER_SIDE;
        this.globalSwitch = new GlobalSwitch();
        this.configContainer = new DefaultConfigContainer();
    }

    @Override
    @Deprecated
    public void init() {
    }

    @Override
    @Deprecated
    public boolean start() {
        this.startup();
        return true;
    }

    @Override
    @Deprecated
    public boolean stop() {
        this.shutdown();
        return true;
    }

    @Override
    public void startup() throws LifeCycleException {
        super.startup();
        try {
            this.doInit();
            logger.warn("Prepare to start server on port {} ", (Object)this.port);
            if (!this.doStart()) {
                logger.warn("Failed starting server on port {}", (Object)this.port);
                throw new LifeCycleException("Failed starting server on port: " + this.port);
            }
            logger.warn("Server started on port {}", (Object)this.port);
        }
        catch (Throwable t) {
            this.shutdown();
            throw new IllegalStateException("ERROR: Failed to start the Server!", t);
        }
    }

    @Override
    public void shutdown() throws LifeCycleException {
        super.shutdown();
        if (!this.doStop()) {
            throw new LifeCycleException("doStop fail");
        }
    }

    @Override
    public String ip() {
        return this.ip;
    }

    @Override
    public int port() {
        return this.port;
    }

    protected void setLocalBindingPort(int port) {
        if (this.port() == 0) {
            this.port = port;
        }
    }

    protected abstract void doInit();

    protected abstract boolean doStart() throws InterruptedException;

    protected abstract boolean doStop();

    @Override
    public <T> T option(BoltOption<T> option) {
        return this.options.option(option);
    }

    @Override
    public <T> Configurable option(BoltOption<T> option, T value) {
        this.options.option(option, value);
        return this;
    }

    @Override
    public ConfigContainer conf() {
        return this.configContainer;
    }

    @Override
    public GlobalSwitch switches() {
        return this.globalSwitch;
    }

    @Override
    public void initWriteBufferWaterMark(int low, int high) {
        this.configContainer.set(this.configType, ConfigItem.NETTY_BUFFER_LOW_WATER_MARK, low);
        this.configContainer.set(this.configType, ConfigItem.NETTY_BUFFER_HIGH_WATER_MARK, high);
    }

    @Override
    public int netty_buffer_low_watermark() {
        Object config = this.configContainer.get(this.configType, ConfigItem.NETTY_BUFFER_LOW_WATER_MARK);
        if (config != null) {
            return (Integer)config;
        }
        return ConfigManager.netty_buffer_low_watermark();
    }

    @Override
    public int netty_buffer_high_watermark() {
        Object config = this.configContainer.get(this.configType, ConfigItem.NETTY_BUFFER_HIGH_WATER_MARK);
        if (config != null) {
            return (Integer)config;
        }
        return ConfigManager.netty_buffer_high_watermark();
    }
}

