/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.remoting.rpc;

import com.alipay.remoting.AbstractRemotingServer;
import com.alipay.remoting.CommandCode;
import com.alipay.remoting.Connection;
import com.alipay.remoting.ConnectionEventHandler;
import com.alipay.remoting.ConnectionEventListener;
import com.alipay.remoting.ConnectionEventProcessor;
import com.alipay.remoting.ConnectionEventType;
import com.alipay.remoting.DefaultConnectionManager;
import com.alipay.remoting.DefaultServerConnectionManager;
import com.alipay.remoting.InvokeCallback;
import com.alipay.remoting.InvokeContext;
import com.alipay.remoting.NamedThreadFactory;
import com.alipay.remoting.ProtocolCode;
import com.alipay.remoting.ProtocolManager;
import com.alipay.remoting.RandomSelectStrategy;
import com.alipay.remoting.RemotingAddressParser;
import com.alipay.remoting.RemotingProcessor;
import com.alipay.remoting.ServerIdleHandler;
import com.alipay.remoting.Url;
import com.alipay.remoting.codec.Codec;
import com.alipay.remoting.config.BoltGenericOption;
import com.alipay.remoting.config.ConfigManager;
import com.alipay.remoting.exception.RemotingException;
import com.alipay.remoting.log.BoltLoggerFactory;
import com.alipay.remoting.rpc.RpcAddressParser;
import com.alipay.remoting.rpc.RpcCodec;
import com.alipay.remoting.rpc.RpcCommandFactory;
import com.alipay.remoting.rpc.RpcConfigManager;
import com.alipay.remoting.rpc.RpcConnectionEventHandler;
import com.alipay.remoting.rpc.RpcHandler;
import com.alipay.remoting.rpc.RpcRemoting;
import com.alipay.remoting.rpc.RpcResponseFuture;
import com.alipay.remoting.rpc.RpcServerRemoting;
import com.alipay.remoting.rpc.protocol.UserProcessor;
import com.alipay.remoting.rpc.protocol.UserProcessorRegisterHelper;
import com.alipay.remoting.util.IoUtils;
import com.alipay.remoting.util.NettyEventLoopUtil;
import com.alipay.remoting.util.RemotingUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLEngine;
import org.slf4j.Logger;

public class RpcServer
extends AbstractRemotingServer {
    private static final Logger logger = BoltLoggerFactory.getLogger("RpcRemoting");
    private ServerBootstrap bootstrap;
    private ChannelFuture channelFuture;
    private ConnectionEventHandler connectionEventHandler;
    private ConnectionEventListener connectionEventListener = new ConnectionEventListener();
    private ConcurrentHashMap<String, UserProcessor<?>> userProcessors = new ConcurrentHashMap(4);
    private final EventLoopGroup bossGroup = NettyEventLoopUtil.newEventLoopGroup(1, new NamedThreadFactory("Rpc-netty-server-boss", false));
    private static final EventLoopGroup workerGroup = NettyEventLoopUtil.newEventLoopGroup(Runtime.getRuntime().availableProcessors() * 2, new NamedThreadFactory("Rpc-netty-server-worker", true));
    private RemotingAddressParser addressParser;
    private DefaultServerConnectionManager connectionManager;
    protected RpcRemoting rpcRemoting;
    private Codec codec = new RpcCodec();

    public RpcServer() {
        this(false);
    }

    public RpcServer(boolean manageConnection) {
        this(0, manageConnection);
    }

    public RpcServer(int port) {
        this(port, false);
    }

    public RpcServer(String ip, int port) {
        this(ip, port, false);
    }

    public RpcServer(int port, boolean manageConnection) {
        super(port);
        if (manageConnection) {
            this.switches().turnOn(2);
        }
    }

    public RpcServer(String ip, int port, boolean manageConnection) {
        super(ip, port);
        if (manageConnection) {
            this.switches().turnOn(2);
        }
    }

    public RpcServer(int port, boolean manageConnection, boolean syncStop) {
        this(port, manageConnection);
        if (syncStop) {
            this.switches().turnOn(3);
        }
    }

    @Override
    protected void doInit() {
        if (this.addressParser == null) {
            this.addressParser = new RpcAddressParser();
        }
        if (this.switches().isOn(2)) {
            RandomSelectStrategy connectionSelectStrategy = new RandomSelectStrategy(null);
            this.connectionManager = new DefaultServerConnectionManager(connectionSelectStrategy);
            this.connectionManager.startup();
            this.connectionEventHandler = new RpcConnectionEventHandler(this.switches());
            this.connectionEventHandler.setConnectionManager(this.connectionManager);
            this.connectionEventHandler.setConnectionEventListener(this.connectionEventListener);
        } else {
            this.connectionEventHandler = new ConnectionEventHandler(this.switches());
            this.connectionEventHandler.setConnectionEventListener(this.connectionEventListener);
        }
        this.initRpcRemoting();
        Integer tcpSoSndBuf = this.option(BoltGenericOption.TCP_SO_SNDBUF);
        Integer tcpSoRcvBuf = this.option(BoltGenericOption.TCP_SO_RCVBUF);
        this.bootstrap = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)this.bootstrap.group(this.bossGroup, workerGroup).channel(NettyEventLoopUtil.getServerSocketChannelClass())).option(ChannelOption.SO_BACKLOG, (Object)ConfigManager.tcp_so_backlog())).option(ChannelOption.SO_REUSEADDR, (Object)ConfigManager.tcp_so_reuseaddr())).childOption(ChannelOption.TCP_NODELAY, (Object)ConfigManager.tcp_nodelay()).childOption(ChannelOption.SO_KEEPALIVE, (Object)ConfigManager.tcp_so_keepalive()).childOption(ChannelOption.SO_SNDBUF, (Object)(tcpSoSndBuf != null ? tcpSoSndBuf : ConfigManager.tcp_so_sndbuf())).childOption(ChannelOption.SO_RCVBUF, (Object)(tcpSoRcvBuf != null ? tcpSoRcvBuf : ConfigManager.tcp_so_rcvbuf()));
        this.initWriteBufferWaterMark();
        if (ConfigManager.netty_buffer_pooled()) {
            ((ServerBootstrap)this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
        } else {
            ((ServerBootstrap)this.bootstrap.option(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT);
        }
        NettyEventLoopUtil.enableTriggeredMode(this.bootstrap);
        final boolean idleSwitch = ConfigManager.tcp_idle_switch();
        final boolean flushConsolidationSwitch = this.switches().isOn(4);
        final int idleTime = ConfigManager.tcp_server_idle();
        ServerIdleHandler serverIdleHandler = new ServerIdleHandler();
        RpcHandler rpcHandler = new RpcHandler(true, this.userProcessors);
        this.bootstrap.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>((ChannelHandler)serverIdleHandler, rpcHandler){
            final /* synthetic */ ChannelHandler val$serverIdleHandler;
            final /* synthetic */ RpcHandler val$rpcHandler;
            {
                this.val$serverIdleHandler = channelHandler;
                this.val$rpcHandler = rpcHandler;
            }

            protected void initChannel(SocketChannel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                if (RpcConfigManager.server_ssl_enable()) {
                    SSLEngine engine = RpcServer.this.initSSLContext().newEngine(channel.alloc());
                    engine.setUseClientMode(false);
                    engine.setNeedClientAuth(RpcConfigManager.server_ssl_need_client_auth());
                    pipeline.addLast("sslHandler", (ChannelHandler)new SslHandler(engine));
                }
                if (flushConsolidationSwitch) {
                    pipeline.addLast("flushConsolidationHandler", (ChannelHandler)new FlushConsolidationHandler(1024, true));
                }
                pipeline.addLast("decoder", RpcServer.this.codec.newDecoder());
                pipeline.addLast("encoder", RpcServer.this.codec.newEncoder());
                if (idleSwitch) {
                    pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)idleTime, TimeUnit.MILLISECONDS));
                    pipeline.addLast("serverIdleHandler", this.val$serverIdleHandler);
                }
                pipeline.addLast("connectionEventHandler", (ChannelHandler)RpcServer.this.connectionEventHandler);
                pipeline.addLast("handler", (ChannelHandler)this.val$rpcHandler);
                this.createConnection(channel);
            }

            private void createConnection(SocketChannel channel) {
                Url url = RpcServer.this.addressParser.parse(RemotingUtil.parseRemoteAddress((Channel)channel));
                if (RpcServer.this.switches().isOn(2)) {
                    RpcServer.this.connectionManager.add(new Connection((Channel)channel, url), url.getUniqueKey());
                } else {
                    new Connection((Channel)channel, url);
                }
                channel.pipeline().fireUserEventTriggered((Object)ConnectionEventType.CONNECT);
            }
        });
    }

    private SslContext initSSLContext() {
        SslContext sslContext;
        FileInputStream in = null;
        try {
            KeyStore ks = KeyStore.getInstance(RpcConfigManager.server_ssl_keystore_type());
            in = new FileInputStream(RpcConfigManager.server_ssl_keystore());
            char[] passChs = RpcConfigManager.server_ssl_keystore_pass().toCharArray();
            ks.load(in, passChs);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(RpcConfigManager.server_ssl_kmf_algorithm());
            kmf.init(ks, passChs);
            sslContext = SslContextBuilder.forServer((KeyManagerFactory)kmf).build();
        }
        catch (Exception e) {
            try {
                logger.error("Fail to init SSL context for server.", (Throwable)e);
                throw new IllegalStateException("Fail to init SSL context", e);
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IoUtils.closeQuietly(in);
        return sslContext;
    }

    @Override
    protected boolean doStart() throws InterruptedException {
        for (UserProcessor<?> userProcessor : this.userProcessors.values()) {
            if (userProcessor.isStarted()) continue;
            userProcessor.startup();
        }
        this.channelFuture = this.bootstrap.bind((SocketAddress)new InetSocketAddress(this.ip(), this.port())).sync();
        if (this.port() == 0 && this.channelFuture.isSuccess()) {
            InetSocketAddress localAddress = (InetSocketAddress)this.channelFuture.channel().localAddress();
            this.setLocalBindingPort(localAddress.getPort());
            logger.info("rpc server start with random port: {}!", (Object)this.port());
        }
        return this.channelFuture.isSuccess();
    }

    @Override
    protected boolean doStop() {
        if (null != this.channelFuture) {
            this.channelFuture.channel().close();
        }
        if (this.switches().isOn(3)) {
            this.bossGroup.shutdownGracefully().awaitUninterruptibly();
        } else {
            this.bossGroup.shutdownGracefully();
        }
        if (this.switches().isOn(2) && null != this.connectionManager) {
            this.connectionManager.shutdown();
            logger.warn("Close all connections from server side!");
        }
        for (UserProcessor<?> userProcessor : this.userProcessors.values()) {
            if (!userProcessor.isStarted()) continue;
            userProcessor.shutdown();
        }
        logger.warn("Rpc Server stopped!");
        return true;
    }

    protected void initRpcRemoting() {
        this.rpcRemoting = new RpcServerRemoting(new RpcCommandFactory(), this.addressParser, this.connectionManager);
    }

    @Override
    public void registerProcessor(byte protocolCode, CommandCode cmd, RemotingProcessor<?> processor) {
        ProtocolManager.getProtocol(ProtocolCode.fromBytes(protocolCode)).getCommandHandler().registerProcessor(cmd, processor);
    }

    @Override
    public void registerDefaultExecutor(byte protocolCode, ExecutorService executor) {
        ProtocolManager.getProtocol(ProtocolCode.fromBytes(protocolCode)).getCommandHandler().registerDefaultExecutor(executor);
    }

    public void addConnectionEventProcessor(ConnectionEventType type, ConnectionEventProcessor processor) {
        this.connectionEventListener.addConnectionEventProcessor(type, processor);
    }

    @Override
    public void registerUserProcessor(UserProcessor<?> processor) {
        UserProcessorRegisterHelper.registerUserProcessor(processor, this.userProcessors);
        if (this.isStarted() && !processor.isStarted()) {
            processor.startup();
        }
    }

    public void oneway(String addr, Object request) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        this.rpcRemoting.oneway(addr, request, null);
    }

    public void oneway(String addr, Object request, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        this.rpcRemoting.oneway(addr, request, invokeContext);
    }

    public void oneway(Url url, Object request) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        this.rpcRemoting.oneway(url, request, null);
    }

    public void oneway(Url url, Object request, InvokeContext invokeContext) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        this.rpcRemoting.oneway(url, request, invokeContext);
    }

    public void oneway(Connection conn, Object request) throws RemotingException {
        this.ensureStarted();
        this.rpcRemoting.oneway(conn, request, null);
    }

    public void oneway(Connection conn, Object request, InvokeContext invokeContext) throws RemotingException {
        this.ensureStarted();
        this.rpcRemoting.oneway(conn, request, invokeContext);
    }

    public Object invokeSync(String addr, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        return this.rpcRemoting.invokeSync(addr, request, null, timeoutMillis);
    }

    public Object invokeSync(String addr, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        return this.rpcRemoting.invokeSync(addr, request, invokeContext, timeoutMillis);
    }

    public Object invokeSync(Url url, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        return this.rpcRemoting.invokeSync(url, request, null, timeoutMillis);
    }

    public Object invokeSync(Url url, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        return this.rpcRemoting.invokeSync(url, request, invokeContext, timeoutMillis);
    }

    public Object invokeSync(Connection conn, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeSync(conn, request, null, timeoutMillis);
    }

    public Object invokeSync(Connection conn, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        return this.rpcRemoting.invokeSync(conn, request, invokeContext, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(String addr, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        return this.rpcRemoting.invokeWithFuture(addr, request, null, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(String addr, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        return this.rpcRemoting.invokeWithFuture(addr, request, invokeContext, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Url url, Object request, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        return this.rpcRemoting.invokeWithFuture(url, request, null, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Url url, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        return this.rpcRemoting.invokeWithFuture(url, request, invokeContext, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Connection conn, Object request, int timeoutMillis) throws RemotingException {
        this.ensureStarted();
        return this.rpcRemoting.invokeWithFuture(conn, request, null, timeoutMillis);
    }

    public RpcResponseFuture invokeWithFuture(Connection conn, Object request, InvokeContext invokeContext, int timeoutMillis) throws RemotingException {
        this.ensureStarted();
        return this.rpcRemoting.invokeWithFuture(conn, request, invokeContext, timeoutMillis);
    }

    public void invokeWithCallback(String addr, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        this.rpcRemoting.invokeWithCallback(addr, request, null, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(String addr, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        this.rpcRemoting.invokeWithCallback(addr, request, invokeContext, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Url url, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        this.rpcRemoting.invokeWithCallback(url, request, null, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Url url, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException, InterruptedException {
        this.ensureStarted();
        this.check();
        this.rpcRemoting.invokeWithCallback(url, request, invokeContext, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Connection conn, Object request, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException {
        this.ensureStarted();
        this.rpcRemoting.invokeWithCallback(conn, request, null, invokeCallback, timeoutMillis);
    }

    public void invokeWithCallback(Connection conn, Object request, InvokeContext invokeContext, InvokeCallback invokeCallback, int timeoutMillis) throws RemotingException {
        this.ensureStarted();
        this.rpcRemoting.invokeWithCallback(conn, request, invokeContext, invokeCallback, timeoutMillis);
    }

    public boolean isConnected(String remoteAddr) {
        this.ensureStarted();
        Url url = this.rpcRemoting.addressParser.parse(remoteAddr);
        return this.isConnected(url);
    }

    public boolean isConnected(Url url) {
        this.ensureStarted();
        Connection conn = this.rpcRemoting.connectionManager.get(url.getUniqueKey());
        if (null != conn) {
            return conn.isFine();
        }
        return false;
    }

    private void check() {
        if (!this.switches().isOn(2)) {
            throw new UnsupportedOperationException("Please enable connection manage feature of Rpc Server before call this method! See comments in constructor RpcServer(int port, boolean manageConnection) to find how to enable!");
        }
    }

    private void initWriteBufferWaterMark() {
        int highWaterMark;
        int lowWaterMark = this.netty_buffer_low_watermark();
        if (lowWaterMark > (highWaterMark = this.netty_buffer_high_watermark())) {
            throw new IllegalArgumentException(String.format("[server side] bolt netty high water mark {%s} should not be smaller than low water mark {%s} bytes)", highWaterMark, lowWaterMark));
        }
        logger.warn("[server side] bolt netty low water mark is {} bytes, high water mark is {} bytes", (Object)lowWaterMark, (Object)highWaterMark);
        this.bootstrap.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(lowWaterMark, highWaterMark));
    }

    public RemotingAddressParser getAddressParser() {
        return this.addressParser;
    }

    public void setAddressParser(RemotingAddressParser addressParser) {
        this.addressParser = addressParser;
    }

    public DefaultConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    static {
        if (workerGroup instanceof NioEventLoopGroup) {
            ((NioEventLoopGroup)workerGroup).setIoRatio(ConfigManager.netty_io_ratio());
        } else if (workerGroup instanceof EpollEventLoopGroup) {
            ((EpollEventLoopGroup)workerGroup).setIoRatio(ConfigManager.netty_io_ratio());
        }
    }
}

