/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cola.event;

import com.alibaba.cola.dto.ErrorCodeI;
import com.alibaba.cola.dto.Response;
import com.alibaba.cola.event.EventBusI;
import com.alibaba.cola.event.EventHandlerI;
import com.alibaba.cola.event.EventHub;
import com.alibaba.cola.event.EventI;
import com.alibaba.cola.exception.framework.BaseException;
import com.alibaba.cola.exception.framework.BasicErrorCode;
import com.alibaba.cola.exception.framework.ColaException;
import com.alibaba.cola.logger.Logger;
import com.alibaba.cola.logger.LoggerFactory;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EventBus
implements EventBusI {
    Logger logger = LoggerFactory.getLogger(EventBus.class);
    ExecutorService defaultExecutor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors() + 1, Runtime.getRuntime().availableProcessors() + 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1000));
    @Autowired
    private EventHub eventHub;

    @Override
    public Response fire(EventI event) {
        Object response = null;
        EventHandlerI eventHandlerI = null;
        try {
            eventHandlerI = this.eventHub.getEventHandler(event.getClass()).get(0);
            response = eventHandlerI.execute(event);
        }
        catch (Exception exception) {
            response = this.handleException(eventHandlerI, (Response)response, exception);
        }
        return response;
    }

    @Override
    public void fireAll(EventI event) {
        this.eventHub.getEventHandler(event.getClass()).stream().map(p -> {
            Response response = null;
            try {
                response = (Response)p.execute(event);
            }
            catch (Exception exception) {
                response = this.handleException((EventHandlerI)p, response, exception);
            }
            return response;
        }).collect(Collectors.toList());
    }

    @Override
    public void asyncFire(EventI event) {
        this.eventHub.getEventHandler(event.getClass()).parallelStream().map(p -> {
            Response response = null;
            try {
                if (null != p.getExecutor()) {
                    p.getExecutor().submit(() -> p.execute(event));
                } else {
                    this.defaultExecutor.submit(() -> p.execute(event));
                }
            }
            catch (Exception exception) {
                response = this.handleException((EventHandlerI)p, response, exception);
            }
            return response;
        }).collect(Collectors.toList());
    }

    private Response handleException(EventHandlerI handler, Response response, Exception exception) {
        this.logger.error(exception.getMessage(), exception);
        Class responseClz = this.eventHub.getResponseRepository().get(handler.getClass());
        try {
            response = (Response)responseClz.newInstance();
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), e);
            throw new ColaException(e.getMessage());
        }
        if (exception instanceof BaseException) {
            ErrorCodeI errCode = ((BaseException)exception).getErrCode();
            response.setErrCode(errCode.getErrCode());
        } else {
            response.setErrCode(BasicErrorCode.SYS_ERROR.getErrCode());
        }
        response.setErrMessage(exception.getMessage());
        return response;
    }
}

