/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.util.IterableStream;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.EventDataBatch;
import com.azure.messaging.eventhubs.EventHubClientBuilder;
import com.azure.messaging.eventhubs.EventHubProducerAsyncClient;
import com.azure.messaging.eventhubs.EventHubProperties;
import com.azure.messaging.eventhubs.PartitionProperties;
import com.azure.messaging.eventhubs.models.CreateBatchOptions;
import com.azure.messaging.eventhubs.models.SendOptions;
import java.io.Closeable;
import java.util.Objects;

@ServiceClient(builder=EventHubClientBuilder.class)
public class EventHubProducerClient
implements Closeable {
    private final EventHubProducerAsyncClient producer;

    EventHubProducerClient(EventHubProducerAsyncClient producer) {
        this.producer = Objects.requireNonNull(producer, "'producer' cannot be null.");
    }

    public String getEventHubName() {
        return this.producer.getEventHubName();
    }

    public String getFullyQualifiedNamespace() {
        return this.producer.getFullyQualifiedNamespace();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventHubProperties getEventHubProperties() {
        return (EventHubProperties)this.producer.getEventHubProperties().block();
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public IterableStream<String> getPartitionIds() {
        return new IterableStream(this.producer.getPartitionIds());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public PartitionProperties getPartitionProperties(String partitionId) {
        return (PartitionProperties)this.producer.getPartitionProperties(partitionId).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventDataBatch createBatch() {
        return (EventDataBatch)this.producer.createBatch().block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public EventDataBatch createBatch(CreateBatchOptions options) {
        return (EventDataBatch)this.producer.createBatch(options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void send(EventData event) {
        this.producer.send(event).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    void send(EventData event, SendOptions options) {
        this.producer.send(event, options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void send(Iterable<EventData> events) {
        this.producer.send(events).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void send(Iterable<EventData> events, SendOptions options) {
        this.producer.send(events, options).block();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void send(EventDataBatch batch) {
        this.producer.send(batch).block();
    }

    @Override
    public void close() {
        this.producer.close();
    }

    public String getIdentifier() {
        return this.producer.getIdentifier();
    }
}

