/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.messaging.eventhubs.Messages;
import com.azure.messaging.eventhubs.models.PartitionEvent;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.FluxSink;

public class SynchronousReceiveWork {
    private static final ClientLogger LOGGER = new ClientLogger(SynchronousReceiveWork.class);
    private final long id;
    private final AtomicInteger remaining;
    private final int numberToReceive;
    private final Duration timeout;
    private final FluxSink<PartitionEvent> emitter;
    private volatile boolean isTerminal = false;

    public SynchronousReceiveWork(long id, int numberToReceive, Duration timeout, FluxSink<PartitionEvent> emitter) {
        this.id = id;
        this.remaining = new AtomicInteger(numberToReceive);
        this.numberToReceive = numberToReceive;
        this.timeout = timeout;
        this.emitter = emitter;
    }

    public long getId() {
        return this.id;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    int getNumberOfEvents() {
        return this.numberToReceive;
    }

    boolean isTerminal() {
        return this.emitter.isCancelled() || this.remaining.get() == 0 || this.isTerminal;
    }

    public void next(PartitionEvent event) {
        try {
            this.emitter.next((Object)event);
            this.remaining.decrementAndGet();
        }
        catch (Exception e) {
            LOGGER.warning(Messages.EXCEPTION_OCCURRED_WHILE_EMITTING, new Object[]{e});
            this.isTerminal = true;
            this.emitter.error((Throwable)e);
        }
    }

    public synchronized void complete() {
        if (!this.isTerminal || this.emitter.isCancelled()) {
            LOGGER.atInfo().addKeyValue("workId", this.id).log("Completing task.");
            this.isTerminal = true;
            this.emitter.complete();
        }
    }

    public void error(Throwable error) {
        this.isTerminal = true;
        this.emitter.error(error);
    }
}

