/*
 * Decompiled with CFR 0.152.
 */
package com.azure.messaging.eventhubs.implementation.instrumentation;

import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import com.azure.core.util.tracing.Tracer;
import com.azure.core.util.tracing.TracingLink;
import com.azure.messaging.eventhubs.EventData;
import com.azure.messaging.eventhubs.implementation.instrumentation.InstrumentationUtils;
import com.azure.messaging.eventhubs.implementation.instrumentation.OperationName;
import com.azure.messaging.eventhubs.models.EventBatchContext;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class EventHubsTracer {
    private static final AutoCloseable NOOP_AUTOCLOSEABLE = () -> {};
    private static final TracingLink DUMMY_LINK = new TracingLink(Context.NONE);
    private static final ClientLogger LOGGER = new ClientLogger(EventHubsTracer.class);
    private static final boolean IS_TRACING_DISABLED = (Boolean)Configuration.getGlobalConfiguration().get("AZURE_TRACING_DISABLED", (Object)false);
    protected final Tracer tracer;
    private final String fullyQualifiedName;
    private final String entityName;
    private final String consumerGroup;

    public EventHubsTracer(Tracer tracer, String fullyQualifiedName, String entityName, String consumerGroup) {
        this.tracer = IS_TRACING_DISABLED ? null : tracer;
        this.fullyQualifiedName = Objects.requireNonNull(fullyQualifiedName, "'fullyQualifiedName' cannot be null");
        this.entityName = Objects.requireNonNull(entityName, "'entityPath' cannot be null");
        this.consumerGroup = "$Default".equalsIgnoreCase(consumerGroup) ? null : consumerGroup;
    }

    public boolean isEnabled() {
        return this.tracer != null && this.tracer.isEnabled();
    }

    public Context startSpan(OperationName operationName, StartSpanOptions startOptions, Context context) {
        return this.isEnabled() ? this.tracer.start(this.getSpanName(operationName), startOptions, context) : context;
    }

    public Context startGenericOperationSpan(OperationName operationName, String partitionId, Context parent) {
        if (!this.isEnabled()) {
            return parent;
        }
        return this.tracer.start(this.getSpanName(operationName), this.createStartOptions(SpanKind.CLIENT, operationName, partitionId), parent);
    }

    public void reportMessageSpan(EventData eventData, Context eventContext) {
        if (!this.isEnabled() || eventContext == null || eventContext.getData((Object)"span-context").isPresent()) {
            return;
        }
        String traceparent = EventHubsTracer.getTraceparent(eventData.getProperties());
        if (traceparent != null) {
            return;
        }
        StartSpanOptions startOptions = this.createStartOptions(SpanKind.PRODUCER, OperationName.EVENT, null);
        Context eventSpanContext = this.tracer.start(this.getSpanName(OperationName.EVENT), startOptions, eventContext);
        RuntimeException exception = null;
        String error = null;
        if (EventHubsTracer.canModifyApplicationProperties(eventData.getProperties())) {
            try {
                this.tracer.injectContext((key, value) -> {
                    eventData.getProperties().put((String)key, value);
                    if ("traceparent".equals(key)) {
                        eventData.getProperties().put("Diagnostic-Id", value);
                    }
                }, eventSpanContext);
            }
            catch (RuntimeException ex) {
                LOGGER.warning("Failed to inject context into EventData", new Object[]{ex});
                exception = ex;
            }
        } else {
            error = "failed to inject context into EventData";
        }
        this.tracer.end(error, exception, eventSpanContext);
        Optional spanContext = eventSpanContext.getData((Object)"span-context");
        spanContext.ifPresent(o -> eventData.addContext("span-context", o));
    }

    public TracingLink createLink(Map<String, Object> applicationProperties, Instant enqueuedTime) {
        return this.createLink(this.extractContext(applicationProperties), enqueuedTime);
    }

    private TracingLink createLink(Context linkContext, Instant enqueuedTime) {
        Map<String, Long> linkAttributes = null;
        if (enqueuedTime != null) {
            linkAttributes = Collections.singletonMap("messaging.eventhubs.message.enqueued_time", enqueuedTime.atOffset(ZoneOffset.UTC).toEpochSecond());
        }
        return new TracingLink(linkContext, linkAttributes);
    }

    public TracingLink createProducerLink(Map<String, Object> applicationProperties, Context eventContext) {
        if (!this.tracer.isEnabled() || applicationProperties == null) {
            return DUMMY_LINK;
        }
        Context link = Context.NONE;
        Optional linkContext = eventContext.getData((Object)"span-context");
        if (linkContext.isPresent()) {
            if (linkContext.get() instanceof Context) {
                link = (Context)linkContext.get();
            } else {
                LOGGER.verbose("Unexpected type under 'span-context' key - {}", new Object[]{linkContext.get().getClass()});
            }
        } else {
            link = this.extractContext(applicationProperties);
        }
        return new TracingLink(link, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endSpan(String errorType, Throwable throwable, Context context, AutoCloseable scope) {
        if (this.isEnabled()) {
            try {
                if (scope != null) {
                    scope.close();
                }
                this.tracer.end(errorType == null ? InstrumentationUtils.getErrorType(throwable) : errorType, InstrumentationUtils.unwrap(throwable), context);
            }
            catch (Exception e) {
                try {
                    LOGGER.verbose("Can't close scope", new Object[]{e});
                    this.tracer.end(errorType == null ? InstrumentationUtils.getErrorType(throwable) : errorType, InstrumentationUtils.unwrap(throwable), context);
                }
                catch (Throwable throwable2) {
                    this.tracer.end(errorType == null ? InstrumentationUtils.getErrorType(throwable) : errorType, InstrumentationUtils.unwrap(throwable), context);
                    throw throwable2;
                }
            }
        }
    }

    AutoCloseable makeSpanCurrent(Context context) {
        return this.isEnabled() ? this.tracer.makeSpanCurrent(context) : NOOP_AUTOCLOSEABLE;
    }

    Context startProcessSpan(Map<String, Object> applicationProperties, Instant enqueuedTime, String partitionId) {
        if (this.isEnabled()) {
            Context remoteContext = this.extractContext(applicationProperties);
            StartSpanOptions startOptions = this.createStartOptions(SpanKind.CONSUMER, OperationName.PROCESS, partitionId).addLink(this.createLink(remoteContext, null)).setRemoteParent(remoteContext);
            if (enqueuedTime != null) {
                startOptions.setAttribute("messaging.eventhubs.message.enqueued_time", (Object)enqueuedTime.atOffset(ZoneOffset.UTC).toEpochSecond());
            }
            return this.tracer.start(this.getSpanName(OperationName.PROCESS), startOptions, Context.NONE);
        }
        return Context.NONE;
    }

    Context startProcessSpan(EventBatchContext batchContext) {
        if (this.isEnabled() && batchContext != null && !CoreUtils.isNullOrEmpty(batchContext.getEvents())) {
            StartSpanOptions startOptions = this.createStartOptions(SpanKind.CONSUMER, OperationName.PROCESS, batchContext.getPartitionContext().getPartitionId());
            startOptions.setAttribute("messaging.batch.message_count", (Object)batchContext.getEvents().size());
            for (EventData event : batchContext.getEvents()) {
                startOptions.addLink(this.createLink(event.getProperties(), event.getEnqueuedTime()));
            }
            return this.tracer.start(this.getSpanName(OperationName.PROCESS), startOptions, Context.NONE);
        }
        return Context.NONE;
    }

    public StartSpanOptions createStartOptions(SpanKind kind, OperationName operationName, String partitionId) {
        String operationType;
        StartSpanOptions startOptions = new StartSpanOptions(kind).setAttribute("messaging.system", (Object)"eventhubs").setAttribute("messaging.destination.name", (Object)this.entityName).setAttribute("server.address", (Object)this.fullyQualifiedName).setAttribute("messaging.operation.name", (Object)operationName.toString());
        if (this.consumerGroup != null) {
            startOptions.setAttribute("messaging.consumer.group.name", (Object)this.consumerGroup);
        }
        if (partitionId != null) {
            startOptions.setAttribute("messaging.destination.partition.id", (Object)partitionId);
        }
        if ((operationType = InstrumentationUtils.getOperationType(operationName)) != null) {
            startOptions.setAttribute("messaging.operation.type", (Object)operationType);
        }
        return startOptions;
    }

    private static String getTraceparent(Map<String, Object> applicationProperties) {
        Object diagnosticId = applicationProperties.get("Diagnostic-Id");
        if (diagnosticId == null) {
            diagnosticId = applicationProperties.get("traceparent");
        }
        return diagnosticId == null ? null : diagnosticId.toString();
    }

    private Context extractContext(Map<String, Object> applicationProperties) {
        if (this.tracer.isEnabled() && applicationProperties != null) {
            return this.tracer.extractContext(key -> {
                if ("traceparent".equals(key)) {
                    return EventHubsTracer.getTraceparent(applicationProperties);
                }
                Object value = applicationProperties.get(key);
                if (value != null) {
                    return value.toString();
                }
                return null;
            });
        }
        return Context.NONE;
    }

    private String getSpanName(OperationName operationName) {
        return operationName.toString() + " " + this.entityName;
    }

    private static boolean canModifyApplicationProperties(Map<String, Object> applicationProperties) {
        return applicationProperties != null && !applicationProperties.getClass().getSimpleName().equals("UnmodifiableMap");
    }
}

