/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.util.Context;
import com.azure.storage.queue.implementation.AzureQueueStorageImpl;
import com.azure.storage.queue.implementation.models.MessagesClearResponse;
import com.azure.storage.queue.implementation.models.MessagesDequeueResponse;
import com.azure.storage.queue.implementation.models.MessagesEnqueueResponse;
import com.azure.storage.queue.implementation.models.MessagesPeekResponse;
import com.azure.storage.queue.implementation.models.QueueMessage;
import com.azure.storage.queue.models.QueueStorageException;
import reactor.core.publisher.Mono;

public final class MessagesImpl {
    private MessagesService service;
    private AzureQueueStorageImpl client;

    public MessagesImpl(AzureQueueStorageImpl client) {
        this.service = (MessagesService)RestProxy.create(MessagesService.class, (HttpPipeline)client.getHttpPipeline());
        this.client = client;
    }

    public Mono<MessagesDequeueResponse> dequeueWithRestResponseAsync(String queueName, Context context) {
        Integer numberOfMessages = null;
        Integer visibilitytimeout = null;
        Integer timeout = null;
        String requestId = null;
        return this.service.dequeue(queueName, this.client.getUrl(), numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<MessagesDequeueResponse> dequeueWithRestResponseAsync(String queueName, Integer numberOfMessages, Integer visibilitytimeout, Integer timeout, String requestId, Context context) {
        return this.service.dequeue(queueName, this.client.getUrl(), numberOfMessages, visibilitytimeout, timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<MessagesClearResponse> clearWithRestResponseAsync(String queueName, Context context) {
        Integer timeout = null;
        String requestId = null;
        return this.service.clear(queueName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<MessagesClearResponse> clearWithRestResponseAsync(String queueName, Integer timeout, String requestId, Context context) {
        return this.service.clear(queueName, this.client.getUrl(), timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<MessagesEnqueueResponse> enqueueWithRestResponseAsync(String queueName, QueueMessage queueMessage, Context context) {
        Integer visibilitytimeout = null;
        Integer messageTimeToLive = null;
        Integer timeout = null;
        String requestId = null;
        return this.service.enqueue(queueName, this.client.getUrl(), queueMessage, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<MessagesEnqueueResponse> enqueueWithRestResponseAsync(String queueName, QueueMessage queueMessage, Integer visibilitytimeout, Integer messageTimeToLive, Integer timeout, String requestId, Context context) {
        return this.service.enqueue(queueName, this.client.getUrl(), queueMessage, visibilitytimeout, messageTimeToLive, timeout, this.client.getVersion(), requestId, context);
    }

    public Mono<MessagesPeekResponse> peekWithRestResponseAsync(String queueName, Context context) {
        Integer numberOfMessages = null;
        Integer timeout = null;
        String requestId = null;
        String peekonly = "true";
        return this.service.peek(queueName, this.client.getUrl(), numberOfMessages, timeout, this.client.getVersion(), requestId, "true", context);
    }

    public Mono<MessagesPeekResponse> peekWithRestResponseAsync(String queueName, Integer numberOfMessages, Integer timeout, String requestId, Context context) {
        String peekonly = "true";
        return this.service.peek(queueName, this.client.getUrl(), numberOfMessages, timeout, this.client.getVersion(), requestId, "true", context);
    }

    @Host(value="{url}")
    @ServiceInterface(name="AzureQueueStorageMessages")
    private static interface MessagesService {
        @Get(value="{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<MessagesDequeueResponse> dequeue(@PathParam(value="queueName") String var1, @HostParam(value="url") String var2, @QueryParam(value="numofmessages") Integer var3, @QueryParam(value="visibilitytimeout") Integer var4, @QueryParam(value="timeout") Integer var5, @HeaderParam(value="x-ms-version") String var6, @HeaderParam(value="x-ms-client-request-id") String var7, Context var8);

        @Delete(value="{queueName}/messages")
        @ExpectedResponses(value={204})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<MessagesClearResponse> clear(@PathParam(value="queueName") String var1, @HostParam(value="url") String var2, @QueryParam(value="timeout") Integer var3, @HeaderParam(value="x-ms-version") String var4, @HeaderParam(value="x-ms-client-request-id") String var5, Context var6);

        @Post(value="{queueName}/messages")
        @ExpectedResponses(value={201})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<MessagesEnqueueResponse> enqueue(@PathParam(value="queueName") String var1, @HostParam(value="url") String var2, @BodyParam(value="application/xml; charset=utf-8") QueueMessage var3, @QueryParam(value="visibilitytimeout") Integer var4, @QueryParam(value="messagettl") Integer var5, @QueryParam(value="timeout") Integer var6, @HeaderParam(value="x-ms-version") String var7, @HeaderParam(value="x-ms-client-request-id") String var8, Context var9);

        @Get(value="{queueName}/messages")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=QueueStorageException.class)
        public Mono<MessagesPeekResponse> peek(@PathParam(value="queueName") String var1, @HostParam(value="url") String var2, @QueryParam(value="numofmessages") Integer var3, @QueryParam(value="timeout") Integer var4, @HeaderParam(value="x-ms-version") String var5, @HeaderParam(value="x-ms-client-request-id") String var6, @QueryParam(value="peekonly") String var7, Context var8);
    }
}

