/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.queue.sas;

import com.azure.core.util.CoreUtils;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.common.implementation.Constants;
import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.common.sas.SasIpRange;
import com.azure.storage.common.sas.SasProtocol;
import com.azure.storage.queue.QueueServiceVersion;
import com.azure.storage.queue.sas.QueueSasPermission;
import com.azure.storage.queue.sas.QueueServiceSasQueryParameters;
import java.time.OffsetDateTime;

public final class QueueServiceSasSignatureValues {
    private String version;
    private SasProtocol protocol;
    private OffsetDateTime startTime;
    private OffsetDateTime expiryTime;
    private String permissions;
    private SasIpRange sasIpRange;
    private String queueName;
    private String identifier;

    @Deprecated
    public QueueServiceSasSignatureValues() {
    }

    public QueueServiceSasSignatureValues(OffsetDateTime expiryTime, QueueSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"expiryTime", (Object)expiryTime);
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.expiryTime = expiryTime;
        this.permissions = permissions.toString();
    }

    public QueueServiceSasSignatureValues(String identifier) {
        StorageImplUtils.assertNotNull((String)"identifier", (Object)identifier);
        this.identifier = identifier;
    }

    public String getVersion() {
        return this.version;
    }

    public QueueServiceSasSignatureValues setVersion(String version) {
        this.version = version;
        return this;
    }

    public SasProtocol getProtocol() {
        return this.protocol;
    }

    public QueueServiceSasSignatureValues setProtocol(SasProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    public OffsetDateTime getStartTime() {
        return this.startTime;
    }

    public QueueServiceSasSignatureValues setStartTime(OffsetDateTime startTime) {
        this.startTime = startTime;
        return this;
    }

    public OffsetDateTime getExpiryTime() {
        return this.expiryTime;
    }

    public QueueServiceSasSignatureValues setExpiryTime(OffsetDateTime expiryTime) {
        this.expiryTime = expiryTime;
        return this;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public QueueServiceSasSignatureValues setPermissions(QueueSasPermission permissions) {
        StorageImplUtils.assertNotNull((String)"permissions", (Object)permissions);
        this.permissions = permissions.toString();
        return this;
    }

    public SasIpRange getSasIpRange() {
        return this.sasIpRange;
    }

    public QueueServiceSasSignatureValues setSasIpRange(SasIpRange sasIpRange) {
        this.sasIpRange = sasIpRange;
        return this;
    }

    @Deprecated
    public String getQueueName() {
        return this.queueName;
    }

    @Deprecated
    public QueueServiceSasSignatureValues setQueueName(String queueName) {
        this.queueName = queueName;
        return this;
    }

    @Deprecated
    public String getId() {
        return this.identifier;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public QueueServiceSasSignatureValues setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    @Deprecated
    public QueueServiceSasQueryParameters generateSasQueryParameters(StorageSharedKeyCredential storageSharedKeyCredentials) {
        StorageImplUtils.assertNotNull((String)"storageSharedKeyCredentials", (Object)storageSharedKeyCredentials);
        if (CoreUtils.isNullOrEmpty((CharSequence)this.version)) {
            this.version = QueueServiceVersion.getLatest().getVersion();
        }
        String canonicalName = QueueServiceSasSignatureValues.getCanonicalName(storageSharedKeyCredentials.getAccountName(), this.queueName);
        String stringToSign = this.stringToSign(canonicalName);
        String signature = storageSharedKeyCredentials.computeHmac256(stringToSign);
        return new QueueServiceSasQueryParameters(this.version, this.protocol, this.startTime, this.expiryTime, this.sasIpRange, this.identifier, this.permissions, signature);
    }

    private static String getCanonicalName(String account, String queueName) {
        return String.join((CharSequence)"", "/queue/", account, "/", queueName);
    }

    private String stringToSign(String canonicalName) {
        return String.join((CharSequence)"\n", this.permissions == null ? "" : this.permissions, this.startTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.startTime), this.expiryTime == null ? "" : Constants.ISO_8601_UTC_DATE_FORMATTER.format(this.expiryTime), canonicalName, this.identifier == null ? "" : this.identifier, this.sasIpRange == null ? "" : this.sasIpRange.toString(), this.protocol == null ? "" : this.protocol.toString(), this.version == null ? "" : this.version);
    }
}

