/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security.graph;

import com.azure.spring.cloud.autoconfigure.implementation.aad.configuration.properties.AadAuthenticationProperties;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.graph.GroupInformation;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.graph.Membership;
import com.azure.spring.cloud.autoconfigure.implementation.aad.security.graph.Memberships;
import com.azure.spring.cloud.autoconfigure.implementation.aad.utils.AadRestTemplateCreator;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class GraphClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphClient.class);
    private final AadAuthenticationProperties properties;
    private final RestOperations operations;

    GraphClient(AadAuthenticationProperties properties, RestTemplate restTemplate) {
        this.properties = properties;
        this.operations = restTemplate;
    }

    public GraphClient(AadAuthenticationProperties properties, RestTemplateBuilder restTemplateBuilder) {
        this(properties, AadRestTemplateCreator.createRestTemplate(restTemplateBuilder));
    }

    public GroupInformation getGroupInformation(String accessToken) {
        Optional<Memberships> userMemberships;
        GroupInformation groupInformation = new GroupInformation();
        String aadMembershipRestUri = this.properties.getGraphMembershipUri();
        while (aadMembershipRestUri != null && (userMemberships = this.getUserMemberships(accessToken, aadMembershipRestUri)).isPresent()) {
            for (Membership membership : userMemberships.get().getValue()) {
                if (!this.isGroupObject(membership)) continue;
                groupInformation.getGroupsIds().add(membership.getObjectID());
                groupInformation.getGroupsNames().add(membership.getDisplayName());
            }
            aadMembershipRestUri = userMemberships.map(Memberships::getOdataNextLink).orElse(null);
        }
        return groupInformation;
    }

    Optional<Memberships> getUserMemberships(String accessToken, String urlString) {
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", String.format("Bearer %s", accessToken));
        headers.set("Accept", "application/json");
        headers.set("Content-Type", "application/x-www-form-urlencoded");
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.operations.exchange(urlString, HttpMethod.GET, entity, Memberships.class, new Object[0]);
            if (response.getStatusCode() == HttpStatus.OK) {
                return Optional.of((Memberships)response.getBody());
            }
            LOGGER.error("Response code [{}] is not 200, the response body is [{}].", (Object)response.getStatusCode(), response.getBody());
            return Optional.empty();
        }
        catch (RestClientException restClientException) {
            LOGGER.error("Can not get group information from graph server.", (Throwable)restClientException);
            return Optional.empty();
        }
    }

    private boolean isGroupObject(Membership membership) {
        return membership.getObjectType().equals("#microsoft.graph.group");
    }
}

