/*
 * Decompiled with CFR 0.152.
 */
package com.azure.spring.cloud.autoconfigure.implementation.aad.security.jwt;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.factories.DefaultJWSSignerFactory;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKMatcher;
import com.nimbusds.jose.jwk.JWKSelector;
import com.nimbusds.jose.jwk.KeyType;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jose.produce.JWSSignerFactory;
import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtException;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public final class AadJwtEncoder {
    private static final String ENCODING_ERROR_MESSAGE_TEMPLATE = "An error occurred while attempting to encode the Jwt: %s";
    private static final JWSSignerFactory JWS_SIGNER_FACTORY = new DefaultJWSSignerFactory();
    private final Map<JWK, JWSSigner> jwsSigners = new ConcurrentHashMap<JWK, JWSSigner>();
    private final JWKSource<SecurityContext> jwkSource;

    public AadJwtEncoder(JWKSource<SecurityContext> jwkSource) {
        Assert.notNull(jwkSource, (String)"jwkSource cannot be null");
        this.jwkSource = jwkSource;
    }

    public Jwt encode(Map<String, Object> jwsHeader, Map<String, Object> jwtClaimsSet) throws JwtException {
        Assert.notNull(jwsHeader, (String)"jwsHeader cannot be null");
        Assert.notNull(jwtClaimsSet, (String)"jwtClaimsSet cannot be null");
        JWK jwk = this.selectJwk(jwsHeader);
        String jws = this.serialize(jwsHeader, jwtClaimsSet, jwk);
        return new Jwt(jws, (Instant)jwtClaimsSet.get("iat"), (Instant)jwtClaimsSet.get("exp"), jwsHeader, jwtClaimsSet);
    }

    private JWK selectJwk(Map<String, Object> jwsHeader) {
        List jwks;
        try {
            JWKSelector jwkSelector = new JWKSelector(AadJwtEncoder.createJwkMatcher(jwsHeader));
            jwks = this.jwkSource.get(jwkSelector, null);
        }
        catch (Exception ex) {
            throw new JwtException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to select a JWK signing key -> " + ex.getMessage()), (Throwable)ex);
        }
        if (jwks.size() > 1) {
            throw new JwtException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Found multiple JWK signing keys for algorithm '" + String.valueOf(jwsHeader.get("alg")) + "'"));
        }
        if (jwks.isEmpty()) {
            throw new JwtException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to select a JWK signing key"));
        }
        return (JWK)jwks.get(0);
    }

    private String serialize(Map<String, Object> headers, Map<String, Object> claims, JWK jwk) {
        JWSHeader jwsHeader = AadJwtEncoder.convertHeader(headers);
        JWTClaimsSet jwtClaimsSet = AadJwtEncoder.convertClaims(claims);
        JWSSigner jwsSigner = this.jwsSigners.computeIfAbsent(jwk, AadJwtEncoder::createSigner);
        SignedJWT signedJwt = new SignedJWT(jwsHeader, jwtClaimsSet);
        try {
            signedJwt.sign(jwsSigner);
        }
        catch (JOSEException ex) {
            throw new JwtException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to sign the JWT -> " + ex.getMessage()), (Throwable)ex);
        }
        return signedJwt.serialize();
    }

    private static JWKMatcher createJwkMatcher(Map<String, Object> jwsHeader) {
        JWSAlgorithm jwsAlgorithm = JWSAlgorithm.parse((String)((String)jwsHeader.get("alg")));
        if (JWSAlgorithm.Family.RSA.contains((Object)jwsAlgorithm)) {
            return new JWKMatcher.Builder().keyType(KeyType.forAlgorithm((Algorithm)jwsAlgorithm)).keyUses(new KeyUse[]{KeyUse.SIGNATURE, null}).algorithms(new Algorithm[]{jwsAlgorithm, null}).x509CertSHA256Thumbprint(Base64URL.from((String)((String)jwsHeader.get("x5t#S256")))).build();
        }
        return null;
    }

    private static JWSSigner createSigner(JWK jwk) {
        try {
            return JWS_SIGNER_FACTORY.createJWSSigner(jwk);
        }
        catch (JOSEException ex) {
            throw new JwtException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Failed to create a JWS Signer -> " + ex.getMessage()), (Throwable)ex);
        }
    }

    private static JWSHeader convertHeader(Map<String, Object> headers) {
        String type;
        String x509SHA1Thumbprint;
        String keyId;
        JWSHeader.Builder builder = new JWSHeader.Builder(JWSAlgorithm.parse((String)((String)headers.get("alg"))));
        Map jwk = (Map)headers.get("jwk");
        if (!CollectionUtils.isEmpty((Map)jwk)) {
            try {
                builder.jwk(JWK.parse((Map)jwk));
            }
            catch (Exception ex) {
                throw new JwtException(String.format(ENCODING_ERROR_MESSAGE_TEMPLATE, "Unable to convert 'jku' JOSE header"), (Throwable)ex);
            }
        }
        if (StringUtils.hasText((String)(keyId = (String)headers.get("kid")))) {
            builder.keyID(keyId);
        }
        if (StringUtils.hasText((String)(x509SHA1Thumbprint = (String)headers.get("x5t")))) {
            builder.x509CertThumbprint(new Base64URL(x509SHA1Thumbprint));
        }
        if (StringUtils.hasText((String)(type = (String)headers.get("typ")))) {
            builder.type(new JOSEObjectType(type));
        }
        HashMap customHeaders = new HashMap();
        headers.forEach((name, value) -> {
            if (!JWSHeader.getRegisteredParameterNames().contains(name)) {
                customHeaders.put(name, value);
            }
        });
        if (!customHeaders.isEmpty()) {
            builder.customParams(customHeaders);
        }
        return builder.build();
    }

    private static JWTClaimsSet convertClaims(Map<String, Object> claims) {
        String jwtId;
        Instant issuedAt;
        Instant notBefore;
        Instant expiresAt;
        List audience;
        String subject;
        JWTClaimsSet.Builder builder = new JWTClaimsSet.Builder();
        Object issuer = claims.get("iss");
        if (issuer != null) {
            builder.issuer(issuer.toString());
        }
        if (StringUtils.hasText((String)(subject = (String)claims.get("sub")))) {
            builder.subject(subject);
        }
        if (!CollectionUtils.isEmpty((Collection)(audience = (List)claims.get("aud")))) {
            builder.audience(audience);
        }
        if ((expiresAt = (Instant)claims.get("exp")) != null) {
            builder.expirationTime(Date.from(expiresAt));
        }
        if ((notBefore = (Instant)claims.get("nbf")) != null) {
            builder.notBeforeTime(Date.from(notBefore));
        }
        if ((issuedAt = (Instant)claims.get("iat")) != null) {
            builder.issueTime(Date.from(issuedAt));
        }
        if (StringUtils.hasText((String)(jwtId = (String)claims.get("jti")))) {
            builder.jwtID(jwtId);
        }
        HashMap<String, Object> customClaims = new HashMap<String, Object>();
        claims.forEach((name, value) -> {
            if (!JWTClaimsSet.getRegisteredNames().contains(name)) {
                customClaims.put((String)name, value);
            }
        });
        if (!customClaims.isEmpty()) {
            customClaims.forEach((arg_0, arg_1) -> ((JWTClaimsSet.Builder)builder).claim(arg_0, arg_1));
        }
        return builder.build();
    }
}

