/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.client.data;

import com.clickhouse.client.ClickHouseChecker;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.data.ClickHouseGeoPointValue;
import com.clickhouse.client.data.ClickHouseObjectValue;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class ClickHouseGeoRingValue
extends ClickHouseObjectValue<double[][]> {
    static final double[][] EMPTY_VALUE = new double[0][];

    public static ClickHouseGeoRingValue ofEmpty() {
        return ClickHouseGeoRingValue.of(null, EMPTY_VALUE);
    }

    public static ClickHouseGeoRingValue of(double[][] value) {
        return ClickHouseGeoRingValue.of(null, value);
    }

    public static ClickHouseGeoRingValue of(ClickHouseValue ref, double[][] value) {
        return ref instanceof ClickHouseGeoRingValue ? ((ClickHouseGeoRingValue)ref).set(value) : new ClickHouseGeoRingValue(value);
    }

    protected static double[][] check(double[][] value) {
        int len = ClickHouseChecker.nonNull(value, "Ring").length;
        for (int i = 0; i < len; ++i) {
            ClickHouseGeoPointValue.check(value[i]);
        }
        return value;
    }

    protected static String convert(double[][] value, int length) {
        StringBuilder builder = new StringBuilder().append('[');
        int len = value.length;
        for (int i = 0; i < len; ++i) {
            builder.append(ClickHouseGeoPointValue.convert(value[i], 0)).append(',');
        }
        if (builder.length() > 1) {
            builder.setLength(builder.length() - 1);
        }
        String str = builder.append(']').toString();
        return length > 0 ? ClickHouseChecker.notWithDifferentLength(str, length) : str;
    }

    protected ClickHouseGeoRingValue(double[][] value) {
        super(value);
    }

    protected ClickHouseGeoRingValue set(double[][] value) {
        super.set(ClickHouseGeoRingValue.check(value));
        return this;
    }

    @Override
    public ClickHouseGeoRingValue copy(boolean deep) {
        if (!deep) {
            return new ClickHouseGeoRingValue((double[][])this.getValue());
        }
        double[][] value = (double[][])this.getValue();
        double[][] newValue = new double[value.length][];
        int index = 0;
        for (double[] v : value) {
            newValue[index++] = Arrays.copyOf(v, v.length);
        }
        return new ClickHouseGeoRingValue(newValue);
    }

    @Override
    public Object[] asArray() {
        return (Object[])this.getValue();
    }

    @Override
    public <T> T[] asArray(Class<T> clazz) {
        double[][] v = (double[][])this.getValue();
        Object[] array = (Object[])Array.newInstance(ClickHouseChecker.nonNull(clazz, "Class"), v.length);
        int index = 0;
        for (double[] d : v) {
            array[index++] = clazz.cast(d);
        }
        return array;
    }

    @Override
    public <K, V> Map<K, V> asMap(Class<K> keyClass, Class<V> valueClass) {
        if (keyClass == null || valueClass == null) {
            throw new IllegalArgumentException("Non-null key and value classes are required");
        }
        LinkedHashMap<K, V> map = new LinkedHashMap<K, V>();
        int index = 1;
        for (double[] d : (double[][])this.getValue()) {
            map.put(keyClass.cast(index++), valueClass.cast(d));
        }
        return map;
    }

    @Override
    public String asString(int length, Charset charset) {
        return ClickHouseGeoRingValue.convert((double[][])this.getValue(), length);
    }

    @Override
    public boolean isNullOrEmpty() {
        double[][] value = (double[][])this.getValue();
        return value == null || value.length == 0;
    }

    @Override
    public ClickHouseGeoRingValue resetToNullOrEmpty() {
        this.set(EMPTY_VALUE);
        return this;
    }

    @Override
    public String toSqlExpression() {
        return ClickHouseGeoRingValue.convert((double[][])this.getValue(), 0);
    }

    @Override
    public ClickHouseGeoRingValue update(boolean value) {
        throw this.newUnsupportedException("boolean", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(boolean[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][]{{value[0] ? 1.0 : 0.0, value[1] ? 0.0 : 1.0}});
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(char value) {
        throw this.newUnsupportedException("char", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(char[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][]{{value[0], value[1]}});
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(byte value) {
        throw this.newUnsupportedException("byte", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(byte[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][]{{value[0], value[1]}});
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(short value) {
        throw this.newUnsupportedException("short", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(short[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][]{{value[0], value[1]}});
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(int value) {
        throw this.newUnsupportedException("int", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(int[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][]{{value[0], value[1]}});
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(long value) {
        throw this.newUnsupportedException("long", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(long[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][]{{value[0], value[1]}});
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(float value) {
        throw this.newUnsupportedException("float", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(float[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][]{{value[0], value[1]}});
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(double value) {
        throw this.newUnsupportedException("double", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(double[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + Arrays.toString(value));
        }
        this.set(new double[][]{value});
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(BigInteger value) {
        throw this.newUnsupportedException("BigInteger", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(BigDecimal value) {
        throw this.newUnsupportedException("BigDecimal", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(Enum<?> value) {
        throw this.newUnsupportedException("Enum", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(Inet4Address value) {
        throw this.newUnsupportedException("Inet4Address", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(Inet6Address value) {
        throw this.newUnsupportedException("Inet6Address", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(LocalDate value) {
        throw this.newUnsupportedException("Date", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(LocalTime value) {
        throw this.newUnsupportedException("Time", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(LocalDateTime value) {
        throw this.newUnsupportedException("DateTime", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(Collection<?> value) {
        if (value == null || value.size() != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Iterator<?> i = value.iterator();
        Object v1 = i.next();
        Object v2 = i.next();
        if (v1 instanceof Number) {
            this.set(new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}});
        } else {
            this.set(new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(Enumeration<?> value) {
        if (value == null || !value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v1 = value.nextElement();
        if (!value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v2 = value.nextElement();
        if (value.hasMoreElements()) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        if (v1 instanceof Number) {
            this.set(new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}});
        } else {
            this.set(new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(Map<?, ?> value) {
        if (value == null || value.size() != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Iterator<?> i = value.values().iterator();
        Object v1 = i.next();
        Object v2 = i.next();
        if (v1 instanceof Number) {
            this.set(new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}});
        } else {
            this.set(new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(String value) {
        throw this.newUnsupportedException("String", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(UUID value) {
        throw this.newUnsupportedException("UUID", "Ring");
    }

    @Override
    public ClickHouseGeoRingValue update(ClickHouseValue value) {
        if (value == null) {
            this.resetToNullOrEmpty();
        } else if (value instanceof ClickHouseGeoRingValue) {
            this.set((double[][])((ClickHouseGeoRingValue)value).getValue());
        } else {
            this.update(value.asArray());
        }
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(Object[] value) {
        if (value == null || value.length != 2) {
            throw new IllegalArgumentException("A point should have two and only two double values, but we got: " + value);
        }
        Object v1 = value[0];
        Object v2 = value[1];
        if (v1 instanceof Number) {
            this.set(new double[][]{{((Number)v1).doubleValue(), ((Number)v2).doubleValue()}});
        } else {
            this.set(new double[][]{{Double.parseDouble(v1.toString()), Double.parseDouble(v2.toString())}});
        }
        return this;
    }

    @Override
    public ClickHouseGeoRingValue update(Object value) {
        if (value instanceof double[][]) {
            this.set((double[][])value);
        } else {
            super.update(value);
        }
        return this;
    }
}

