/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.api.client;

import com.easy.query.core.api.SQLClientApiFactory;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.api.delete.ClientEntityDeletable;
import com.easy.query.core.basic.api.delete.ClientExpressionDeletable;
import com.easy.query.core.basic.api.flat.MapQueryable;
import com.easy.query.core.basic.api.flat.impl.DefaultMapQueryable;
import com.easy.query.core.basic.api.insert.ClientInsertable;
import com.easy.query.core.basic.api.insert.map.MapClientInsertable;
import com.easy.query.core.basic.api.select.ClientQueryable;
import com.easy.query.core.basic.api.select.executor.MapAble;
import com.easy.query.core.basic.api.update.ClientEntityUpdatable;
import com.easy.query.core.basic.api.update.ClientExpressionUpdatable;
import com.easy.query.core.basic.api.update.map.MapClientUpdatable;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.basic.extension.track.TrackManager;
import com.easy.query.core.basic.jdbc.conn.ConnectionManager;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.tx.Transaction;
import com.easy.query.core.common.IncludeRelationIdContext;
import com.easy.query.core.configuration.EasyQueryOption;
import com.easy.query.core.configuration.LoadIncludeConfiguration;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.include.IncludeProcessor;
import com.easy.query.core.expression.include.IncludeProcessorFactory;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.lambda.SQLFuncExpression;
import com.easy.query.core.expression.parser.core.base.WherePredicate;
import com.easy.query.core.expression.sql.include.DefaultIncludeParserResult;
import com.easy.query.core.expression.sql.include.IncludeParserResult;
import com.easy.query.core.expression.sql.include.RelationEntityImpl;
import com.easy.query.core.expression.sql.include.RelationExtraEntity;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyIncludeUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class DefaultEasyQueryClient
implements EasyQueryClient {
    private final QueryRuntimeContext runtimeContext;
    private final SQLClientApiFactory easySQLApiFactory;

    public DefaultEasyQueryClient(QueryRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
        this.easySQLApiFactory = runtimeContext.getSQLClientApiFactory();
    }

    @Override
    public QueryRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public <T> List<T> sqlEasyQuery(String sql, Class<T> clazz, List<SQLParameter> parameters) {
        return this.easySQLApiFactory.createJdbcExecutor(this.runtimeContext).sqlQuery(sql, clazz, parameters);
    }

    @Override
    public List<Map<String, Object>> sqlQueryMap(String sql, List<Object> parameters) {
        return this.easySQLApiFactory.createJdbcExecutor(this.runtimeContext).sqlQueryMap(sql, parameters);
    }

    @Override
    public long sqlExecute(String sql, List<Object> parameters) {
        return this.easySQLApiFactory.createJdbcExecutor(this.runtimeContext).sqlExecute(sql, parameters);
    }

    @Override
    public <T> ClientQueryable<T> queryable(Class<T> clazz) {
        return this.easySQLApiFactory.createQueryable(clazz, this.runtimeContext);
    }

    @Override
    public <T> ClientQueryable<T> queryable(String sql, Class<T> clazz, Collection<Object> sqlParams) {
        return this.easySQLApiFactory.createQueryable(sql, sqlParams, clazz, this.runtimeContext);
    }

    @Override
    public MapQueryable mapQueryable() {
        ClientQueryable<Map> queryable = this.easySQLApiFactory.createQueryable(Map.class, this.runtimeContext);
        return new DefaultMapQueryable((ClientQueryable)EasyObjectUtil.typeCastNullable(queryable));
    }

    @Override
    public MapQueryable mapQueryable(String sql) {
        ClientQueryable<Map> queryable = this.easySQLApiFactory.createQueryable(sql, Map.class, this.runtimeContext);
        return new DefaultMapQueryable((ClientQueryable)EasyObjectUtil.typeCastNullable(queryable));
    }

    @Override
    public Transaction beginTransaction(Integer isolationLevel) {
        ConnectionManager connectionManager = this.runtimeContext.getConnectionManager();
        return connectionManager.beginTransaction(isolationLevel);
    }

    @Override
    public <T> ClientInsertable<T> insertable(T entity) {
        if (entity == null) {
            return this.easySQLApiFactory.createEmptyInsertable(this.runtimeContext);
        }
        return this.easySQLApiFactory.createInsertable(entity.getClass(), this.runtimeContext).insert(entity);
    }

    @Override
    public <T> ClientInsertable<T> insertable(Collection<T> entities) {
        if (entities == null || entities.isEmpty()) {
            return this.easySQLApiFactory.createEmptyInsertable(this.runtimeContext);
        }
        return this.easySQLApiFactory.createInsertable(entities.iterator().next().getClass(), this.runtimeContext).insert((Collection)entities);
    }

    @Override
    public MapClientInsertable<Map<String, Object>> mapInsertable(Map<String, Object> map) {
        if (map == null) {
            return this.easySQLApiFactory.createEmptyMapInsertable(this.runtimeContext);
        }
        return this.easySQLApiFactory.createMapInsertable(this.runtimeContext).insert((Object)map);
    }

    @Override
    public MapClientInsertable<Map<String, Object>> mapInsertable(Collection<Map<String, Object>> maps) {
        if (maps == null || maps.isEmpty()) {
            return this.easySQLApiFactory.createEmptyMapInsertable(this.runtimeContext);
        }
        return this.easySQLApiFactory.createMapInsertable(this.runtimeContext).insert((Collection)maps);
    }

    @Override
    public <T> ClientExpressionUpdatable<T> updatable(Class<T> entityClass) {
        return this.easySQLApiFactory.createExpressionUpdatable(entityClass, this.runtimeContext);
    }

    @Override
    public <T> ClientEntityUpdatable<T> updatable(T entity) {
        if (entity == null) {
            return this.easySQLApiFactory.createEmptyEntityUpdatable();
        }
        return this.easySQLApiFactory.createEntityUpdatable(entity, this.runtimeContext);
    }

    @Override
    public <T> ClientEntityUpdatable<T> updatable(Collection<T> entities) {
        if (entities == null || entities.isEmpty()) {
            return this.easySQLApiFactory.createEmptyEntityUpdatable();
        }
        return this.easySQLApiFactory.createEntityUpdatable(entities, this.runtimeContext);
    }

    @Override
    public MapClientUpdatable<Map<String, Object>> mapUpdatable(Map<String, Object> map) {
        if (map == null) {
            return this.easySQLApiFactory.createEmptyMapUpdatable();
        }
        return this.easySQLApiFactory.createMapUpdatable(map, this.runtimeContext);
    }

    @Override
    public MapClientUpdatable<Map<String, Object>> mapUpdatable(Collection<Map<String, Object>> maps) {
        if (maps == null || maps.isEmpty()) {
            return this.easySQLApiFactory.createEmptyMapUpdatable();
        }
        return this.easySQLApiFactory.createMapUpdatable(maps, this.runtimeContext);
    }

    @Override
    public <T> ClientEntityDeletable<T> deletable(T entity) {
        if (entity == null) {
            return this.easySQLApiFactory.createEmptyEntityDeletable();
        }
        return this.easySQLApiFactory.createEntityDeletable(entity, this.runtimeContext);
    }

    @Override
    public <T> ClientEntityDeletable<T> deletable(Collection<T> entities) {
        if (entities == null || entities.isEmpty()) {
            return this.easySQLApiFactory.createEmptyEntityDeletable();
        }
        return this.easySQLApiFactory.createEntityDeletable(entities, this.runtimeContext);
    }

    @Override
    public <T> ClientExpressionDeletable<T> deletable(Class<T> entityClass) {
        return this.easySQLApiFactory.createExpressionDeletable(entityClass, this.runtimeContext);
    }

    @Override
    public boolean addTracking(Object entity) {
        TrackManager trackManager = this.runtimeContext.getTrackManager();
        TrackContext currentTrackContext = trackManager.getCurrentTrackContext();
        if (currentTrackContext != null) {
            return currentTrackContext.addTracking(entity);
        }
        return false;
    }

    @Override
    public boolean removeTracking(Object entity) {
        TrackManager trackManager = this.runtimeContext.getTrackManager();
        TrackContext currentTrackContext = trackManager.getCurrentTrackContext();
        if (currentTrackContext != null) {
            return currentTrackContext.removeTracking(entity);
        }
        return false;
    }

    @Override
    public EntityState getTrackEntityStateNotNull(Object entity) {
        TrackManager trackManager = this.runtimeContext.getTrackManager();
        TrackContext currentTrackContext = trackManager.getCurrentTrackContext();
        if (currentTrackContext == null) {
            throw new EasyQueryInvalidOperationException("currentTrackContext can not be null ");
        }
        return currentTrackContext.getTrackEntityStateNotNull(entity);
    }

    private <T> IncludeParserResult getIncludeParserResult(List<T> entities, NavigateMetadata navigateMetadata, LoadIncludeConfiguration loadIncludeConfiguration) {
        RelationTypeEnum relationType = navigateMetadata.getRelationType();
        ColumnMetadata columnMetadata = navigateMetadata.getEntityMetadata().getColumnNotNull(navigateMetadata.getSelfPropertyOrPrimary());
        Property<Object, ?> getter = columnMetadata.getGetterCaller();
        List relationIds = entities.stream().map(o -> getter.apply(o)).filter(o -> o != null).distinct().collect(Collectors.toList());
        IncludeRelationIdContext includeRelationIdContext = new IncludeRelationIdContext();
        EasyQueryOption easyQueryOption = this.runtimeContext.getQueryConfiguration().getEasyQueryOption();
        Integer groupSize = loadIncludeConfiguration.getGroupSize();
        int queryRelationGroupSize = groupSize == null ? easyQueryOption.getRelationGroupSize() : groupSize.intValue();
        List<Map<String, Object>> mappingRows = null;
        if (RelationTypeEnum.ManyToMany == relationType) {
            ClientQueryable mappingQueryable = this.queryable(navigateMetadata.getMappingClass()).where(o -> {
                o.in(navigateMetadata.getSelfMappingProperty(), includeRelationIdContext.getRelationIds());
                navigateMetadata.predicateFilterApply((WherePredicate<?>)o);
            }).select(o -> o.column(navigateMetadata.getSelfMappingProperty()).column(navigateMetadata.getTargetMappingProperty()));
            mappingRows = EasyIncludeUtil.queryableGroupExecute(queryRelationGroupSize, mappingQueryable, includeRelationIdContext, relationIds, MapAble::toMaps);
            EntityMetadata mappingEntityMetadata = this.runtimeContext.getEntityMetadataManager().getEntityMetadata(navigateMetadata.getMappingClass());
            ColumnMetadata mappingTargetColumnMetadata = mappingEntityMetadata.getColumnNotNull(navigateMetadata.getTargetMappingProperty());
            String targetColumnName = mappingTargetColumnMetadata.getName();
            List targetIds = mappingRows.stream().map(o -> o.get(targetColumnName)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            relationIds.clear();
            relationIds.addAll(targetIds);
        }
        SQLFuncExpression<ClientQueryable<?>> includeQueryableExpression = this.createIncludeQueryableExpression(includeRelationIdContext, navigateMetadata, loadIncludeConfiguration);
        List entityResult = EasyIncludeUtil.queryableExpressionGroupExecute(queryRelationGroupSize, includeQueryableExpression, includeRelationIdContext, relationIds, q -> q.toList());
        EntityMetadata entityMetadata = this.runtimeContext.getEntityMetadataManager().getEntityMetadata(navigateMetadata.getNavigatePropertyType());
        List<RelationExtraEntity> includeResult = entityResult.stream().map(o -> new RelationEntityImpl(o, entityMetadata)).collect(Collectors.toList());
        List<RelationExtraEntity> relationExtraEntities = entities.stream().map(o -> new RelationEntityImpl(o, navigateMetadata.getEntityMetadata())).collect(Collectors.toList());
        return new DefaultIncludeParserResult(entityMetadata, relationExtraEntities, navigateMetadata.getRelationType(), navigateMetadata.getPropertyName(), navigateMetadata.getNavigateOriginalPropertyType(), navigateMetadata.getNavigatePropertyType(), navigateMetadata.getSelfPropertyOrPrimary(), navigateMetadata.getTargetPropertyOrPrimary(this.runtimeContext), navigateMetadata.getMappingClass(), navigateMetadata.getSelfMappingProperty(), navigateMetadata.getTargetMappingProperty(), includeResult, mappingRows, navigateMetadata.getSetter(), null, null);
    }

    private SQLFuncExpression<ClientQueryable<?>> createIncludeQueryableExpression(IncludeRelationIdContext includeRelationIdContext, NavigateMetadata navigateMetadata, LoadIncludeConfiguration loadIncludeConfiguration) {
        Class<?> navigatePropertyType = navigateMetadata.getNavigatePropertyType();
        ClientQueryable queryable = this.runtimeContext.getSQLClientApiFactory().createQueryable((Class)EasyObjectUtil.typeCastNullable(navigatePropertyType), this.runtimeContext);
        Boolean tracking = loadIncludeConfiguration.getTracking();
        if (tracking != null) {
            if (tracking.booleanValue()) {
                queryable.asTracking();
            } else {
                queryable.asNoTracking();
            }
        }
        SQLFuncExpression<ClientQueryable<?>> queryableExpression = () -> {
            List<Object> relationIds = includeRelationIdContext.getRelationIds();
            return queryable.cloneQueryable().where(o -> o.and(() -> {
                o.in(navigateMetadata.getTargetPropertyOrPrimary(this.runtimeContext), relationIds);
                if (navigateMetadata.getRelationType() != RelationTypeEnum.ManyToMany) {
                    navigateMetadata.predicateFilterApply((WherePredicate<?>)o);
                }
            }));
        };
        return queryableExpression;
    }

    @Override
    public <T> void loadInclude(List<T> entities, String navigateProperty, SQLExpression1<LoadIncludeConfiguration> configure) {
        if (EasyCollectionUtil.isEmpty(entities)) {
            return;
        }
        T first = EasyCollectionUtil.first(entities);
        Class<?> firstClass = first.getClass();
        EntityMetadataManager entityMetadataManager = this.runtimeContext.getEntityMetadataManager();
        EntityMetadata entityMetadata = entityMetadataManager.getEntityMetadata(firstClass);
        NavigateMetadata navigateMetadata = entityMetadata.getNavigateNotNull(navigateProperty);
        LoadIncludeConfiguration loadIncludeConfiguration = new LoadIncludeConfiguration();
        if (configure != null) {
            configure.apply(loadIncludeConfiguration);
        }
        IncludeParserResult includeParserResult = this.getIncludeParserResult(entities, navigateMetadata, loadIncludeConfiguration);
        IncludeProcessorFactory includeProcessorFactory = this.runtimeContext.getIncludeProcessorFactory();
        IncludeProcessor includeProcess = includeProcessorFactory.createIncludeProcess(includeParserResult, this.runtimeContext);
        includeProcess.process();
    }
}

