/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.api.client;

import com.easy.query.core.basic.api.delete.ClientEntityDeletable;
import com.easy.query.core.basic.api.delete.ClientExpressionDeletable;
import com.easy.query.core.basic.api.flat.MapQueryable;
import com.easy.query.core.basic.api.insert.ClientInsertable;
import com.easy.query.core.basic.api.insert.map.MapClientInsertable;
import com.easy.query.core.basic.api.select.ClientQueryable;
import com.easy.query.core.basic.api.update.ClientEntityUpdatable;
import com.easy.query.core.basic.api.update.ClientExpressionUpdatable;
import com.easy.query.core.basic.api.update.map.MapClientUpdatable;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.jdbc.parameter.EasyConstSQLParameter;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.tx.Transaction;
import com.easy.query.core.configuration.LoadIncludeConfiguration;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public interface EasyQueryClient {
    public QueryRuntimeContext getRuntimeContext();

    default public <T> List<T> sqlQuery(String sql, Class<T> clazz) {
        return this.sqlQuery(sql, clazz, Collections.emptyList());
    }

    default public <T> List<T> sqlQuery(String sql, Class<T> clazz, List<Object> parameters) {
        List<SQLParameter> sqlParameters = EasyCollectionUtil.map(parameters, o -> new EasyConstSQLParameter(null, null, o));
        return this.sqlEasyQuery(sql, clazz, sqlParameters);
    }

    public <T> List<T> sqlEasyQuery(String var1, Class<T> var2, List<SQLParameter> var3);

    default public List<Map<String, Object>> sqlQueryMap(String sql) {
        return this.sqlQueryMap(sql, Collections.emptyList());
    }

    public List<Map<String, Object>> sqlQueryMap(String var1, List<Object> var2);

    default public long sqlExecute(String sql) {
        return this.sqlExecute(sql, Collections.emptyList());
    }

    public long sqlExecute(String var1, List<Object> var2);

    public <T> ClientQueryable<T> queryable(Class<T> var1);

    default public ClientQueryable<Map<String, Object>> queryable(String tableName) {
        return (ClientQueryable)EasyObjectUtil.typeCastNullable(this.queryable(Map.class).asTable(tableName));
    }

    public MapQueryable mapQueryable();

    public MapQueryable mapQueryable(String var1);

    default public <T> ClientQueryable<T> queryable(String sql, Class<T> clazz) {
        return this.queryable(sql, clazz, Collections.emptyList());
    }

    public <T> ClientQueryable<T> queryable(String var1, Class<T> var2, Collection<Object> var3);

    default public Transaction beginTransaction() {
        return this.beginTransaction(null);
    }

    public Transaction beginTransaction(Integer var1);

    public <T> ClientInsertable<T> insertable(T var1);

    public <T> ClientInsertable<T> insertable(Collection<T> var1);

    public <T> ClientExpressionUpdatable<T> updatable(Class<T> var1);

    public <T> ClientEntityUpdatable<T> updatable(T var1);

    public <T> ClientEntityUpdatable<T> updatable(Collection<T> var1);

    public <T> ClientEntityDeletable<T> deletable(T var1);

    public <T> ClientEntityDeletable<T> deletable(Collection<T> var1);

    public <T> ClientExpressionDeletable<T> deletable(Class<T> var1);

    public boolean addTracking(Object var1);

    public boolean removeTracking(Object var1);

    public EntityState getTrackEntityStateNotNull(Object var1);

    public MapClientInsertable<Map<String, Object>> mapInsertable(Map<String, Object> var1);

    public MapClientInsertable<Map<String, Object>> mapInsertable(Collection<Map<String, Object>> var1);

    public MapClientUpdatable<Map<String, Object>> mapUpdatable(Map<String, Object> var1);

    public MapClientUpdatable<Map<String, Object>> mapUpdatable(Collection<Map<String, Object>> var1);

    default public <T> void loadInclude(T entity, String navigateProperty) {
        this.loadInclude(Collections.singletonList(entity), navigateProperty);
    }

    default public <T> void loadInclude(T entity, String navigateProperty, SQLExpression1<LoadIncludeConfiguration> configure) {
        this.loadInclude(Collections.singletonList(entity), navigateProperty, configure);
    }

    default public <T> void loadInclude(List<T> entities, String navigateProperty) {
        this.loadInclude(entities, navigateProperty, (SQLExpression1<LoadIncludeConfiguration>)null);
    }

    public <T> void loadInclude(List<T> var1, String var2, SQLExpression1<LoadIncludeConfiguration> var3);
}

