/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.api.insert;

import com.easy.query.core.basic.api.insert.ClientInsertable;
import com.easy.query.core.basic.extension.generated.PrimaryKeyGenerator;
import com.easy.query.core.basic.extension.interceptor.EntityInterceptor;
import com.easy.query.core.basic.extension.interceptor.Interceptor;
import com.easy.query.core.basic.jdbc.executor.EntityExpressionExecutor;
import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.parameter.DefaultToSQLContext;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.enums.ExecuteMethodEnum;
import com.easy.query.core.enums.MultiTableTypeEnum;
import com.easy.query.core.enums.SQLExecuteStrategyEnum;
import com.easy.query.core.expression.builder.impl.ConfigurerImpl;
import com.easy.query.core.expression.builder.impl.OnlySelectorImpl;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.base.ColumnConfigurer;
import com.easy.query.core.expression.parser.core.base.ColumnOnlySelector;
import com.easy.query.core.expression.parser.core.base.impl.ColumnConfigurerImpl;
import com.easy.query.core.expression.parser.core.base.impl.ColumnOnlySelectorImpl;
import com.easy.query.core.expression.sql.builder.EntityInsertExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.internal.EasyBehavior;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import com.easy.query.core.util.EasySQLSegmentUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AbstractClientInsertable<T>
implements ClientInsertable<T> {
    protected final List<T> entities;
    protected final EntityMetadata entityMetadata;
    protected final EntityInsertExpressionBuilder entityInsertExpressionBuilder;
    protected final EntityTableExpressionBuilder entityTableExpressionBuilder;

    public AbstractClientInsertable(Class<T> clazz, EntityInsertExpressionBuilder entityInsertExpressionBuilder) {
        this.entityInsertExpressionBuilder = entityInsertExpressionBuilder;
        this.entities = new ArrayList<T>();
        QueryRuntimeContext runtimeContext = entityInsertExpressionBuilder.getRuntimeContext();
        this.entityMetadata = runtimeContext.getEntityMetadataManager().getEntityMetadata(clazz);
        this.entityMetadata.checkTable();
        this.entityTableExpressionBuilder = runtimeContext.getExpressionBuilderFactory().createEntityTableExpressionBuilder(this.entityMetadata, MultiTableTypeEnum.NONE, runtimeContext);
        this.entityInsertExpressionBuilder.addSQLEntityTableExpression(this.entityTableExpressionBuilder);
    }

    @Override
    public EntityInsertExpressionBuilder getEntityInsertExpressionBuilder() {
        return this.entityInsertExpressionBuilder;
    }

    @Override
    public ClientInsertable<T> insert(T entity) {
        if (entity != null) {
            this.entities.add(entity);
        }
        return this;
    }

    private List<EntityInterceptor> getEntityInterceptors() {
        List<EntityInterceptor> insertInterceptors = this.entityMetadata.getEntityInterceptors();
        if (EasyCollectionUtil.isNotEmpty(insertInterceptors)) {
            Predicate<Interceptor> interceptorFilter = this.entityInsertExpressionBuilder.getExpressionContext().getInterceptorFilter();
            return EasyCollectionUtil.filter(insertInterceptors, interceptorFilter::test);
        }
        return Collections.emptyList();
    }

    private List<ColumnMetadata> getKeyColumnMetadataList(EntityMetadata entityMetadata) {
        if (entityMetadata.isHasPrimaryKeyGenerator()) {
            Collection<String> keyProperties = entityMetadata.getKeyProperties();
            ArrayList<ColumnMetadata> result = new ArrayList<ColumnMetadata>(keyProperties.size());
            for (String keyProperty : keyProperties) {
                ColumnMetadata columnMetadata = entityMetadata.getColumnNotNull(keyProperty);
                PrimaryKeyGenerator primaryKeyGenerator = columnMetadata.getPrimaryKeyGenerator();
                if (primaryKeyGenerator == null) continue;
                result.add(columnMetadata);
            }
            return result;
        }
        return Collections.emptyList();
    }

    protected void insertBefore() {
        boolean hasPrimaryKeyGenerator = this.entityMetadata.isHasPrimaryKeyGenerator();
        List<EntityInterceptor> entityInterceptors = this.getEntityInterceptors();
        boolean hasInterceptor = EasyCollectionUtil.isNotEmpty(entityInterceptors);
        if (hasPrimaryKeyGenerator || hasInterceptor) {
            Class<?> entityClass = this.entityMetadata.getEntityClass();
            List<ColumnMetadata> keyColumnMetadataList = this.getKeyColumnMetadataList(this.entityMetadata);
            for (T entity : this.entities) {
                if (hasPrimaryKeyGenerator) {
                    for (ColumnMetadata columnMetadata : keyColumnMetadataList) {
                        columnMetadata.getPrimaryKeyGenerator().setPrimaryKey(entity, columnMetadata);
                    }
                }
                if (!hasInterceptor) continue;
                for (EntityInterceptor entityInterceptor : entityInterceptors) {
                    entityInterceptor.configureInsert(entityClass, this.entityInsertExpressionBuilder, entity);
                }
            }
        }
    }

    @Override
    public long executeRows(boolean fillAutoIncrement) {
        if (!this.entities.isEmpty()) {
            this.insertBefore();
            EntityExpressionExecutor entityExpressionExecutor = this.entityInsertExpressionBuilder.getRuntimeContext().getEntityExpressionExecutor();
            return entityExpressionExecutor.insert(ExecutorContext.create(this.entityInsertExpressionBuilder.getExpressionContext(), false, ExecuteMethodEnum.INSERT), this.entities, this.entityInsertExpressionBuilder, fillAutoIncrement);
        }
        return 0L;
    }

    @Override
    public ClientInsertable<T> asTable(Function<String, String> tableNameAs) {
        this.entityInsertExpressionBuilder.getRecentlyTable().setTableNameAs(tableNameAs);
        return this;
    }

    @Override
    public ClientInsertable<T> asSchema(Function<String, String> schemaAs) {
        this.entityInsertExpressionBuilder.getRecentlyTable().setSchemaAs(schemaAs);
        return this;
    }

    @Override
    public ClientInsertable<T> asAlias(String alias) {
        this.entityInsertExpressionBuilder.getRecentlyTable().asAlias(alias);
        return this;
    }

    @Override
    public ClientInsertable<T> asTableLink(Function<String, String> linkAs) {
        this.entityInsertExpressionBuilder.getRecentlyTable().setTableLinkAs(linkAs);
        return this;
    }

    @Override
    public ClientInsertable<T> noInterceptor() {
        this.entityInsertExpressionBuilder.getExpressionContext().noInterceptor();
        return this;
    }

    @Override
    public ClientInsertable<T> useInterceptor(String name) {
        this.entityInsertExpressionBuilder.getExpressionContext().useInterceptor(name);
        return this;
    }

    @Override
    public ClientInsertable<T> noInterceptor(String name) {
        this.entityInsertExpressionBuilder.getExpressionContext().noInterceptor(name);
        return this;
    }

    @Override
    public ClientInsertable<T> useInterceptor() {
        this.entityInsertExpressionBuilder.getExpressionContext().useInterceptor();
        return this;
    }

    @Override
    public ClientInsertable<T> setSQLStrategy(boolean condition, SQLExecuteStrategyEnum sqlStrategy) {
        if (condition) {
            this.entityInsertExpressionBuilder.getExpressionContext().useSQLStrategy(sqlStrategy);
        }
        return this;
    }

    @Override
    public ClientInsertable<T> onDuplicateKeyIgnore() {
        this.insertOrIgnoreBehavior();
        return this;
    }

    @Override
    public ClientInsertable<T> onConflictThen(SQLExpression1<ColumnOnlySelector<T>> updateSetSelector, Collection<String> constraintProperties) {
        this.onConflictThen0(constraintProperties, updateSetSelector);
        return this;
    }

    private void insertOrIgnoreBehavior() {
        this.entityInsertExpressionBuilder.getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.ON_DUPLICATE_KEY_UPDATE);
        this.entityInsertExpressionBuilder.getExpressionContext().getBehavior().addBehavior(EasyBehaviorEnum.ON_DUPLICATE_KEY_IGNORE);
    }

    private void insertOrUpdateBehavior() {
        this.entityInsertExpressionBuilder.getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.ON_DUPLICATE_KEY_IGNORE);
        this.entityInsertExpressionBuilder.getExpressionContext().getBehavior().addBehavior(EasyBehaviorEnum.ON_DUPLICATE_KEY_UPDATE);
    }

    @Override
    public ClientInsertable<T> onConflictDoUpdate() {
        this.onConflictThen0(null, x -> x.columnAll());
        return this;
    }

    @Override
    public ClientInsertable<T> onConflictDoUpdate(Collection<String> constraintProperties, SQLExpression1<ColumnOnlySelector<T>> setColumnSelector) {
        this.onConflictThen0(constraintProperties, setColumnSelector);
        return this;
    }

    @Override
    public ClientInsertable<T> onConflictDoUpdate(Collection<String> constraintProperties) {
        this.onConflictThen0(constraintProperties, x -> x.columnAll());
        return this;
    }

    @Override
    public ClientInsertable<T> behaviorConfigure(SQLExpression1<EasyBehavior> configure) {
        if (configure != null) {
            configure.apply(this.entityInsertExpressionBuilder.getExpressionContext().getBehavior());
        }
        return this;
    }

    @Override
    public ClientInsertable<T> onConflictDoUpdate(SQLExpression1<ColumnOnlySelector<T>> setColumnSelector) {
        this.onConflictThen0(null, setColumnSelector);
        return this;
    }

    @Override
    public ClientInsertable<T> onDuplicateKeyUpdate() {
        this.onConflictThen0(null, x -> x.columnAll());
        return this;
    }

    @Override
    public ClientInsertable<T> onDuplicateKeyUpdate(SQLExpression1<ColumnOnlySelector<T>> setColumnSelector) {
        this.onConflictThen0(null, setColumnSelector);
        return this;
    }

    private void onConflictThen0(Collection<String> constraintProperties, SQLExpression1<ColumnOnlySelector<T>> setColumnSelector) {
        if (EasyCollectionUtil.isNotEmpty(constraintProperties)) {
            for (String constraintProperty : constraintProperties) {
                this.entityInsertExpressionBuilder.addDuplicateKey(constraintProperty);
            }
        }
        this.entityInsertExpressionBuilder.getDuplicateKeyUpdateColumns().clear();
        if (setColumnSelector != null) {
            ColumnOnlySelectorImpl columnUpdateSetSelector = new ColumnOnlySelectorImpl(this.entityTableExpressionBuilder.getEntityTable(), new OnlySelectorImpl(this.entityInsertExpressionBuilder.getRuntimeContext(), this.entityInsertExpressionBuilder.getExpressionContext(), this.entityInsertExpressionBuilder.getDuplicateKeyUpdateColumns()));
            setColumnSelector.apply(columnUpdateSetSelector);
            if (EasySQLSegmentUtil.isNotEmpty(this.entityInsertExpressionBuilder.getDuplicateKeyUpdateColumns())) {
                this.insertOrUpdateBehavior();
            } else {
                this.insertOrIgnoreBehavior();
            }
        } else {
            this.insertOrIgnoreBehavior();
        }
    }

    @Override
    public ClientInsertable<T> batch(boolean use) {
        if (use) {
            this.entityInsertExpressionBuilder.getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.EXECUTE_NO_BATCH);
            this.entityInsertExpressionBuilder.getExpressionContext().getBehavior().addBehavior(EasyBehaviorEnum.EXECUTE_BATCH);
        } else {
            this.entityInsertExpressionBuilder.getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.EXECUTE_BATCH);
            this.entityInsertExpressionBuilder.getExpressionContext().getBehavior().addBehavior(EasyBehaviorEnum.EXECUTE_NO_BATCH);
        }
        return this;
    }

    @Override
    public ClientInsertable<T> columnConfigure(SQLExpression1<ColumnConfigurer<T>> columnConfigureExpression) {
        columnConfigureExpression.apply(new ColumnConfigurerImpl(this.entityTableExpressionBuilder.getEntityTable(), new ConfigurerImpl(this.entityInsertExpressionBuilder)));
        return this;
    }

    @Override
    public String toSQL(T entity) {
        return this.toSQL(entity, DefaultToSQLContext.defaultToSQLContext(this.entityInsertExpressionBuilder.getExpressionContext().getTableContext(), false));
    }

    @Override
    public String toSQL(T entity, ToSQLContext toSQLContext) {
        return this.toSQLWithParam(entity, toSQLContext);
    }

    private String toSQLWithParam(T entity, ToSQLContext toSQLContext) {
        return this.entityInsertExpressionBuilder.toExpression(entity).toSQL(toSQLContext);
    }
}

