/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.api.select.executor;

import com.easy.query.core.annotation.NotNull;
import com.easy.query.core.basic.api.select.QueryAvailable;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.JdbcStreamResult;
import com.easy.query.core.expression.lambda.SQLConsumer;
import java.sql.Statement;
import java.util.function.Function;
import java.util.stream.Stream;

public interface StreamAble<T>
extends QueryAvailable<T> {
    @NotNull
    default public JdbcStreamResult<T> toStreamResult(Integer fetchSize) {
        return this.toStreamResult((Statement s) -> {
            if (fetchSize != null) {
                s.setFetchSize(fetchSize);
            }
        });
    }

    @NotNull
    public JdbcStreamResult<T> toStreamResult(SQLConsumer<Statement> var1);

    default public <TR> TR streamBy(Function<Stream<T>, TR> fetcher) {
        return this.streamBy(fetcher, Integer.MAX_VALUE);
    }

    default public <TR> TR streamBy(Function<Stream<T>, TR> fetcher, Integer fetchSize) {
        return this.streamBy(fetcher, (Statement statement) -> statement.setFetchSize(fetchSize));
    }

    public <TR> TR streamBy(Function<Stream<T>, TR> var1, SQLConsumer<Statement> var2);
}

