/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.api.update.abstraction;

import com.easy.query.core.basic.api.internal.AbstractSQLExecuteRows;
import com.easy.query.core.basic.api.update.ClientEntityUpdatable;
import com.easy.query.core.basic.extension.interceptor.EntityInterceptor;
import com.easy.query.core.basic.extension.interceptor.Interceptor;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.basic.extension.track.TrackManager;
import com.easy.query.core.basic.jdbc.executor.EntityExpressionExecutor;
import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.parameter.DefaultToSQLContext;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.EasyBehaviorEnum;
import com.easy.query.core.enums.ExecuteMethodEnum;
import com.easy.query.core.enums.MultiTableTypeEnum;
import com.easy.query.core.enums.SQLExecuteStrategyEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.expression.builder.impl.ConfigurerImpl;
import com.easy.query.core.expression.builder.impl.OnlySelectorImpl;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.base.ColumnConfigurer;
import com.easy.query.core.expression.parser.core.base.ColumnOnlySelector;
import com.easy.query.core.expression.parser.core.base.impl.ColumnConfigurerImpl;
import com.easy.query.core.expression.parser.core.base.impl.ColumnOnlySelectorImpl;
import com.easy.query.core.expression.sql.builder.EntityTableExpressionBuilder;
import com.easy.query.core.expression.sql.builder.EntityUpdateExpressionBuilder;
import com.easy.query.core.expression.sql.builder.internal.EasyBehavior;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class AbstractClientEntityUpdatable<T>
extends AbstractSQLExecuteRows<ClientEntityUpdatable<T>>
implements ClientEntityUpdatable<T> {
    protected final List<T> entities;
    protected final EntityTableExpressionBuilder table;
    protected final EntityMetadata entityMetadata;
    protected final EntityUpdateExpressionBuilder entityUpdateExpressionBuilder;

    public AbstractClientEntityUpdatable(Class<T> clazz, Collection<T> entities, EntityUpdateExpressionBuilder entityUpdateExpression) {
        super(entityUpdateExpression);
        if (entities == null || entities.isEmpty()) {
            throw new EasyQueryException("\u4e0d\u652f\u6301\u7a7a\u5bf9\u8c61\u7684update");
        }
        this.entities = new ArrayList<T>(entities);
        this.entityUpdateExpressionBuilder = entityUpdateExpression;
        QueryRuntimeContext runtimeContext = this.entityUpdateExpressionBuilder.getRuntimeContext();
        this.entityMetadata = runtimeContext.getEntityMetadataManager().getEntityMetadata(clazz);
        this.entityMetadata.checkTable();
        this.table = runtimeContext.getExpressionBuilderFactory().createEntityTableExpressionBuilder(this.entityMetadata, MultiTableTypeEnum.NONE, runtimeContext);
        this.entityUpdateExpressionBuilder.addSQLEntityTableExpression(this.table);
    }

    @Override
    public EntityUpdateExpressionBuilder getUpdateExpressionBuilder() {
        return this.entityUpdateExpressionBuilder;
    }

    @Override
    public long executeRows() {
        if (EasyCollectionUtil.isNotEmpty(this.entities)) {
            List<Object> trackEntities = this.configureUpdateAndGetTrackEntities();
            EntityExpressionExecutor entityExpressionExecutor = this.entityUpdateExpressionBuilder.getRuntimeContext().getEntityExpressionExecutor();
            long executeRows = entityExpressionExecutor.executeRows(ExecutorContext.create(this.entityUpdateExpressionBuilder.getExpressionContext(), false, ExecuteMethodEnum.UPDATE), this.entityUpdateExpressionBuilder, this.entities);
            this.removeTrackEntities(trackEntities);
            return executeRows;
        }
        return 0L;
    }

    protected void removeTrackEntities(List<Object> trackEntities) {
        TrackContext trackContext;
        if (EasyCollectionUtil.isNotEmpty(trackEntities) && (trackContext = this.getTrackContextOrNull()) != null) {
            for (Object trackEntity : trackEntities) {
                trackContext.removeTracking(trackEntity);
            }
        }
    }

    protected TrackContext getTrackContextOrNull() {
        QueryRuntimeContext runtimeContext = this.entityUpdateExpressionBuilder.getRuntimeContext();
        TrackManager trackManager = runtimeContext.getTrackManager();
        return trackManager.currentThreadTracking() ? trackManager.getCurrentTrackContext() : null;
    }

    protected List<Object> configureUpdateAndGetTrackEntities() {
        List<EntityInterceptor> entityInterceptors = this.getEntityInterceptors();
        Class<?> entityClass = this.entityMetadata.getEntityClass();
        TrackContext trackContext = this.getTrackContextOrNull();
        LinkedList<Object> trackEntities = new LinkedList<Object>();
        if (EasyCollectionUtil.isNotEmpty(entityInterceptors) || trackContext != null) {
            for (T entity : this.entities) {
                for (EntityInterceptor entityInterceptor : entityInterceptors) {
                    entityInterceptor.configureUpdate(entityClass, this.entityUpdateExpressionBuilder, entity);
                }
                if (trackContext == null || !trackContext.isTrack(entity)) continue;
                trackEntities.add(entity);
            }
        }
        return trackEntities;
    }

    protected List<EntityInterceptor> getEntityInterceptors() {
        List<EntityInterceptor> entityInterceptors = this.entityMetadata.getEntityInterceptors();
        if (EasyCollectionUtil.isNotEmpty(entityInterceptors)) {
            Predicate<Interceptor> interceptorFilter = this.entityUpdateExpressionBuilder.getExpressionContext().getInterceptorFilter();
            return EasyCollectionUtil.filter(entityInterceptors, interceptorFilter::test);
        }
        return Collections.emptyList();
    }

    @Override
    public ClientEntityUpdatable<T> setColumns(boolean condition, SQLExpression1<ColumnOnlySelector<T>> columnSelectorExpression) {
        if (condition) {
            ColumnOnlySelectorImpl columnSelector = new ColumnOnlySelectorImpl(this.table.getEntityTable(), new OnlySelectorImpl(this.entityUpdateExpressionBuilder.getRuntimeContext(), this.entityUpdateExpressionBuilder.getExpressionContext(), this.entityUpdateExpressionBuilder.getSetColumns()));
            columnSelectorExpression.apply(columnSelector);
        }
        return this;
    }

    @Override
    public ClientEntityUpdatable<T> setIgnoreColumns(boolean condition, SQLExpression1<ColumnOnlySelector<T>> columnSelectorExpression) {
        if (condition) {
            ColumnOnlySelectorImpl columnSelector = new ColumnOnlySelectorImpl(this.table.getEntityTable(), new OnlySelectorImpl(this.entityUpdateExpressionBuilder.getRuntimeContext(), this.entityUpdateExpressionBuilder.getExpressionContext(), this.entityUpdateExpressionBuilder.getSetIgnoreColumns()));
            columnSelectorExpression.apply(columnSelector);
        }
        return this;
    }

    @Override
    public ClientEntityUpdatable<T> whereColumns(boolean condition, SQLExpression1<ColumnOnlySelector<T>> columnSelectorExpression) {
        if (condition) {
            ColumnOnlySelectorImpl columnSelector = new ColumnOnlySelectorImpl(this.table.getEntityTable(), new OnlySelectorImpl(this.entityUpdateExpressionBuilder.getRuntimeContext(), this.entityUpdateExpressionBuilder.getExpressionContext(), this.entityUpdateExpressionBuilder.getWhereColumns()));
            columnSelectorExpression.apply(columnSelector);
        }
        return this;
    }

    @Override
    public ClientEntityUpdatable<T> columnConfigure(SQLExpression1<ColumnConfigurer<T>> columnConfigureExpression) {
        ColumnConfigurerImpl columnConfigurer = new ColumnConfigurerImpl(this.table.getEntityTable(), new ConfigurerImpl(this.entityUpdateExpressionBuilder));
        columnConfigureExpression.apply(columnConfigurer);
        return this;
    }

    @Override
    public ClientEntityUpdatable<T> asTable(Function<String, String> tableNameAs) {
        this.entityUpdateExpressionBuilder.getRecentlyTable().setTableNameAs(tableNameAs);
        return this;
    }

    @Override
    public ClientEntityUpdatable<T> asSchema(Function<String, String> schemaAs) {
        this.entityUpdateExpressionBuilder.getRecentlyTable().setSchemaAs(schemaAs);
        return this;
    }

    @Override
    public ClientEntityUpdatable<T> asAlias(String alias) {
        this.entityUpdateExpressionBuilder.getRecentlyTable().asAlias(alias);
        return this;
    }

    @Override
    public ClientEntityUpdatable<T> asTableLink(Function<String, String> linkAs) {
        this.entityUpdateExpressionBuilder.getRecentlyTable().setTableLinkAs(linkAs);
        return this;
    }

    @Override
    public ClientEntityUpdatable<T> behaviorConfigure(SQLExpression1<EasyBehavior> configure) {
        if (configure != null) {
            configure.apply(this.entityUpdateExpressionBuilder.getExpressionContext().getBehavior());
        }
        return this;
    }

    @Override
    public ClientEntityUpdatable<T> setSQLStrategy(boolean condition, SQLExecuteStrategyEnum sqlStrategy) {
        if (condition) {
            this.entityUpdateExpressionBuilder.getExpressionContext().useSQLStrategy(sqlStrategy);
        }
        return this;
    }

    @Override
    public ClientEntityUpdatable<T> ignoreVersion(boolean ignored) {
        if (ignored) {
            this.entityUpdateExpressionBuilder.getExpressionContext().getBehavior().addBehavior(EasyBehaviorEnum.IGNORE_VERSION);
        } else {
            this.entityUpdateExpressionBuilder.getExpressionContext().getBehavior().removeBehavior(EasyBehaviorEnum.IGNORE_VERSION);
        }
        return this;
    }

    @Override
    public String toSQL(Object entity) {
        return this.toSQL(entity, DefaultToSQLContext.defaultToSQLContext(this.entityUpdateExpressionBuilder.getExpressionContext().getTableContext(), false));
    }

    @Override
    public String toSQL(Object entity, ToSQLContext toSQLContext) {
        return this.entityUpdateExpressionBuilder.toExpression(entity).toSQL(toSQLContext);
    }
}

