/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.extension.conversion;

import com.easy.query.core.basic.extension.conversion.SQLPropertyConverter;
import com.easy.query.core.basic.jdbc.parameter.ToSQLContext;
import com.easy.query.core.expression.lambda.SQLExpression1;
import com.easy.query.core.expression.parser.core.available.TableAvailable;
import com.easy.query.core.expression.parser.core.base.scec.SQLNativePropertyExpressionContext;
import com.easy.query.core.expression.parser.core.base.scec.SQLNativePropertyExpressionContextImpl;
import com.easy.query.core.expression.segment.SQLNativeSegment;
import com.easy.query.core.expression.segment.scec.context.SQLNativeExpressionContextImpl;
import com.easy.query.core.expression.sql.builder.ExpressionContext;
import java.util.Objects;

public class DefaultSQLPropertyConverter
implements SQLPropertyConverter {
    private final TableAvailable table;
    private final ExpressionContext expressionContext;
    private final boolean ignoreAlias;
    private SQLNativeSegment columnSegment;

    public DefaultSQLPropertyConverter(TableAvailable table, ExpressionContext expressionContext) {
        this(table, expressionContext, false);
    }

    public DefaultSQLPropertyConverter(TableAvailable table, ExpressionContext expressionContext, boolean ignoreAlias) {
        this.table = table;
        this.expressionContext = expressionContext;
        this.ignoreAlias = ignoreAlias;
    }

    public SQLNativeSegment getColumnSegment() {
        return this.columnSegment;
    }

    @Override
    public void sqlNativeSegment(String sqlSegment, SQLExpression1<SQLNativePropertyExpressionContext> contextConsume) {
        Objects.requireNonNull(sqlSegment, "sqlSegment can not be null");
        Objects.requireNonNull(contextConsume, "sqlExpression can not be null");
        SQLNativeExpressionContextImpl sqlNativeExpressionContext = new SQLNativeExpressionContextImpl(this.expressionContext, this.expressionContext.getRuntimeContext());
        SQLNativePropertyExpressionContextImpl sqlNativePropertyExpressionContext = new SQLNativePropertyExpressionContextImpl(this.table, sqlNativeExpressionContext);
        contextConsume.apply(sqlNativePropertyExpressionContext);
        if (this.ignoreAlias) {
            sqlNativeExpressionContext.setAlias(null);
        }
        this.columnSegment = this.expressionContext.getRuntimeContext().getSQLSegmentFactory().createSQLNativeSegment(this.expressionContext, sqlSegment, sqlNativeExpressionContext);
    }

    @Override
    public TableAvailable getTable() {
        return this.table;
    }

    @Override
    public String toSQL(ToSQLContext toSQLContext) {
        Objects.requireNonNull(this.columnSegment, "columnSegment can not be null");
        return this.columnSegment.toSQL(toSQLContext);
    }
}

