/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.extension.track;

import com.easy.query.core.basic.extension.conversion.ValueConverter;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.util.EasyBeanUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyMapUtil;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasyStringUtil;
import com.easy.query.core.util.EasyTrackUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTrackContext
implements TrackContext {
    private final EntityMetadataManager entityMetadataManager;
    private int beginCount = 0;
    private final ConcurrentHashMap<Class<?>, ConcurrentHashMap<String, EntityState>> trackEntityMap = new ConcurrentHashMap();

    public DefaultTrackContext(EntityMetadataManager entityMetadataManager) {
        this.entityMetadataManager = entityMetadataManager;
    }

    @Override
    public void begin() {
        ++this.beginCount;
    }

    @Override
    public boolean isTrack(Object entity) {
        return this.getTrackEntityState(entity) != null;
    }

    @Override
    public EntityState getTrackEntityState(Object entity) {
        if (entity == null) {
            return null;
        }
        ConcurrentHashMap<String, EntityState> entityStateTrackMap = this.trackEntityMap.get(entity.getClass());
        if (entityStateTrackMap == null || entityStateTrackMap.isEmpty()) {
            return null;
        }
        EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(entity.getClass());
        String trackKey = EasyTrackUtil.getTrackKey(entityMetadata, entity);
        if (trackKey == null) {
            return null;
        }
        return entityStateTrackMap.get(trackKey);
    }

    @Override
    public boolean addTracking(Object entity) {
        EntityState entityState = this.addInternalTracking(entity, false);
        return entityState.getCurrentValue() == entity;
    }

    @Override
    public EntityState addQueryTracking(Object entity) {
        return this.addInternalTracking(entity, true);
    }

    private EntityState addInternalTracking(Object entity, boolean isQuery) {
        if (entity == null) {
            throw new EasyQueryException("cant track null entity");
        }
        Class<?> entityClass = entity.getClass();
        EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(entityClass);
        if (EasyStringUtil.isBlank(entityMetadata.getTableName())) {
            throw new EasyQueryException(EasyClassUtil.getSimpleName(entityClass) + ": is not table entity,not allowed track");
        }
        String trackKey = EasyTrackUtil.getTrackKey(entityMetadata, entity);
        if (trackKey == null) {
            throw new EasyQueryException(EasyClassUtil.getSimpleName(entityClass) + ": current entity cant get track key,primary maybe null");
        }
        ConcurrentHashMap entityStateMap = EasyMapUtil.computeIfAbsent(this.trackEntityMap, entityClass, o -> new ConcurrentHashMap());
        EntityState originalEntityState = (EntityState)entityStateMap.get(trackKey);
        if (originalEntityState != null) {
            if (!isQuery && originalEntityState.getCurrentValue() != entity) {
                throw new EasyQueryException(EasyClassUtil.getSimpleName(entityClass) + ": current entity already tracked key,primary key:" + trackKey);
            }
            return originalEntityState;
        }
        Object original = this.createAndCopyValue(entity, entityMetadata);
        EntityState entityState = new EntityState(entityClass, trackKey, original, entity);
        entityStateMap.putIfAbsent(trackKey, entityState);
        return entityState;
    }

    @Override
    public boolean removeTracking(Object entity) {
        if (entity == null) {
            throw new EasyQueryException("cant track null entity");
        }
        if (this.trackEntityMap.isEmpty()) {
            return true;
        }
        Class<?> entityClass = entity.getClass();
        ConcurrentHashMap entityStateMap = EasyMapUtil.computeIfAbsent(this.trackEntityMap, entityClass, o -> new ConcurrentHashMap());
        if (entityStateMap.isEmpty()) {
            return true;
        }
        EntityMetadata entityMetadata = this.entityMetadataManager.getEntityMetadata(entityClass);
        if (EasyStringUtil.isBlank(entityMetadata.getTableName())) {
            throw new EasyQueryException(EasyClassUtil.getSimpleName(entityClass) + ": is not table entity,cant tracking");
        }
        String trackKey = EasyTrackUtil.getTrackKey(entityMetadata, entity);
        if (trackKey == null) {
            throw new EasyQueryException(EasyClassUtil.getSimpleName(entityClass) + ": current entity cant get track key,primary maybe null");
        }
        entityStateMap.remove(trackKey);
        return true;
    }

    @Override
    public boolean hasTracked(Class<?> entityClass) {
        ConcurrentHashMap<String, EntityState> entityStateMap = this.trackEntityMap.get(entityClass);
        if (entityStateMap == null) {
            return false;
        }
        return !entityStateMap.isEmpty();
    }

    private Object createAndCopyValue(Object entity, EntityMetadata entityMetadata) {
        Object original = entityMetadata.getBeanConstructorCreator().get();
        for (Map.Entry<String, ColumnMetadata> columnMetadataEntry : entityMetadata.getProperty2ColumnMap().entrySet()) {
            Object value;
            ColumnMetadata columnMetadata = columnMetadataEntry.getValue();
            Class<?> propertyType = columnMetadata.getPropertyType();
            if (EasyClassUtil.isBasicType(propertyType) || EasyClassUtil.isEnumType(propertyType)) {
                value = EasyBeanUtil.getPropertyValue(entity, entityMetadata, columnMetadata);
                EasyBeanUtil.setPropertyValue(original, entityMetadata, columnMetadata, value, false);
                continue;
            }
            value = columnMetadata.isValueObject() ? columnMetadata.getBeanConstructorCreatorOrNull().get() : EasyBeanUtil.getPropertyValue(entity, entityMetadata, columnMetadata);
            ValueConverter<?, ?> valueConverter = columnMetadata.getValueConverter();
            Object serializeValue = valueConverter.serialize(EasyObjectUtil.typeCastNullable(value), columnMetadata);
            Object deserialize = valueConverter.deserialize(EasyObjectUtil.typeCastNullable(serializeValue), columnMetadata);
            EasyBeanUtil.setPropertyValue(original, entityMetadata, columnMetadata, deserialize, false);
        }
        return original;
    }

    @Override
    public void release() {
        if (this.beginCount > 0) {
            --this.beginCount;
        }
        if (this.beginCount == 0) {
            this.trackEntityMap.clear();
        }
    }
}

