/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.conn.impl;

import com.easy.query.core.basic.jdbc.conn.EasyConnection;
import com.easy.query.core.enums.conn.ConnectionStrategyEnum;
import com.easy.query.core.exception.EasyQueryException;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;

public class DefaultEasyConnection
implements EasyConnection {
    private static final Log log = LogFactory.getLog(DefaultEasyConnection.class);
    private final String dataSourceName;
    private final ConnectionStrategyEnum connectionStrategy;
    private final Connection connection;
    private final Integer isolationLevel;
    private boolean closed = false;

    public DefaultEasyConnection(String dataSourceName, ConnectionStrategyEnum connectionStrategy, Connection connection, Integer isolationLevel) {
        this.dataSourceName = dataSourceName;
        this.connectionStrategy = connectionStrategy;
        this.connection = connection;
        this.isolationLevel = isolationLevel;
        this.setIsolationLevel();
    }

    @Override
    public ConnectionStrategyEnum getConnectionStrategy() {
        return this.connectionStrategy;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    private void setIsolationLevel() {
        if (!this.closed && this.isolationLevel != null) {
            try {
                this.connection.setTransactionIsolation(this.isolationLevel);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) {
        try {
            this.connection.setAutoCommit(autoCommit);
        }
        catch (SQLException e) {
            throw new EasyQueryException(e);
        }
    }

    @Override
    public void commit() throws SQLException {
        this.connection.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.connection.rollback();
    }

    @Override
    public boolean isClosed() {
        try {
            return this.connection.isClosed();
        }
        catch (SQLException e) {
            throw new EasyQueryException(e);
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    public void close(boolean closeConnection) {
        if (this.closed) {
            return;
        }
        if (this.connection != null) {
            try {
                if (!this.connection.isClosed() && closeConnection) {
                    this.connection.close();
                }
            }
            catch (SQLException ex) {
                log.error("close connection error.", ex);
            }
        }
        this.closed = true;
    }
}

