/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.command.abstraction;

import com.easy.query.core.basic.jdbc.executor.internal.command.abstraction.AbstractJdbcCommand;
import com.easy.query.core.basic.jdbc.executor.internal.common.ExecutionUnit;
import com.easy.query.core.basic.jdbc.executor.internal.result.QueryExecuteResult;
import com.easy.query.core.basic.jdbc.executor.internal.result.impl.DefaultCommandQueryExecuteResult;
import com.easy.query.core.exception.EasyQueryRouteNotMatchException;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.sharding.context.StreamMergeContext;
import com.easy.query.core.util.EasyCollectionUtil;
import java.sql.SQLException;
import java.util.List;

public abstract class AbstractQueryJdbcCommand
extends AbstractJdbcCommand<QueryExecuteResult> {
    private static final Log log = LogFactory.getLog(AbstractQueryJdbcCommand.class);

    public AbstractQueryJdbcCommand(StreamMergeContext streamMergeContext) {
        super(streamMergeContext);
    }

    @Override
    public QueryExecuteResult execute() throws SQLException {
        List<ExecutionUnit> executionUnits;
        if (this.streamMergeContext.isSharding() && EasyCollectionUtil.isEmpty(executionUnits = this.streamMergeContext.getExecutionUnits())) {
            if (this.streamMergeContext.getEasyQueryOption().isThrowIfRouteNotMatch()) {
                throw new EasyQueryRouteNotMatchException("sharding query route not match");
            }
            if (!this.streamMergeContext.isQuery()) {
                throw new EasyQueryRouteNotMatchException("sharding execute route not match");
            }
            log.debug("sharding route empty result default");
            return this.defaultResult();
        }
        return (QueryExecuteResult)super.execute();
    }

    @Override
    protected QueryExecuteResult defaultResult() {
        return DefaultCommandQueryExecuteResult.EMPTY;
    }
}

