/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.enumerable;

import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.executor.ResultMetadata;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.AbstractMapToStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.props.BasicJdbcProperty;
import com.easy.query.core.basic.jdbc.executor.internal.props.JdbcProperty;
import com.easy.query.core.basic.jdbc.types.JdbcTypeHandlerManager;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyObjectUtil;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class BasicStreamIterator<T>
extends AbstractMapToStreamIterator<T> {
    private JdbcProperty dataReader;
    private JdbcTypeHandler handler;

    public BasicStreamIterator(ExecutorContext context, StreamResultSet streamResult, ResultMetadata<T> resultMetadata) throws SQLException {
        super(context, streamResult, resultMetadata);
    }

    @Override
    protected void init0() throws SQLException {
        ResultSetMetaData rsmd = this.streamResultSet.getMetaData();
        int columnCount = rsmd.getColumnCount();
        if (columnCount != 1) {
            throw new SQLException("result set column count:" + EasyClassUtil.getSimpleName(this.resultMetadata.getResultClass()) + ",expect one column");
        }
        this.dataReader = new BasicJdbcProperty(0, this.resultMetadata.getResultClass());
        JdbcTypeHandlerManager easyJdbcTypeHandler = this.context.getRuntimeContext().getJdbcTypeHandlerManager();
        this.handler = easyJdbcTypeHandler.getHandler(this.resultMetadata.getResultClass());
    }

    @Override
    protected T mapTo() throws SQLException {
        Object value = this.handler.getValue(this.dataReader, this.streamResultSet);
        return (T)EasyObjectUtil.typeCastNullable(value);
    }
}

