/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.enumerable;

import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.TrackManager;
import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.executor.ResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.ResultMetadata;
import com.easy.query.core.basic.jdbc.executor.impl.def.RelationExtraResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.AbstractMapToStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.reader.BeanDataReader;
import com.easy.query.core.basic.jdbc.executor.internal.reader.DataReader;
import com.easy.query.core.basic.jdbc.executor.internal.reader.EmptyDataReader;
import com.easy.query.core.basic.jdbc.executor.internal.reader.PropertyDataReader;
import com.easy.query.core.basic.jdbc.executor.internal.reader.RelationExtraPropertyDataReader;
import com.easy.query.core.common.KeywordTool;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.metadata.RelationExtraColumn;
import com.easy.query.core.metadata.RelationExtraMetadata;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyObjectUtil;
import com.easy.query.core.util.EasyTrackUtil;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;

public class DefaultBeanStreamIterator<T>
extends AbstractMapToStreamIterator<T> {
    private static final Log log = LogFactory.getLog(DefaultBeanStreamIterator.class);
    protected boolean trackBean;
    protected TrackManager trackManager;
    protected DataReader dataReader;
    protected RelationExtraMetadata relationExtraMetadata;

    public DefaultBeanStreamIterator(ExecutorContext context, StreamResultSet streamResult, ResultMetadata<T> resultMetadata) throws SQLException {
        super(context, streamResult, resultMetadata);
    }

    @Override
    protected void init0() throws SQLException {
        ResultSetMetaData rsmd = this.streamResultSet.getMetaData();
        if (this.context.getExpressionContext().hasRelationExtraMetadata()) {
            this.relationExtraMetadata = this.context.getExpressionContext().getRelationExtraMetadata();
        }
        this.dataReader = this.getColumnDataReader(rsmd);
        this.trackBean = EasyTrackUtil.trackBean(this.context, this.resultMetadata.getResultClass());
        this.trackManager = this.trackBean ? this.context.getRuntimeContext().getTrackManager() : null;
    }

    @Override
    protected T next0() throws SQLException {
        EntityState entityState;
        Object entityStateCurrentValue;
        T bean = this.mapTo();
        if (this.hasForEach) {
            this.context.getExpressionContext().getForEachConfigurer().accept(bean);
        }
        if (this.trackBean && bean != null && (entityStateCurrentValue = (entityState = this.trackManager.getCurrentTrackContext().addQueryTracking(bean)).getCurrentValue()) != bean) {
            log.warn("current object tracked,return the traced object instead of the current querying object,track key:" + entityState.getTrackKey());
            return (T)EasyObjectUtil.typeCastNullable(entityStateCurrentValue);
        }
        return bean;
    }

    @Override
    protected T mapTo() throws SQLException {
        Object bean = this.resultMetadata.newBean();
        if (this.relationExtraMetadata != null) {
            this.relationExtraMetadata.createRow();
        }
        this.dataReader.readTo(bean, this.streamResultSet);
        return (T)bean;
    }

    private DataReader getColumnDataReader(ResultSetMetaData rsmd) throws SQLException {
        boolean mapToBeanStrict = this.context.isMapToBeanStrict();
        int columnCount = rsmd.getColumnCount();
        DataReader dataReader = EmptyDataReader.EMPTY;
        for (int i = 0; i < columnCount; ++i) {
            String colName = this.getColName(rsmd, i + 1);
            if (KeywordTool.isIgnoreColumn(colName)) continue;
            ResultColumnMetadata resultColumnMetadata = this.getMapColumnMetadata(i, colName, mapToBeanStrict);
            if (resultColumnMetadata == null) {
                if (this.relationExtraMetadata != null) {
                    Map<String, RelationExtraColumn> relationExtraColumnMap = this.relationExtraMetadata.getRelationExtraColumnMap();
                    RelationExtraColumn relationExtraColumn = relationExtraColumnMap.get(colName);
                    if (relationExtraColumn != null) {
                        RelationExtraResultColumnMetadata relationExtraResultColumnMetadata = new RelationExtraResultColumnMetadata(i, this.relationExtraMetadata, relationExtraColumn);
                        dataReader = new BeanDataReader(dataReader, new RelationExtraPropertyDataReader(relationExtraResultColumnMetadata));
                        continue;
                    }
                    if (!this.easyQueryOption.isWarningColumnMiss()) continue;
                    log.warn("sql result column name:[" + colName + "] mapping miss in class:[" + EasyClassUtil.getSimpleName(this.resultMetadata.getResultClass()) + "]");
                    continue;
                }
                if (!this.easyQueryOption.isWarningColumnMiss()) continue;
                log.warn("sql result column name:[" + colName + "] mapping miss in class:[" + EasyClassUtil.getSimpleName(this.resultMetadata.getResultClass()) + "]");
                continue;
            }
            dataReader = new BeanDataReader(dataReader, new PropertyDataReader(resultColumnMetadata));
        }
        return dataReader;
    }

    private ResultColumnMetadata getMapColumnMetadata(int index, String columnName, boolean mapToBeanStrict) {
        ResultColumnMetadata resultColumnMetadata = this.resultMetadata.getResultColumnOrNullByColumnName(index, columnName);
        if (resultColumnMetadata != null) {
            return resultColumnMetadata;
        }
        if (!mapToBeanStrict) {
            return this.resultMetadata.getResultColumnOrNullByPropertyName(index, columnName);
        }
        return null;
    }
}

