/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.enumerable;

import com.easy.query.core.basic.jdbc.executor.internal.enumerable.JdbcResult;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.JdbcStreamResult;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.StreamIterable;
import com.easy.query.core.exception.EasyQuerySQLCommandException;
import com.easy.query.core.logging.Log;
import com.easy.query.core.logging.LogFactory;
import com.easy.query.core.util.EasyCollectionUtil;
import java.sql.SQLException;
import java.util.List;

public class DefaultJdbcResult<TR>
implements JdbcResult<TR> {
    private static final Log log = LogFactory.getLog(DefaultJdbcResult.class);
    private final JdbcStreamResult<TR> jdbcStreamResult;

    public DefaultJdbcResult(JdbcStreamResult<TR> jdbcStreamResult) {
        this.jdbcStreamResult = jdbcStreamResult;
    }

    @Override
    public JdbcStreamResult<TR> getJdbcStreamResult() {
        return this.jdbcStreamResult;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<TR> toList() {
        try (JdbcStreamResult<TR> jdbcStreamResultSet = this.jdbcStreamResult;){
            StreamIterable<TR> streamResult = jdbcStreamResultSet.getStreamIterable();
            List<TR> list = EasyCollectionUtil.newArrayList(streamResult);
            if (this.jdbcStreamResult.getExecutorContext().getEasyQueryOption().isPrintSql()) {
                log.info("<== Total: " + list.size());
            }
            List<TR> list2 = list;
            return list2;
        }
        catch (SQLException e) {
            throw new EasyQuerySQLCommandException(e);
        }
    }
}

