/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.core.basic.jdbc.executor.internal.enumerable;

import com.easy.query.core.annotation.Nullable;
import com.easy.query.core.basic.jdbc.executor.ExecutorContext;
import com.easy.query.core.basic.jdbc.executor.ResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.ResultMetadata;
import com.easy.query.core.basic.jdbc.executor.impl.def.BasicResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.impl.def.EntityResultColumnMetadata;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.AbstractMapToStreamIterator;
import com.easy.query.core.basic.jdbc.executor.internal.enumerable.DraftResult;
import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.props.JdbcProperty;
import com.easy.query.core.basic.jdbc.types.JdbcTypeHandlerManager;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyJdbcExecutorUtil;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class DraftStreamIterator
extends AbstractMapToStreamIterator<DraftResult> {
    private ResultSetMetaData rsmd;
    private ResultColumnMetadata[] resultBasicMetadatas;
    private int mapCount = -1;

    public DraftStreamIterator(ExecutorContext context, StreamResultSet streamResult, ResultMetadata<DraftResult> resultMetadata) throws SQLException {
        super(context, streamResult, resultMetadata);
    }

    @Override
    protected void init0() throws SQLException {
        this.rsmd = this.streamResultSet.getMetaData();
        int columnCount = this.rsmd.getColumnCount();
        this.resultBasicMetadatas = new ResultColumnMetadata[columnCount];
    }

    @Nullable
    private ResultColumnMetadata getDraftPropType(int index) {
        ResultColumnMetadata[] draftPropTypes = this.context.getExpressionContext().getResultPropTypes();
        if (draftPropTypes != null) {
            return draftPropTypes[index];
        }
        return null;
    }

    @Override
    protected DraftResult mapTo() throws SQLException {
        ++this.mapCount;
        Class clazz = this.resultMetadata.getResultClass();
        DraftResult draft = (DraftResult)EasyClassUtil.newInstance(clazz);
        JdbcTypeHandlerManager easyJdbcTypeHandler = this.context.getRuntimeContext().getJdbcTypeHandlerManager();
        if (this.mapCount == 0) {
            this.resultBasicMetadatas = new ResultColumnMetadata[draft.capacity()];
        }
        for (int i = 0; i < this.resultBasicMetadatas.length && draft.readColumn(i); ++i) {
            ResultColumnMetadata resultColumnMetadata;
            ResultColumnMetadata propType;
            if (this.mapCount == 0 && (propType = this.getDraftPropType(i)) != null) {
                this.resultBasicMetadatas[i] = propType instanceof EntityResultColumnMetadata ? propType : new BasicResultColumnMetadata(propType.getPropertyType(), easyJdbcTypeHandler.getHandler(propType.getPropertyType()), propType.getJdbcProperty());
            }
            if ((resultColumnMetadata = this.resultBasicMetadatas[i]) == null) {
                draft.setValues(i, this.streamResultSet.getObject(i + 1));
                continue;
            }
            if (resultColumnMetadata instanceof EntityResultColumnMetadata) {
                JdbcTypeHandler handler = resultColumnMetadata.getJdbcTypeHandler();
                JdbcProperty jdbcProperty = resultColumnMetadata.getJdbcProperty();
                Object value = EasyJdbcExecutorUtil.fromValue(resultColumnMetadata, handler.getValue(jdbcProperty, this.streamResultSet));
                draft.setValues(i, value);
                continue;
            }
            Object value = resultColumnMetadata.getJdbcTypeHandler().getValue(resultColumnMetadata.getJdbcProperty(), this.streamResultSet);
            draft.setValues(i, value);
        }
        return draft;
    }
}

